# 通知設計書 15-リターンコード98

## 概要

本ドキュメントは、GENAPPアプリケーションにおけるリターンコード98（COMMAREAサイズ不足エラー）通知の設計仕様を定義します。

### 本通知の処理概要

本通知は、CICSプログラム間通信で使用されるCOMMAREA（通信領域）のサイズが、返却するデータを格納するのに不足している場合に発行されるエラー通知です。

**業務上の目的・背景**：CICS環境において、プログラム間のデータ受け渡しはCOMMAREAを通じて行われます。照会処理の結果データがCOMMAREAの割り当てサイズを超える場合、データの切り捨てが発生し、業務データの整合性に問題が生じます。このエラーを通知することで、呼び出し元プログラムの修正やシステム設計の見直しが必要であることを示します。

**通知の送信タイミング**：照会処理でデータベースからデータを取得した後、COMMAREAサイズ（EIBCALEN）と必要なデータサイズを比較し、サイズ不足が検出された時点で即時発生します。複数のプログラム（LGACUS01、LGACDB01、LGDPDB01、LGAPDB01、LGACDB02、LGDPOL01、LGICUS01、LGIPDB01、LGUPOL01、LGAPOL01、LGICDB01）で使用されます。

**通知の受信者**：リターンコードとして呼び出し元プログラムに返却されます。最終的には画面プログラムまたはAPIを通じてシステム運用担当者や開発者に伝達されます。

**通知内容の概要**：CA-RETURN-CODEに'98'がセットされ、呼び出し元に返却されます。ログ出力は行われません。

**期待されるアクション**：開発者はCOMMAREA定義の見直し、呼び出し元プログラムのバッファサイズ拡張、または取得データ量の制限を検討します。

## 通知種別

リターンコード通知（COMMAREA経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（即時リターン） |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

呼び出し元プログラムにCOMMAREA経由でリターンコード'98'を返却します。ログ出力は行われません。

## 通知テンプレート

### リターンコードの場合

| 項目 | 内容 |
|-----|------|
| フィールド名 | CA-RETURN-CODE |
| 値 | '98' |
| 形式 | 2桁文字列 |

### ログ出力

本リターンコードではログ出力は行われません。エラーメッセージをキューに出力せず、即座にCICS RETURNで呼び出し元に制御を返します。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| CA-RETURN-CODE | リターンコード | 固定値'98' | Yes |
| EIBCALEN | 受信COMMAREAサイズ | CICSシステム変数 | Yes |
| WS-REQUIRED-CA-LEN | 必要COMMAREAサイズ | プログラム計算値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| COMMAREA照会 | 顧客照会（LGACUS01） | EIBCALEN < WS-REQUIRED-CA-LEN | 顧客データ返却に必要なサイズ不足 |
| COMMAREA照会 | 顧客追加（LGACDB01） | EIBCALEN < WS-REQUIRED-CA-LEN | 顧客データ確認に必要なサイズ不足 |
| COMMAREA照会 | ポリシー削除（LGDPDB01） | EIBCALEN < WS-REQUIRED-CA-LEN | 削除確認に必要なサイズ不足 |
| COMMAREA照会 | ポリシー追加（LGAPDB01） | EIBCALEN < WS-REQUIRED-CA-LEN | ポリシーデータに必要なサイズ不足 |
| COMMAREA照会 | ポリシー削除（LGDPOL01） | EIBCALEN < WS-REQUIRED-CA-LEN | 削除確認に必要なサイズ不足 |
| COMMAREA照会 | 顧客照会（LGICUS01） | EIBCALEN < WS-REQUIRED-CA-LEN | 顧客データ返却に必要なサイズ不足 |
| COMMAREA照会 | ポリシー照会（LGIPDB01） | EIBCALEN < WS-REQUIRED-CA-LEN | 各種保険データ返却に必要なサイズ不足 |
| COMMAREA照会 | ポリシー更新（LGUPOL01） | EIBCALEN < WS-REQUIRED-CA-LEN | 更新データに必要なサイズ不足 |
| COMMAREA照会 | ポリシー追加（LGAPOL01） | EIBCALEN < WS-REQUIRED-CA-LEN | ポリシーデータに必要なサイズ不足 |
| COMMAREA照会 | 顧客照会（LGICDB01） | EIBCALEN < WS-REQUIRED-CA-LEN | 顧客データ返却に必要なサイズ不足 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| EIBCALEN >= WS-REQUIRED-CA-LEN | COMMAREAサイズが十分な場合は正常処理続行 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[データ取得完了] --> B[必要COMMAREAサイズ計算]
    B --> C{EIBCALEN >= 必要サイズ?}
    C -->|Yes| D[データをCOMMAREAに格納]
    C -->|No| E[CA-RETURN-CODE = '98']
    D --> F[正常終了]
    E --> G[EXEC CICS RETURN]
    G --> H[呼び出し元へ制御を返す]
```

### LGIPDB01での具体的な処理例

```mermaid
flowchart TD
    A[SQL SELECTで保険データ取得] --> B[WS-CA-HEADERTRAILER-LEN + 保険種別サイズ計算]
    B --> C[VARCHAR長がある場合は追加]
    C --> D{EIBCALEN < WS-REQUIRED-CA-LEN?}
    D -->|Yes| E[CA-RETURN-CODE = '98']
    E --> F[EXEC CICS RETURN]
    D -->|No| G[データをCOMMAREAにMOVE]
    G --> H['FINAL'マーカーを設定]
    H --> I[正常終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| CUSTOMER | 顧客情報取得 | LGACUS01, LGICUS01, LGICDB01等 |
| POLICY | ポリシー基本情報取得 | LGIPDB01, LGDPDB01等 |
| ENDOWMENT | 養老保険情報取得 | 可変長フィールドあり |
| HOUSE | 住宅保険情報取得 | 固定長フィールド |
| MOTOR | 自動車保険情報取得 | 固定長フィールド |
| COMMERCIAL | 商業用不動産保険情報取得 | 固定長フィールド |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | サイズチェックのみ、更新は行わない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| COMMAREAサイズ不足 | EIBCALEN < WS-REQUIRED-CA-LEN | リターンコード98で呼び出し元に通知 |

### COMMAREAサイズ要件（参考）

| 保険種別 | 固定部分サイズ | 可変部分 | 合計目安 |
|---------|--------------|---------|---------|
| ヘッダー/トレーラー | 33バイト | - | 33バイト |
| 養老保険 | 基本サイズ | PADDINGDATAの長さ | 可変 |
| 住宅保険 | WS-FULL-HOUSE-LEN | - | 固定 |
| 自動車保険 | WS-FULL-MOTOR-LEN | - | 固定 |
| 商業用不動産 | WS-FULL-COMM-LEN | - | 固定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし（設計変更が必要） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（エラー発生時は即時リターン）

## セキュリティ考慮事項

- リターンコードのみの通知のため、個人情報は含まれません
- ログ出力がないため、トラブルシューティングには呼び出し元でのログ記録が必要です

## 備考

- 本リターンコードは、データサイズが可変長である養老保険（ENDOWMENT）の照会で特に発生しやすいです
- LGIPDB01ではPADDINGDATAフィールドの長さに応じて必要サイズが変動します
- 呼び出し元プログラムは、このエラーを受け取った場合、COMMAREAサイズを拡張して再度呼び出すか、エラーとしてユーザーに通知する必要があります
- ABENDは発行されず、EXEC CICS RETURNで呼び出し元に制御を返します
- ログ出力（TDQ/TSQ）は行われないため、このエラーの発生頻度を監視する場合は呼び出し元でのログ記録が必要です

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: リターンコード98の設定箇所を理解する

COMMAREAサイズ不足時のリターンコード98設定処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgipdb01.cbl | `base/src/lgipdb01.cbl` | 行391, 488, 582, 690, 794でCOMMAREAサイズ不足時に'98'を設定 |
| 1-2 | lgicdb01.cbl | `base/src/lgicdb01.cbl` | 行141でCOMMAREAサイズ不足時に'98'を設定 |
| 1-3 | lgacus01.cbl | `base/src/lgacus01.cbl` | 行113でCOMMAREAサイズ不足時に'98'を設定 |
| 1-4 | lgicus01.cbl | `base/src/lgicus01.cbl` | 行105でCOMMAREAサイズ不足時に'98'を設定 |
| 1-5 | lgapdb01.cbl | `base/src/lgapdb01.cbl` | 行211でCOMMAREAサイズ不足時に'98'を設定 |
| 1-6 | lgdpdb01.cbl | `base/src/lgdpdb01.cbl` | 行144でCOMMAREAサイズ不足時に'98'を設定 |

**リターンコード98設定**（lgipdb01.cbl 行391）:
```cobol
IF EIBCALEN < WS-REQUIRED-CA-LEN   ... COMMAREAサイズ判定
  MOVE '98' TO CA-RETURN-CODE       ... リターンコード98設定
  EXEC CICS RETURN END-EXEC         ... 即時リターン（ログ出力なし）
END-IF
```

**COMMAREAサイズ計算**（lgipdb01.cbl 行385-390）:
```cobol
ADD WS-CA-HEADERTRAILER-LEN        ... ヘッダー/トレーラーサイズ
    WS-FULL-ENDOW-LEN              ... 養老保険固定サイズ
    DB2-PADDINGDATA-LEN            ... 可変長データサイズ
    GIVING WS-REQUIRED-CA-LEN      ... 必要サイズを計算
```

### プログラム呼び出し階層図

```
画面プログラム / Webサービス
    │
    └─ LINK LGxxOL01/LGxxUS01（業務プログラム）
           │
           └─ LINK LGxxDB01（DB2アクセスプログラム）
                  │
                  ├─ EXEC SQL SELECT ... （データ取得）
                  │
                  ├─ 必要COMMAREAサイズ計算
                  │      │
                  │      └─ EIBCALEN < WS-REQUIRED-CA-LEN
                  │             ├─ MOVE '98' TO CA-RETURN-CODE
                  │             └─ EXEC CICS RETURN（ログ出力なし）
                  │
                  └─ 呼び出し元に戻る（CA-RETURN-CODE='98'）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgipdb01.cbl | `base/src/lgipdb01.cbl` | ソース | ポリシー照会（DB2）- リターンコード98設定（行391, 488, 582, 690, 794） |
| lgicdb01.cbl | `base/src/lgicdb01.cbl` | ソース | 顧客照会（DB2）- リターンコード98設定（行141） |
| lgacus01.cbl | `base/src/lgacus01.cbl` | ソース | 顧客追加（ルータ）- リターンコード98設定（行113） |
| lgicus01.cbl | `base/src/lgicus01.cbl` | ソース | 顧客照会（ルータ）- リターンコード98設定（行105） |
| lgapdb01.cbl | `base/src/lgapdb01.cbl` | ソース | ポリシー追加（DB2）- リターンコード98設定（行211） |
| lgdpdb01.cbl | `base/src/lgdpdb01.cbl` | ソース | ポリシー削除（DB2）- リターンコード98設定（行144） |
| lgdpol01.cbl | `base/src/lgdpol01.cbl` | ソース | ポリシー削除（ルータ）- リターンコード98設定（行108） |
| lgapol01.cbl | `base/src/lgapol01.cbl` | ソース | ポリシー追加（ルータ）- リターンコード98設定（行114） |
| lgupol01.cbl | `base/src/lgupol01.cbl` | ソース | ポリシー更新（ルータ）- リターンコード98設定（行119, 127, 135） |
