# 通知設計書 16-リターンコード99

## 概要

本ドキュメントは、GENAPPアプリケーションにおけるリターンコード99（無効なリクエストID）通知の設計仕様を定義します。

### 本通知の処理概要

本通知は、COMMAREAで受け取ったCA-REQUEST-IDが、プログラムが認識できない値であった場合に発行されるエラー通知です。プログラムのEVALUATE文で定義された有効なリクエストIDに一致しない場合に発生します。

**業務上の目的・背景**：GENAPPアプリケーションでは、リクエストIDによって処理内容（照会、追加、更新、削除）および対象データ種別（顧客、養老保険、住宅保険、自動車保険、商業用不動産保険）を識別します。無効なリクエストIDが渡された場合、システムは要求された処理を特定できません。このエラーを通知することで、呼び出し元プログラムのバグや設定ミスを検出できます。

**通知の送信タイミング**：プログラム起動後、CA-REQUEST-IDをEVALUATE文で評価し、WHEN OTHER節に到達した時点で発生します。複数のプログラム（LGACDB02、LGUCUS01、LGIPDB01、LGAPDB01、LGASTAT1、LGDPDB01、LGUPOL01、LGDPOL01）で使用されます。

**通知の受信者**：リターンコードとして呼び出し元プログラムに返却されます。最終的には画面プログラムまたはAPIを通じてシステム運用担当者や開発者に伝達されます。

**通知内容の概要**：CA-RETURN-CODEに'99'がセットされ、呼び出し元に返却されます。ログ出力は通常行われません。

**期待されるアクション**：開発者は呼び出し元プログラムのCA-REQUEST-ID設定を確認し、有効なリクエストIDを使用するよう修正します。

## 通知種別

リターンコード通知（COMMAREA経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（即時リターン） |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

呼び出し元プログラムにCOMMAREA経由でリターンコード'99'を返却します。

## 通知テンプレート

### リターンコードの場合

| 項目 | 内容 |
|-----|------|
| フィールド名 | CA-RETURN-CODE |
| 値 | '99' |
| 形式 | 2桁文字列 |

### ログ出力

本リターンコードでは、通常ログ出力は行われません。EXEC CICS RETURNで呼び出し元に制御を返します。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| CA-RETURN-CODE | リターンコード | 固定値'99' | Yes |
| CA-REQUEST-ID | 受信したリクエストID | COMMAREA | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| REQUEST-ID評価 | ポリシー照会（LGIPDB01） | WHEN OTHER | 01IEND,01IHOU,01IMOT,01ICOM,02ICOM,03ICOM,05ICOM以外 |
| REQUEST-ID評価 | ポリシー追加（LGAPDB01） | WHEN OTHER | 01AEND,01AHOU,01AMOT,01ACOM以外 |
| REQUEST-ID評価 | ポリシー削除（LGDPDB01） | WHEN OTHER | 01DEND,01DHOU,01DMOT,01DCOM以外 |
| REQUEST-ID評価 | 顧客更新（LGUCUS01） | WHEN OTHER | 01UCUS以外 |
| REQUEST-ID評価 | ポリシー更新（LGUPOL01） | WHEN OTHER | 01UEND,01UHOU,01UMOT以外 |
| REQUEST-ID評価 | ポリシー削除（LGDPOL01） | WHEN OTHER | 01DEND,01DHOU,01DMOT以外 |
| REQUEST-ID評価 | 統計（LGASTAT1） | GENAType Not = '00' | 無効な統計タイプ |
| REQUEST-ID評価 | 顧客追加（LGACDB02） | WHEN OTHER | 有効なリクエストID以外 |

### 有効なリクエストID一覧

| プログラム | 有効なリクエストID | 説明 |
|-----------|------------------|------|
| LGIPDB01 | 01IEND | 養老保険照会 |
| LGIPDB01 | 01IHOU | 住宅保険照会 |
| LGIPDB01 | 01IMOT | 自動車保険照会 |
| LGIPDB01 | 01ICOM | 商業用不動産保険照会（顧客+ポリシー） |
| LGIPDB01 | 02ICOM | 商業用不動産保険照会（ポリシーのみ） |
| LGIPDB01 | 03ICOM | 商業用不動産保険照会（顧客カーソル） |
| LGIPDB01 | 05ICOM | 商業用不動産保険照会（郵便番号カーソル） |
| LGAPDB01 | 01AEND | 養老保険追加 |
| LGAPDB01 | 01AHOU | 住宅保険追加 |
| LGAPDB01 | 01AMOT | 自動車保険追加 |
| LGAPDB01 | 01ACOM | 商業用不動産保険追加 |
| LGDPDB01 | 01DEND | 養老保険削除 |
| LGDPDB01 | 01DHOU | 住宅保険削除 |
| LGDPDB01 | 01DMOT | 自動車保険削除 |
| LGDPDB01 | 01DCOM | 商業用不動産保険削除 |
| LGUCUS01 | 01UCUS | 顧客更新 |
| LGUPOL01 | 01UEND | 養老保険更新 |
| LGUPOL01 | 01UHOU | 住宅保険更新 |
| LGUPOL01 | 01UMOT | 自動車保険更新 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 有効なリクエストID | EVALUATE文のWHEN句に一致する場合は正常処理続行 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[プログラム開始] --> B[CA-REQUEST-ID取得]
    B --> C[UPPER-CASE変換]
    C --> D[EVALUATE WS-REQUEST-ID]
    D --> E{有効なID?}
    E -->|Yes| F[対応する処理を実行]
    E -->|No WHEN OTHER| G[CA-RETURN-CODE = '99']
    F --> H[正常終了]
    G --> I[EXEC CICS RETURN]
```

### LGIPDB01での具体的な処理例

```cobol
MOVE FUNCTION UPPER-CASE(CA-REQUEST-ID) TO WS-REQUEST-ID

EVALUATE WS-REQUEST-ID
  WHEN '01IEND'
    PERFORM GET-ENDOW-DB2-INFO
  WHEN '01IHOU'
    PERFORM GET-HOUSE-DB2-INFO
  WHEN '01IMOT'
    PERFORM GET-MOTOR-DB2-INFO
  WHEN '01ICOM'
    PERFORM GET-COMMERCIAL-DB2-INFO-1
  WHEN '02ICOM'
    PERFORM GET-COMMERCIAL-DB2-INFO-2
  WHEN '03ICOM'
    PERFORM GET-COMMERCIAL-DB2-INFO-3
  WHEN '05ICOM'
    PERFORM GET-COMMERCIAL-DB2-INFO-5
  WHEN OTHER
    MOVE '99' TO CA-RETURN-CODE
END-EVALUATE.
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | リクエストID評価のみ、DB操作なし |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | リクエストID評価のみ、DB操作なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 無効なリクエストID | EVALUATE文のWHEN OTHERに到達 | リターンコード99で呼び出し元に通知 |

### 原因と対処

| 原因 | 対処方法 |
|-----|---------|
| リクエストIDのタイプミス | 正しいリクエストIDを確認して設定 |
| 大文字/小文字の不一致 | プログラムはUPPER-CASE変換を行うため通常は問題なし |
| 未サポートの処理要求 | プログラムの機能範囲を確認 |
| バージョン不一致 | 呼び出し元とサービスプログラムのバージョンを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし（設定修正が必要） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（エラー発生時は即時リターン）

## セキュリティ考慮事項

- リターンコードのみの通知のため、個人情報は含まれません
- 無効なリクエストIDが繰り返し発生する場合、不正アクセスの可能性を検討する必要があります

## 備考

- 本リターンコードは、プログラムの入力検証エラーを示します
- CA-REQUEST-IDはUPPER-CASE変換されるため、大文字/小文字の違いは通常問題になりません
- LGASTAT1では、GENATypeフィールドが'00'以外の場合に'99'がセットされます
- ABENDは発行されず、EXEC CICS RETURNで呼び出し元に制御を返します
- 開発・テスト時に発生しやすいエラーであり、本番環境では呼び出し元プログラムの十分なテストにより防止可能です

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: リターンコード99の設定箇所を理解する

無効なリクエストID検出時のリターンコード99設定処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgipdb01.cbl | `base/src/lgipdb01.cbl` | 行308でEVALUATE WHEN OTHER時に'99'を設定 |
| 1-2 | lgapdb01.cbl | `base/src/lgapdb01.cbl` | 行204, 239でEVALUATE WHEN OTHER時に'99'を設定 |
| 1-3 | lgdpdb01.cbl | `base/src/lgdpdb01.cbl` | 行165でEVALUATE WHEN OTHER時に'99'を設定 |
| 1-4 | lgupol01.cbl | `base/src/lgupol01.cbl` | 行140でEVALUATE WHEN OTHER時に'99'を設定 |
| 1-5 | lgdpol01.cbl | `base/src/lgdpol01.cbl` | 行124でEVALUATE WHEN OTHER時に'99'を設定 |
| 1-6 | lgucus01.cbl | `base/src/lgucus01.cbl` | 行111でEVALUATE WHEN OTHER時に'99'を設定 |

**リターンコード99設定**（lgipdb01.cbl 行295-308）:
```cobol
MOVE FUNCTION UPPER-CASE(CA-REQUEST-ID) TO WS-REQUEST-ID

EVALUATE WS-REQUEST-ID
  WHEN '01IEND'
    PERFORM GET-ENDOW-DB2-INFO
  WHEN '01IHOU'
    PERFORM GET-HOUSE-DB2-INFO
  WHEN '01IMOT'
    PERFORM GET-MOTOR-DB2-INFO
  ...
  WHEN OTHER
    MOVE '99' TO CA-RETURN-CODE    ... 無効なリクエストID
END-EVALUATE
```

### プログラム呼び出し階層図

```
画面プログラム / Webサービス
    │
    └─ LINK LGxxOL01（業務プログラム）
           │
           └─ LINK LGxxDB01（DB2アクセスプログラム）
                  │
                  ├─ CA-REQUEST-ID取得
                  │
                  ├─ UPPER-CASE変換
                  │
                  └─ EVALUATE WS-REQUEST-ID
                         │
                         ├─ WHEN '01IEND' → GET-ENDOW-DB2-INFO
                         ├─ WHEN '01IHOU' → GET-HOUSE-DB2-INFO
                         ├─ WHEN '01IMOT' → GET-MOTOR-DB2-INFO
                         ├─ WHEN ...
                         │
                         └─ WHEN OTHER
                                ├─ MOVE '99' TO CA-RETURN-CODE
                                └─ EXEC CICS RETURN
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgipdb01.cbl | `base/src/lgipdb01.cbl` | ソース | ポリシー照会（DB2）- リターンコード99設定（行308） |
| lgapdb01.cbl | `base/src/lgapdb01.cbl` | ソース | ポリシー追加（DB2）- リターンコード99設定（行204, 239） |
| lgdpdb01.cbl | `base/src/lgdpdb01.cbl` | ソース | ポリシー削除（DB2）- リターンコード99設定（行165） |
| lgupol01.cbl | `base/src/lgupol01.cbl` | ソース | ポリシー更新（ルータ）- リターンコード99設定（行140） |
| lgdpol01.cbl | `base/src/lgdpol01.cbl` | ソース | ポリシー削除（ルータ）- リターンコード99設定（行124） |
| lgucus01.cbl | `base/src/lgucus01.cbl` | ソース | 顧客更新（ルータ）- リターンコード99設定（行111） |
