# 通知設計書 17-統計収集開始通知

## 概要

本ドキュメントは、GENAPPアプリケーションにおける統計収集開始通知の設計仕様を定義します。

### 本通知の処理概要

本通知は、GENAPPアプリケーションの統計収集機能が開始された際に発行される情報通知です。LGWEBST5プログラムが定期的に実行され、各種カウンター値を収集してGENASTATキューに出力します。

**業務上の目的・背景**：GENAPPアプリケーションでは、システムの稼働状況を監視するために各種業務処理（照会、追加、更新、削除）の実行回数を収集しています。この統計情報は、システムの負荷状況の把握、パフォーマンス分析、キャパシティプランニングに活用されます。統計収集開始通知は、統計機能が正常に動作していることを示す重要な情報です。

**通知の送信タイミング**：LGWEBST5プログラムが起動され、統計収集処理を開始した時点で通知されます。このプログラムはCICS STARTコマンドにより1分ごとに自動的に再起動され、継続的に統計を収集します。

**通知の受信者**：CICSテンポラリストレージキュー（TSQ）のGENASTATキューに出力されます。システム監視ツールやBusiness Monitor等の統計収集システムが受信者となります。

**通知内容の概要**：アプリケーションID、各種業務カウンター値（顧客照会、追加、各保険種別の照会/追加/更新/削除回数）、成功件数、エラー件数が含まれます。

**期待されるアクション**：システム管理者は統計情報を確認し、システムの稼働状況を監視します。異常なパターンが検出された場合は、詳細調査を実施します。

## 通知種別

システム統計情報出力（CICS TSQキュー通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（TSQへの書き込み） |
| 優先度 | 低（監視目的） |
| リトライ | なし（定期実行） |

### 送信先決定ロジック

送信先は固定です。LGWEBST5プログラムがGENASTATキューに統計情報を出力します。

## 通知テンプレート

### TSQ出力の場合

| 項目 | 内容 |
|-----|------|
| 出力先TSQ | GENASTAT |
| 形式 | テキスト（シンボルリスト形式） |

### 本文テンプレート

統計情報はシンボルリスト形式で出力されます：

```
APPLID={アプリケーションID}&GENACount-V={総顧客数}&GENACNT100-V={顧客照会成功}&GENACNT199-V={顧客照会エラー}&GENACNT200-V={顧客追加成功}&GENACNT299-V={顧客追加エラー}...&GENAsucces-V={総成功件数}&GENAerrors-V={総エラー件数}&GENAstart={開始時刻}
```

### カウンター詳細

| カウンター名 | 説明 | 対応処理 |
|-------------|------|---------|
| GENACount | 総顧客数 | GENACUSTNUM |
| GENACNT100 | 顧客照会成功 | 01ICUS00 |
| GENACNT199 | 顧客照会エラー | 01ICUS99 |
| GENACNT200 | 顧客追加成功 | 01ACUS00 |
| GENACNT299 | 顧客追加エラー | 01ACUS99 |
| GENACNT300 | 自動車保険照会成功 | 01IMOT00 |
| GENACNT399 | 自動車保険照会エラー | 01IMOT99 |
| GENACNT400 | 自動車保険追加成功 | 01AMOT00 |
| GENACNT499 | 自動車保険追加エラー | 01AMOT99 |
| GENACNT500 | 自動車保険削除成功 | 01DMOT00 |
| GENACNT599 | 自動車保険削除エラー | 01DMOT99 |
| GENACNT600 | 自動車保険更新成功 | 01UMOT00 |
| GENACNT699 | 自動車保険更新エラー | 01UMOT99 |
| GENACNT700 | 養老保険照会成功 | 01IEND00 |
| GENACNT799 | 養老保険照会エラー | 01IEND99 |
| GENACNT800 | 養老保険追加成功 | 01AEND00 |
| GENACNT899 | 養老保険追加エラー | 01AEND99 |
| GENACNT900 | 養老保険削除成功 | 01DEND00 |
| GENACNT999 | 養老保険削除エラー | 01DEND99 |
| GENACNTA00 | 養老保険更新成功 | 01UEND00 |
| GENACNTA99 | 養老保険更新エラー | 01UEND99 |
| GENACNTB00 | 住宅保険照会成功 | 01IHOU00 |
| GENACNTB99 | 住宅保険照会エラー | 01IHOU99 |
| GENACNTC00 | 住宅保険追加成功 | 01AHOU00 |
| GENACNTC99 | 住宅保険追加エラー | 01AHOU99 |
| GENACNTD00 | 住宅保険削除成功 | 01DHOU00 |
| GENACNTD99 | 住宅保険削除エラー | 01DHOU99 |
| GENACNTE00 | 住宅保険更新成功 | 01UHOU00 |
| GENACNTE99 | 住宅保険更新エラー | 01UHOU99 |
| GENACNTF00 | 商業保険照会成功 | 01ICOM00 |
| GENACNTF99 | 商業保険照会エラー | 01ICOM99 |
| GENACNTG00 | 商業保険追加成功 | 01ACOM00 |
| GENACNTG99 | 商業保険追加エラー | 01ACOM99 |
| GENACNTH00 | 商業保険削除成功 | 01DCOM00 |
| GENACNTH99 | 商業保険削除エラー | 01DCOM99 |
| GENACNTI99 | その他 | GENAOTHER |
| GENAsucces | 総成功件数 | 計算値 |
| GENAerrors | 総エラー件数 | 計算値 |

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| WS-APPLID | CICSアプリケーションID | EXEC CICS ASSIGN APPLID | Yes |
| CountVal | カウンター値 | EXEC CICS QUERY COUNTER | Yes |
| WS-DATE | 収集日付 | EXEC CICS FORMATTIME MMDDYYYY | Yes |
| WS-TIME | 収集時刻 | EXEC CICS FORMATTIME TIME | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| スケジュール | CICS START | 1分経過 | 前回実行から1分後に自動起動 |
| 手動起動 | SSSトランザクション | - | 手動での統計収集起動 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 常に統計情報を出力 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[LGWEBST5起動] --> B[トランザクション情報取得]
    B --> C[現在時刻取得]
    C --> D[前回時刻との差分計算]
    D --> E[GENAカウンター照会ループ]
    E --> F[カウンター値をTSQに書き込み]
    F --> G{全カウンター処理済み?}
    G -->|No| E
    G -->|Yes| H[成功/エラー集計]
    H --> I[アプリケーションID取得]
    I --> J[次回実行をSTART]
    J --> K[CICS RETURN]
```

### カウンター処理詳細

```mermaid
flowchart TD
    A[EXEC CICS QUERY COUNTER] --> B[カウンター値取得]
    B --> C[前回値をTSQから読み込み]
    C --> D[TSQを削除]
    D --> E[新しい値をTSQに書き込み]
    E --> F[前回値をTSQに書き込み]
    F --> G[差分値を計算]
    G --> H[差分値をTSQに書き込み]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | DB2は使用しない |

### CICSリソース参照

| リソース種別 | リソース名 | 用途 |
|------------|----------|------|
| COUNTER | GENACUSTNUM | 総顧客数カウンター |
| COUNTER | GENA01ICUS00〜GENA01DCOM99 | 各種業務カウンター |
| COUNTER | GENAOTHER | その他カウンター |
| TSQ | GENA000V〜GENAX05V | 統計値保持キュー |
| TSQ | GENASTAT | 統計出力キュー |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | DB2更新なし |

### キュー出力

| キュー名 | 種別 | 操作 | 概要 |
|---------|------|------|------|
| GENASTAT | TSQ | WRITEQ TS | 統計情報出力 |
| GENA{XXX}V | TSQ | READQ/DELETEQ/WRITEQ TS | 統計値一時保持 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| カウンター取得失敗 | QUERY COUNTER失敗 | WS-RESPを確認、処理続行 |
| TSQ操作失敗 | READQ/WRITEQ/DELETEQ失敗 | WS-RESPを確認、処理続行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（エラー発生時も処理続行） |
| リトライ間隔 | なし |
| リトライ対象エラー | なし（1分後に自動再実行） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 実行間隔 | 1分 |
| 1分あたり上限 | 1回 |
| 1日あたり上限 | 約1440回 |

### 配信時間帯

制限なし（24時間継続的に収集）

## セキュリティ考慮事項

- 統計情報には個人情報は含まれませんが、システムの利用状況を示すため、アクセス制限を検討する必要があります
- GENASTATキューへのアクセス権限を適切に設定することを推奨します

## 備考

- 本通知は、LGWEBST5プログラムで実装されています
- 統計収集は、EXEC CICS STARTにより1分ごとに自動的に再起動されます（TRANSID 'SSST'）
- カウンター値は、GENAプール内の各種カウンターから取得されます
- TSQには、現在値、前回値、差分値の3つの情報が保持されます
- 差分値を使用することで、単位時間あたりのトランザクション処理数を算出できます
- 起動メッセージとして「GENAPP Statistics collector started.」がWS-Startupに定義されていますが、実際の出力処理は確認されていません
- Business Monitor等の監視ツールとの連携に使用されることを想定しています

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 統計収集プログラムの構造を理解する

LGWEBST5プログラムの全体構造と、統計情報の収集・出力処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgwebst5.cbl | `base/src/lgwebst5.cbl` | 行1-75でプログラム構造と変数定義を確認 |
| 1-2 | lgwebst5.cbl | `base/src/lgwebst5.cbl` | 行56でGENASTAT TSQキュー名定義を確認 |
| 1-3 | lgwebst5.cbl | `base/src/lgwebst5.cbl` | 行76-150でSymbList（シンボルリスト）構造を確認 |
| 1-4 | lgwebst5.cbl | `base/src/lgwebst5.cbl` | 行734, 756, 783, 789, 796でWRITEQ TS操作を確認 |

**TSQキュー名定義**（lgwebst5.cbl 行56）:
```cobol
01  StatQ                      PIC X(8)  Value 'GENASTAT'.
```

**シンボルリスト構造**（lgwebst5.cbl 行76-97）:
```cobol
01  SymbList.
   03  Filler                  Pic X(7)  Value 'APPLID='.
   03  S1                      Pic X(8)  Value Spaces.
   03  Filler                  Pic X(13) Value '&GENACount-V='.
   03  S2                      Pic Z(8)9.
   03  Filler                  Pic X(14) Value '&GENACNT100-V='.
   03  S3                      Pic X(9).
   ...
```

**統計情報TSQ書き込み**（lgwebst5.cbl 行734）:
```cobol
Exec Cics WRITEQ TS Queue(WS-TSQNAME)
          From(WS-TSQdata)
          Length(9)
          RESP(WS-RESP)
End-Exec
```

### データフロー図

```mermaid
flowchart TD
    A[LGWEBST5起動] --> B[EXEC CICS ASSIGN APPLID]
    B --> C[EXEC CICS ASKTIME/FORMATTIME]
    C --> D[EXEC CICS QUERY COUNTER]
    D --> E[カウンター値をSymbListに格納]
    E --> F[EXEC CICS WRITEQ TS<br/>Queue=GENASTAT]
    F --> G[EXEC CICS START<br/>TRANSID=SSST<br/>AFTER 60 SECONDS]
    G --> H[EXEC CICS RETURN]
```

### プログラム呼び出し階層図

```
CICSスケジューラ
    │
    └─ START TRANSID('SSST') AFTER(60 SECONDS)
           │
           └─ LGWEBST5（統計収集プログラム）
                  │
                  ├─ EXEC CICS ASSIGN APPLID
                  │
                  ├─ EXEC CICS QUERY COUNTER
                  │     └─ GENACUSTNUMカウンター
                  │     └─ GENA01ICUS00～GENA01DCOM99カウンター
                  │     └─ GENAOTHERカウンター
                  │
                  ├─ EXEC CICS WRITEQ TS Queue(GENASTAT)
                  │     └─ シンボルリスト形式で統計出力
                  │
                  ├─ EXEC CICS START（次回実行予約）
                  │     └─ TRANSID='SSST', AFTER 60 SECONDS
                  │
                  └─ EXEC CICS RETURN
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgwebst5.cbl | `base/src/lgwebst5.cbl` | ソース | 統計収集プログラム - TSQキュー定義（行56）、WRITEQ TS（行734, 756, 783, 789, 796） |
