# 通知設計書 2-TSQエラーメッセージ通知

## 概要

本ドキュメントは、GENAPPアプリケーションにおけるTSQ（Temporary Storage Queue）エラーメッセージ通知の設計を定義する。CICSテンポラリストレージキュー（TSQ）のGENAERRSキューへのエラーメッセージ出力機能を記述する。

### 本通知の処理概要

本通知は、GENAPPアプリケーションの各業務プログラムでエラーが発生した際に、TDQ出力と同一内容のエラー情報をCICS TSQ（GENAERRSキュー）に出力する機能を提供する。TSQはCICSリージョン内で一時的にデータを保持するキューであり、アプリケーション固有のエラーログ蓄積に使用される。

**業務上の目的・背景**：GENAPPは保険ポリシー管理システムであり、TDQへのシステムログ出力に加えて、アプリケーション固有のTSQへもエラー情報を保持することで、アプリケーション開発者やサポート担当者がエラー履歴を参照しやすくなる。TSQは永続化されないため主に一時的なエラー調査に利用されるが、キュー名をパラメータで変更可能なため、特定のエラー種別を別キューに振り分けることも可能である。

**通知の送信タイミング**：TDQエラーメッセージ通知と同時に送信される。VSAM ファイル操作エラー、DB2データベースエラー、またはCOMMAREAエラーなどの発生時に、LGSTSQプログラムがTDQへの出力直後にTSQへも同一内容を出力する。

**通知の受信者**：アプリケーション開発者、サポート担当者、およびTSQを参照可能なCICSアプリケーションやツールが受信者となる。運用担当者もCICSコマンド（CEBR等）でTSQ内容を参照可能。

**通知内容の概要**：TDQ出力と同一の内容で、日時（日付・時刻）、プログラム名、顧客番号、ポリシー番号、SQLコードまたはRESPコードが含まれる。

**期待されるアクション**：開発者やサポート担当者はTSQキューの内容を参照してエラー原因を調査する。必要に応じてキュー名パラメータを変更して特定のエラーを別キューに振り分け、詳細調査を行う。

## 通知種別

システムログ（CICS TSQ - Temporary Storage Queue）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（エラー通知のため即座に出力） |
| リトライ | なし（NOSUSPENDオプション指定により、ストレージ不足時は書き込みをスキップ） |

### 送信先決定ロジック

デフォルトのキュー名はGENAERRS（8文字固定）。ただし、呼び出し元からのメッセージ先頭が「Q=nnnn」形式の場合、キュー名はGENAnnnnに変更される（nnnnは4文字の任意文字列）。

## 通知テンプレート

### TSQメッセージの場合

| 項目 | 内容 |
|-----|------|
| キュー名 | GENAERRS（デフォルト）またはGENAnnnn（パラメータ指定時） |
| キュータイプ | Temporary Storage Queue (TSQ) |
| メッセージ形式 | テキスト（固定長） |

### 本文テンプレート

```
{SYSID} {DATE} {TIME} {PROGRAM} CNUM={CUSTOMER-NUM} PNUM={POLICY-NUM} {OPERATION} RESP={RESP-CODE} RESP2={RESP2-CODE}
```

または（DB2エラーの場合）

```
{SYSID} {DATE} {TIME} {PROGRAM} CNUM={CUSTOMER-NUM} PNUM={POLICY-NUM} {SQL-REQUEST} SQLCODE={SQLCODE}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | TSQはテキストメッセージのみ |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| SYSID | CICSシステムID | EXEC CICS ASSIGN SYSID | Yes |
| DATE | エラー発生日付 | EXEC CICS FORMATTIME MMDDYYYY | Yes |
| TIME | エラー発生時刻 | EXEC CICS FORMATTIME TIME | Yes |
| PROGRAM | エラー発生プログラム名 | ERROR-MSG構造体の固定値 | Yes |
| CUSTOMER-NUM | 顧客番号 | CA-CUSTOMER-NUM | Yes |
| POLICY-NUM | ポリシー番号 | CA-POLICY-NUM | 条件付き |
| OPERATION | 操作内容 | 各プログラムの固定文字列 | Yes |
| RESP-CODE | CICSレスポンスコード | WS-RESP | Yes |
| RESP2-CODE | CICS拡張レスポンスコード | WS-RESP2/EIBRESP2 | Yes |
| SQLCODE | SQLエラーコード | SQLCODE | 条件付き |
| SQL-REQUEST | SQL操作種別 | EM-SQLREQ | 条件付き |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| TDQ出力後 | LGSTSQ内でTDQ出力完了後 | 常に実行 | TDQ出力直後にTSQ出力を実行 |
| VSAMエラー | CICS FILE操作失敗 | WS-RESP Not = DFHRESP(NORMAL) | VSAMファイル操作エラー時 |
| DB2エラー | SQL SELECT/INSERT/UPDATE失敗 | SQLCODE Not = 0 And SQLCODE Not = 100 | SQLエラー発生時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ストレージ不足 | NOSUSPENDオプションにより、TSQストレージが不足している場合は書き込みをスキップ（待機しない） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[LGSTSQ呼び出し] --> B[EXEC CICS ASSIGN SYSID]
    B --> C[メッセージ内容設定]
    C --> D{Q=パラメータあり?}
    D -->|Yes| E[キュー名をGENAnnnnに変更]
    D -->|No| F[キュー名はGENAERRS]
    E --> G[EXEC CICS WRITEQ TD QUEUE CSMT]
    F --> G
    G --> H[EXEC CICS WRITEQ TS QUEUE]
    H --> I{書き込み結果}
    I -->|成功| J[呼び出し元に戻る]
    I -->|失敗/NOSUSPEND| K[エラーは無視して続行]
    J --> L[終了]
    K --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | TSQ出力処理ではDB2テーブル参照なし |

### テーブル別参照項目詳細

TSQ出力処理自体ではデータベーステーブルの参照は行わない。エラー情報はCOMMAREAおよびCICSシステム情報から取得する。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | TSQ出力処理ではDB2テーブル更新なし |

#### 送信ログテーブル

TSQ出力はCICS TSQキューへの書き込みのみで、別途送信ログテーブルへの記録は行わない。TSQ自体がログの役割を果たす。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| TSQ書き込み失敗 | WRITEQ TSのRESPがNORMAL以外 | NOSUSPENDオプションにより待機せず処理続行 |
| ストレージ不足 | TSQ領域が不足 | NOSUSPENDにより書き込みスキップ、処理は続行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | なし（NOSUSPENDで即座にスキップ） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（CICSシステムの能力に依存） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

24時間365日、システム稼働中は常に出力可能。

## セキュリティ考慮事項

- TSQ出力には顧客番号・ポリシー番号が含まれるため、TSQキューへのアクセスは開発者・運用担当者に限定する
- CICSリソースセキュリティでTSQキューへのアクセス制御を実施する
- TSQは永続化されないため、CICSリージョン再起動時にデータは消失する
- エラーメッセージにパスワードや個人情報の詳細は含まれない設計となっている

## 備考

- LGSTSQプログラムはTDQ出力とTSQ出力を両方実行する共通モジュールである
- TSQはCICSリージョン固有のため、複数リージョン環境では各リージョンに別々のキューが作成される
- Q=パラメータでキュー名を変更可能（例：Q=TEST → GENATEST）
- NOSUSPENDオプションにより、ストレージ不足時もアプリケーション処理に影響を与えない設計

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: TSQキュー名の決定ロジックを理解する

まず、TSQキュー名がどのように決定されるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgstsq.cbl | `base/src/lgstsq.cbl` | 行33-37でSTSQ構造体を確認。STSQ-NAMEは8バイトで、先頭4バイトは'GENA'固定、後続4バイト(STSQ-EXT)が可変 |
| 1-2 | lgstsq.cbl | `base/src/lgstsq.cbl` | 行82-88でQ=パラメータ解析処理を確認。メッセージ先頭が'Q='の場合、キュー名を動的に変更 |

**キュー名構造**（lgstsq.cbl 行33-37）:
```cobol
01  STSQ.
  03  STSQ-NAME                 PIC X(8).   ... 完全なキュー名（8バイト）
01  FILLER REDEFINES STSQ.
  03 FILLER                   PIC X(4).    ... 'GENA'固定部分
  03 STSQ-EXT                 PIC X(4).    ... 可変部分（ERRS or パラメータ値）
```

**Q=パラメータ解析**（lgstsq.cbl 行82-88）:
```cobol
MOVE 'GENAERRS' TO STSQ-NAME.              ... デフォルトはGENAERRS
IF WRITE-MSG-MSG(1:2) = 'Q=' THEN          ... 先頭2文字がQ=か判定
   MOVE WRITE-MSG-MSG(3:4) TO STSQ-EXT     ... 3-6文字目をキュー拡張子に
   MOVE WRITE-MSG-REST TO TEMPO            ... メッセージ本文をシフト
   MOVE TEMPO          TO WRITE-MSG-MSG
   SUBTRACT 7 FROM WS-RECV-LEN             ... 長さを調整（Q=nnnn + 空白）
END-IF.
```

#### Step 2: TSQ書き込み処理を理解する

LGSTSQプログラムのTSQ書き込み処理とNOSUSPENDオプションを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | lgstsq.cbl | `base/src/lgstsq.cbl` | 行101-111のWRITEQ TS処理。NOSUSPENDオプションにより非ブロッキング書き込み |

**TSQ書き込み処理**（lgstsq.cbl 行105-111）:
```cobol
EXEC CICS WRITEQ TS QUEUE(STSQ-NAME)  ... STSQ-NAME = 'GENAERRS' or 'GENAnnnn'
          FROM(WRITE-MSG)
          RESP(WS-RESP)
          NOSUSPEND                    ... ストレージ不足時は待機せずスキップ
          LENGTH(WS-RECV-LEN)
END-EXEC.
```

#### Step 3: TDQとTSQの出力順序を理解する

同一メッセージがTDQとTSQの両方に出力される順序を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lgstsq.cbl | `base/src/lgstsq.cbl` | 行94-99でTDQ出力（CSMT）、行105-111でTSQ出力（GENAERRS）。TDQが先、TSQが後 |

**出力順序**:
```cobol
* 1. TDQ出力（行94-99）
EXEC CICS WRITEQ TD QUEUE(STDQ-NAME)   ... CSMT（システムログ）
          FROM(WRITE-MSG)
          ...
END-EXEC.

* 2. TSQ出力（行105-111）
EXEC CICS WRITEQ TS QUEUE(STSQ-NAME)   ... GENAERRS（アプリログ）
          FROM(WRITE-MSG)
          NOSUSPEND
          ...
END-EXEC.
```

### プログラム呼び出し階層図

```
業務プログラム（LGAPOL01, LGIPDB01等）
    │
    ├─ エラー発生検知
    │      └─ WS-RESP/SQLCODE チェック
    │
    ├─ エラーメッセージ生成
    │      ├─ 通常: ERROR-MSG構造体に値設定
    │      └─ オプション: "Q=nnnn " + エラーメッセージ形式
    │
    └─ EXEC CICS LINK PROGRAM('LGSTSQ')
           │
           └─ LGSTSQ
                  ├─ EXEC CICS ASSIGN SYSID
                  ├─ Q=パラメータ解析
                  │      └─ STSQ-NAME決定（GENAERRS or GENAnnnn）
                  ├─ EXEC CICS WRITEQ TD QUEUE('CSMT')     ... TDQ出力
                  └─ EXEC CICS WRITEQ TS QUEUE(STSQ-NAME)  ... TSQ出力
                         └─ NOSUSPEND（ストレージ不足時スキップ）
```

### データフロー図

```
[入力]                      [処理]                           [出力]

業務プログラム              LGSTSQ
  │                           │
  │ ERROR-MSG(90バイト) ────▶ │
  │ (オプション: Q=nnnn      │
  │  + エラー情報)            │
  │                           │ ─▶ Q=パラメータ判定
  │                           │      ├─ Q=ありの場合
  │                           │      │    └─ STSQ-NAME = 'GENA' + nnnn
  │                           │      └─ Q=なしの場合
  │                           │           └─ STSQ-NAME = 'GENAERRS'
  │                           │
  │                           │ ─▶ WRITE-MSG組み立て            TDQ: CSMT
  │                           │ ──────────────────────────────▶ CICSシステムログ
  │                           │
  │                           │                                 TSQ: GENAERRS
  │                           │ ──────────────────────────────▶ または GENAnnnn
  │                           │     (NOSUSPEND)                 アプリケーションログ

キュー名決定例:
┌─────────────────────┬──────────────┐
│ 入力メッセージ      │ キュー名     │
├─────────────────────┼──────────────┤
│ 通常のエラーメッセージ│ GENAERRS     │
│ Q=TEST エラー情報   │ GENATEST     │
│ Q=DB01 SQL ERROR    │ GENADB01     │
└─────────────────────┴──────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgstsq.cbl | `base/src/lgstsq.cbl` | ソース | TDQ/TSQエラーログ出力プログラム（127行） |
| lgapol01.cbl | `base/src/lgapol01.cbl` | ソース | ポリシー追加（呼び出し元例） |
| lgipdb01.cbl | `base/src/lgipdb01.cbl` | ソース | DB2照会（呼び出し元例）|

### TSQ参照方法

TSQに出力されたエラーログは以下の方法で参照可能:

1. **CEBRトランザクション**: CICS提供のTSQブラウザ
   ```
   CEBR GENAERRS
   ```

2. **アプリケーションから**: EXEC CICS READQ TS コマンド
   ```cobol
   EXEC CICS READQ TS QUEUE('GENAERRS')
             INTO(WS-LOG-MSG)
             LENGTH(WS-LEN)
             ITEM(WS-ITEM)
   END-EXEC.
   ```
