# 通知設計書 3-画面エラーメッセージ

## 概要

本ドキュメントは、GENAPPアプリケーションにおける画面エラーメッセージ通知の設計を定義する。3270端末画面への操作結果通知機能を記述する。

### 本通知の処理概要

本通知は、GENAPPアプリケーションの端末操作プログラム（LGTESTP1-P4、LGTESTC1）において、ユーザーの操作結果（成功・失敗）を3270端末画面上のメッセージフィールドに表示する機能を提供する。

**業務上の目的・背景**：GENAPPは保険ポリシー管理システムであり、オペレーターが3270端末から顧客情報やポリシー情報の照会・追加・更新・削除操作を行う。操作の成功・失敗をオペレーターに即座にフィードバックすることで、業務の効率化とエラー時の迅速な対応を支援する。

**通知の送信タイミング**：各業務操作（照会、追加、更新、削除）の完了直後に送信される。バックエンドプログラムからの戻り値（CA-RETURN-CODE）に基づいて、成功メッセージまたはエラーメッセージが決定される。

**通知の受信者**：3270端末を操作しているオペレーター（エンドユーザー）が受信者となる。

**通知内容の概要**：操作の成功時は「New Motor Policy Inserted」「Motor Policy Deleted」「Motor Policy Updated」「New Customer Inserted」「Customer details updated」などの成功メッセージ、失敗時は「Error Adding Motor Policy」「Error Deleting Motor Policy」「Error Updating Motor Policy」「No data was returned.」「Customer does not exist」「Please enter a valid option」などのエラーメッセージが表示される。

**期待されるアクション**：オペレーターは画面上のメッセージを確認し、成功の場合は次の操作に進み、エラーの場合は入力内容を確認して再操作するか、運用担当者に連絡する。

## 通知種別

端末通知（3270端末画面メッセージ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（ユーザー操作への即時フィードバック） |
| リトライ | なし（画面送信は単発） |

### 送信先決定ロジック

送信先は操作を行った3270端末（EIBTRMID）に固定。EXEC CICS SEND MAPコマンドにより、現在のトランザクションを開始した端末に対してメッセージが送信される。

## 通知テンプレート

### 画面メッセージの場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | 画面マップ上のエラーメッセージフィールド（ERP1FLDO、ERRFLDO等） |
| 表示形式 | テキスト |
| 最大文字数 | 画面フィールド定義に依存（約40-50文字） |

### 本文テンプレート

成功メッセージ：
```
{操作種別} {対象} {結果}
例：New Motor Policy Inserted
例：Motor Policy Deleted
例：Customer details updated
```

エラーメッセージ：
```
{エラー内容}
例：Error Adding Motor Policy
例：No data was returned.
例：Customer does not exist
例：Please enter a valid option
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 画面メッセージのみ |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| ERP1FLDO | Motor Policy画面のメッセージフィールド | プログラム内固定文字列 | Yes |
| ERRFLDO | Customer画面のメッセージフィールド | プログラム内固定文字列 | Yes |
| CA-RETURN-CODE | バックエンド処理結果コード | DFHCOMMAREA | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ポリシー照会完了 | CA-RETURN-CODE = 0 | 照会成功時（データ表示） |
| 画面操作 | ポリシー照会エラー | CA-RETURN-CODE > 0 | 照会失敗時（エラーメッセージ表示） |
| 画面操作 | ポリシー追加完了 | CA-RETURN-CODE = 0 | 追加成功時 |
| 画面操作 | ポリシー追加エラー | CA-RETURN-CODE > 0 | 追加失敗時（顧客不存在等） |
| 画面操作 | ポリシー削除完了 | CA-RETURN-CODE = 0 | 削除成功時 |
| 画面操作 | ポリシー削除エラー | CA-RETURN-CODE > 0 | 削除失敗時 |
| 画面操作 | ポリシー更新完了 | CA-RETURN-CODE = 0 | 更新成功時 |
| 画面操作 | ポリシー更新エラー | CA-RETURN-CODE > 0 | 更新失敗時 |
| 画面操作 | 無効オプション入力 | オプション値が1-4以外 | 無効なオプション入力時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| PF3押下 | トランザクション終了のため、メッセージは「Transaction ended」に置換 |
| CLEAR押下 | 画面初期化のため、メッセージはクリア |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザー操作受信] --> B{オプション判定}
    B -->|照会| C[LGIPOL01/LGICUS01呼び出し]
    B -->|追加| D[LGAPOL01/LGACUS01呼び出し]
    B -->|削除| E[LGDPOL01呼び出し]
    B -->|更新| F[LGUPOL01/LGUCUS01呼び出し]
    B -->|その他| G[無効オプションメッセージ設定]
    C --> H{CA-RETURN-CODE判定}
    D --> H
    E --> H
    F --> H
    H -->|0| I[成功メッセージ設定]
    H -->|>0| J[エラーメッセージ設定]
    G --> K[EXEC CICS SEND MAP]
    I --> K
    J --> K
    K --> L[EXEC CICS RETURN TRANSID]
    L --> M[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | 画面メッセージ表示処理自体ではDB2テーブル参照なし |

### テーブル別参照項目詳細

画面メッセージの表示処理自体ではデータベーステーブルの参照は行わない。メッセージ内容はプログラム内の固定文字列およびCA-RETURN-CODEに基づいて決定される。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 画面メッセージ表示処理ではDB2テーブル更新なし |

#### 送信ログテーブル

画面メッセージの送信ログは記録されない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| MAPFAIL | 画面マップ受信失敗 | トランザクション終了（ENDIT） |
| CA-RETURN-CODE = 01 | データなし（照会結果なし） | 「No data was returned.」を表示 |
| CA-RETURN-CODE = 70 | 顧客不存在 | 「Customer does not exist」を表示 |
| CA-RETURN-CODE > 0 (その他) | 追加/更新/削除エラー | 対応するエラーメッセージを表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（ユーザー操作に応じて即時表示） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

24時間365日、システム稼働中は常に表示可能。

## セキュリティ考慮事項

- 画面メッセージには顧客番号やポリシー番号などの業務データ詳細は含まれない
- エラーメッセージは汎用的な内容のみとし、システム内部情報は表示しない
- 画面へのアクセスはCICSトランザクションセキュリティで制御される

## 備考

- LGTESTP1はMotor Policyメニュー、LGTESTP2はEndowment Policyメニュー、LGTESTP3はHouse Policyメニュー、LGTESTP4はCommercial Policyメニューを担当
- LGTESTC1はCustomerメニューを担当
- 成功時はRollbackを行わず、エラー時はSyncpoint Rollbackを実行してトランザクションをロールバックする
- 画面マップはSSMAPマップセットで定義されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。LGTESTP1（Motor Policyメニュー）を代表例として説明する。

### 推奨読解順序

#### Step 1: メッセージフィールドの定義を理解する

まず、画面マップにおけるエラーメッセージフィールドの定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ssmap.cpy | `base/src/ssmap.cpy` | SSMAPP1O構造体内のERP1FLDOフィールドを確認。約40-50文字のメッセージ表示領域 |

**メッセージフィールド使用例**（lgtestp1.cbl 行127-128）:
```cobol
Move 'New Motor Policy Inserted'
  To  ERP1FLDO                          ... 成功メッセージをフィールドに設定
```

#### Step 2: バックエンドプログラム呼び出しとリターンコード判定を理解する

業務プログラム呼び出しとCA-RETURN-CODE判定ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | lgtestp1.cbl | `base/src/lgtestp1.cbl` | 行72-78（照会）、行115-122（追加）、行139-146（削除）、行216-222（更新）でLINK呼び出しとリターンコード判定 |

**バックエンド呼び出しとリターンコード判定**（lgtestp1.cbl 行115-122）:
```cobol
EXEC CICS LINK PROGRAM('LGAPOL01')    ... ポリシー追加プログラム呼び出し
          COMMAREA(COMM-AREA)
          LENGTH(32500)
END-EXEC
IF CA-RETURN-CODE > 0                  ... エラー判定
  Exec CICS Syncpoint Rollback End-Exec ... ロールバック
  GO TO NO-ADD                         ... エラーメッセージ処理へ
END-IF
```

#### Step 3: エラーメッセージ設定処理を理解する

CA-RETURN-CODEに基づくエラーメッセージ設定処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lgtestp1.cbl | `base/src/lgtestp1.cbl` | 行286-306でCA-RETURN-CODEに応じたエラーメッセージを設定（NO-ADD, NO-UPD, NO-DELETE, NO-DATA） |

**エラーメッセージ設定**（lgtestp1.cbl 行286-306）:
```cobol
NO-ADD.
    Evaluate CA-RETURN-CODE
      When 70                                  ... 顧客不存在
        Move 'Customer does not exist'          To  ERP1FLDO
        Go To ERROR-OUT
      When Other                               ... その他のエラー
        Move 'Error Adding Motor Policy'        To  ERP1FLDO
        Go To ERROR-OUT
    End-Evaluate.

NO-UPD.
    Move 'Error Updating Motor Policy'    To  ERP1FLDO
    Go To ERROR-OUT.

NO-DELETE.
    Move 'Error Deleting Motor Policy'    To  ERP1FLDO
    Go To ERROR-OUT.

NO-DATA.
    Move 'No data was returned.'            To  ERP1FLDO
    Go To ERROR-OUT.
```

#### Step 4: 画面送信処理を理解する

メッセージを含む画面の送信処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | lgtestp1.cbl | `base/src/lgtestp1.cbl` | 行308-312のERROR-OUTセクションでSEND MAP処理。成功時も同様にSEND MAP実行 |

**画面送信処理**（lgtestp1.cbl 行308-312）:
```cobol
ERROR-OUT.
    EXEC CICS SEND MAP ('SSMAPP1')       ... マップ名
              FROM(SSMAPP1O)              ... 出力用構造体
              MAPSET ('SSMAP')            ... マップセット名
    END-EXEC.
```

### プログラム呼び出し階層図

```
3270端末操作
    │
    └─ LGTESTP1（Motor Policy）/ LGTESTP2-4 / LGTESTC1
           │
           ├─ EXEC CICS RECEIVE MAP ... ユーザー入力受信
           │
           ├─ EVALUATE ENP1OPTO (オプション判定)
           │      │
           │      ├─ '1' 照会 ─▶ LINK LGIPOL01 ─▶ CA-RETURN-CODE判定
           │      │                                    └─ > 0: NO-DATA
           │      │
           │      ├─ '2' 追加 ─▶ LINK LGAPOL01 ─▶ CA-RETURN-CODE判定
           │      │                                    └─ > 0: NO-ADD
           │      │                                         ├─ 70: Customer does not exist
           │      │                                         └─ Other: Error Adding
           │      │
           │      ├─ '3' 削除 ─▶ LINK LGDPOL01 ─▶ CA-RETURN-CODE判定
           │      │                                    └─ > 0: NO-DELETE
           │      │
           │      ├─ '4' 更新 ─▶ LINK LGUPOL01 ─▶ CA-RETURN-CODE判定
           │      │                                    └─ > 0: NO-UPD
           │      │
           │      └─ OTHER ─▶ 'Please enter a valid option'
           │
           └─ EXEC CICS SEND MAP ... メッセージ含む画面送信
```

### データフロー図

```
[入力]                      [処理]                           [出力]

3270端末                    LGTESTPn / LGTESTC1
  │                           │
  │ RECEIVE MAP ────────────▶ │
  │ (オプション+データ)       │
  │                           │ ─▶ バックエンド呼び出し
  │                           │      └─ LGIPOL01/LGAPOL01/etc.
  │                           │
  │                           │ ─▶ CA-RETURN-CODE判定
  │                           │      │
  │                           │      ├─ = 0（成功）
  │                           │      │    └─ 成功メッセージ設定
  │                           │      │        'New Motor Policy Inserted'
  │                           │      │        'Motor Policy Deleted'
  │                           │      │        'Motor Policy Updated'
  │                           │      │
  │                           │      └─ > 0（エラー）
  │                           │           └─ Syncpoint Rollback
  │                           │           └─ エラーメッセージ設定
  │                           │               'Customer does not exist'
  │                           │               'Error Adding Motor Policy'
  │                           │               'No data was returned.'
  │                           │
  │ ◀──────────────────────── │ ◀─ SEND MAP（画面送信）
  │ (メッセージ表示画面)      │

メッセージ表示フィールド:
┌────────────────────────────────────────────────────┐
│ ERP1FLDO (Policy画面) / ERRFLDO (Customer画面)     │
│ 約40-50文字のテキストメッセージ表示領域            │
└────────────────────────────────────────────────────┘
```

### メッセージ一覧

| 操作 | リターンコード | メッセージ | 処理箇所 |
|-----|---------------|----------|---------|
| 照会成功 | 0 | （データ表示のみ） | 行80-95 |
| 照会失敗 | > 0 | No data was returned. | NO-DATA (行304-306) |
| 追加成功 | 0 | New Motor Policy Inserted | 行127-128 |
| 追加失敗 | 70 | Customer does not exist | NO-ADD (行288-290) |
| 追加失敗 | Other | Error Adding Motor Policy | NO-ADD (行291-293) |
| 削除成功 | 0 | Motor Policy Deleted | 行157-158 |
| 削除失敗 | > 0 | Error Deleting Motor Policy | NO-DELETE (行300-302) |
| 更新成功 | 0 | Motor Policy Updated | 行227-228 |
| 更新失敗 | > 0 | Error Updating Motor Policy | NO-UPD (行296-298) |
| 無効オプション | - | Please enter a valid option | 行238-239 |
| トランザクション終了 | - | Transaction ended | ENDIT (行264-271) |

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgtestp1.cbl | `base/src/lgtestp1.cbl` | ソース | Motor Policyメニュー画面（319行） |
| lgtestp2.cbl | `base/src/lgtestp2.cbl` | ソース | Endowment Policyメニュー画面 |
| lgtestp3.cbl | `base/src/lgtestp3.cbl` | ソース | House Policyメニュー画面 |
| lgtestp4.cbl | `base/src/lgtestp4.cbl` | ソース | Commercial Policyメニュー画面 |
| lgtestc1.cbl | `base/src/lgtestc1.cbl` | ソース | Customerメニュー画面 |
| ssmap.cpy | `base/src/ssmap.cpy` | コピーブック | 画面マップ定義 |
| lgcmarea.cpy | `base/src/lgcmarea.cpy` | コピーブック | COMMAREA定義（CA-RETURN-CODE含む） |
