# 通知設計書 4-ABEND通知(LGCA)

## 概要

本ドキュメントは、GENAPPアプリケーションにおけるABEND通知（ABENDコード'LGCA'）の設計を定義する。COMMAREAが受信されなかった場合のアプリケーション異常終了通知機能を記述する。

### 本通知の処理概要

本通知は、GENAPPアプリケーションの業務プログラムにおいて、呼び出し元からCOMMAREAが渡されなかった場合に発行されるABEND（異常終了）通知である。ABENDコード'LGCA'はCOMMAREA未受信を示す固有のコードである。

**業務上の目的・背景**：GENAPPの業務プログラム（LGAPOL01、LGIPDB01等）はCOMMAREAを通じてパラメータを受け取る設計となっている。COMMAREAが渡されない場合、プログラムは正常に処理を継続できないため、ABENDを発行して異常状態を明確化し、システム運用担当者に問題の発生を通知する。これにより、プログラム呼び出しの設計ミスや設定誤りを早期に検知できる。

**通知の送信タイミング**：プログラムのMAINLINE SECTION冒頭でEIBCALEN（COMMAREAの長さ）をチェックし、値が0の場合に即座にABENDが発行される。

**通知の受信者**：CICSシステム運用担当者、およびABENDを監視する運用監視システムが受信者となる。ABENDコードはCICSシステムログに記録され、CICS ABEND処理によってシステムコンソールにも通知される。

**通知内容の概要**：ABENDコード'LGCA'（4文字）と、ABEND前に出力されるエラーメッセージ（日時、プログラム名、「NO COMMAREA RECEIVED」）が含まれる。NODUMPオプションが指定されているため、ダンプは出力されない。

**期待されるアクション**：運用担当者はABENDコード'LGCA'を検知した場合、該当トランザクションの呼び出し元プログラムまたは設定を確認し、COMMAREAが正しく渡されるよう修正する。

## 通知種別

システム異常（CICS ABEND）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（即座に異常終了） |
| 優先度 | 最高（システム異常のため即時通知） |
| リトライ | なし（ABENDは単発で処理終了） |

### 送信先決定ロジック

送信先はCICSシステム（ABEND処理機構）に固定。ABENDコードはCICSシステムログに記録され、必要に応じてシステムコンソールやSMFレコードにも出力される。

## 通知テンプレート

### ABEND通知の場合

| 項目 | 内容 |
|-----|------|
| ABENDコード | LGCA |
| ダンプ出力 | なし（NODUMPオプション） |
| エラーメッセージ | TDQ/TSQに出力（ABEND前） |

### 本文テンプレート

ABEND前エラーメッセージ：
```
{DATE} {TIME} {PROGRAM} NO COMMAREA RECEIVED
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | NODUMPオプション | ダンプは出力されない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| DATE | エラー発生日付 | EXEC CICS FORMATTIME MMDDYYYY | Yes |
| TIME | エラー発生時刻 | EXEC CICS FORMATTIME TIME | Yes |
| PROGRAM | エラー発生プログラム名 | ERROR-MSG構造体の固定値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| プログラム呼び出し | COMMAREA未受信 | EIBCALEN = 0 | プログラム呼び出し時にCOMMAREAが渡されなかった場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| EIBCALEN > 0 | COMMAREAが渡された場合はABEND発行なし |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[プログラム開始] --> B{EIBCALEN = 0?}
    B -->|Yes| C[エラーメッセージ設定]
    C --> D[PERFORM WRITE-ERROR-MESSAGE]
    D --> E[EXEC CICS LINK LGSTSQ]
    E --> F[EXEC CICS ABEND ABCODE LGCA NODUMP]
    F --> G[処理異常終了]
    B -->|No| H[通常処理継続]
    H --> I[正常終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | ABEND処理ではDB2テーブル参照なし |

### テーブル別参照項目詳細

ABEND処理自体ではデータベーステーブルの参照は行わない。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | ABEND処理ではDB2テーブル更新なし（ABEND前の処理があればロールバック） |

#### 送信ログテーブル

ABEND前にLGSTSQを呼び出してTDQ/TSQにエラーメッセージを出力する。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| COMMAREA未受信 | EIBCALEN = 0 | ABEND(LGCA)発行後、呼び出し元プログラムまたは設定を修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（ABENDは単発） |
| リトライ間隔 | - |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（発生都度通知） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

24時間365日、システム稼働中は常に発行可能。

## セキュリティ考慮事項

- ABENDコード'LGCA'はシステム内部情報であり、エンドユーザーには直接表示されない
- NODUMPオプションにより、ダンプファイルは出力されないため、メモリ内データの漏洩リスクを低減
- ABENDログへのアクセスは運用担当者に限定する

## 備考

- ABENDコード'LGCA'は「GENAPP COMMAREA Absent」を意味する
- NODUMPオプションは全業務プログラム共通で指定されている
- ABEND前にWRITE-ERROR-MESSAGEを実行してTDQ/TSQにエラー情報を記録するため、エラー発生時刻とプログラム名は確認可能
- 使用プログラム：LGIPDB01、LGAPOL01、および他のDB2/VSAM操作プログラム

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。LGIPDB01（ポリシー照会プログラム）を代表例として説明する。

### 推奨読解順序

#### Step 1: エラーメッセージ構造体を理解する

まず、ABENDの前に出力されるエラーメッセージの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgipdb01.cbl | `base/src/lgipdb01.cbl` | 行48-60でERROR-MSG構造体を確認。日時、プログラム名、顧客番号、ポリシー番号、SQLコードを含む |

**エラーメッセージ構造体**（lgipdb01.cbl 行48-60）:
```cobol
01  ERROR-MSG.
    03 EM-DATE                  PIC X(8)  VALUE SPACES.  ... 日付
    03 FILLER                   PIC X     VALUE SPACES.
    03 EM-TIME                  PIC X(6)  VALUE SPACES.  ... 時刻
    03 FILLER                   PIC X(9)  VALUE ' LGIPDB01'. ... プログラム名
    03 EM-VARIABLE.
      05 FILLER                 PIC X(6)  VALUE ' CNUM='.
      05 EM-CUSNUM              PIC X(10)  VALUE SPACES. ... 顧客番号
      05 FILLER                 PIC X(6)  VALUE ' PNUM='.
      05 EM-POLNUM              PIC X(10)  VALUE SPACES. ... ポリシー番号
      05 EM-SQLREQ              PIC X(16) VALUE SPACES.  ... SQL操作種別
      05 FILLER                 PIC X(9)  VALUE ' SQLCODE='.
      05 EM-SQLRC               PIC +9(5) USAGE DISPLAY. ... SQLコード
```

#### Step 2: EIBCALEN判定とABEND発行を理解する

プログラム開始時のCOMMAREA長チェックとABEND発行処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | lgipdb01.cbl | `base/src/lgipdb01.cbl` | 行251-255でEIBCALEN = 0判定とABEND発行。NODUMPオプション指定 |

**EIBCALEN判定とABEND発行**（lgipdb01.cbl 行251-255）:
```cobol
IF EIBCALEN IS EQUAL TO ZERO                    ... COMMAREA長がゼロか判定
  MOVE ' NO COMMAREA RECEIVED' TO EM-VARIABLE   ... エラーメッセージ設定
  PERFORM WRITE-ERROR-MESSAGE                   ... TDQ/TSQにログ出力
  EXEC CICS ABEND ABCODE('LGCA') NODUMP END-EXEC ... ABEND発行（ダンプなし）
END-IF
```

#### Step 3: WRITE-ERROR-MESSAGEプロシージャを理解する

エラーメッセージをTDQ/TSQに出力するプロシージャを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lgipdb01.cbl | `base/src/lgipdb01.cbl` | 行997-1030でWRITE-ERROR-MESSAGE。ASKTIME/FORMATTIMEで日時取得、LGSTSQをLINKしてログ出力 |

**エラーメッセージ出力処理**（lgipdb01.cbl 行997-1013）:
```cobol
WRITE-ERROR-MESSAGE.
    MOVE SQLCODE TO EM-SQLRC                    ... SQLコード保存
    EXEC CICS ASKTIME ABSTIME(ABS-TIME)         ... 現在時刻取得
    END-EXEC
    EXEC CICS FORMATTIME ABSTIME(ABS-TIME)      ... 日時フォーマット
              MMDDYYYY(DATE1)
              TIME(TIME1)
    END-EXEC
    MOVE DATE1 TO EM-DATE                       ... 日付設定
    MOVE TIME1 TO EM-TIME                       ... 時刻設定
    EXEC CICS LINK PROGRAM('LGSTSQ')            ... LGSTSQ呼び出し
              COMMAREA(ERROR-MSG)
              LENGTH(LENGTH OF ERROR-MSG)
    END-EXEC.
```

### プログラム呼び出し階層図

```
呼び出し元プログラム（画面プログラム等）
    │
    └─ EXEC CICS LINK PROGRAM('LGIPDB01')
           │
           └─ LGIPDB01（業務プログラム）
                  │
                  ├─ MAINLINE SECTION開始
                  │      │
                  │      └─ IF EIBCALEN = 0    ... COMMAREA長チェック
                  │              │
                  │              ├─ EM-VARIABLE ← 'NO COMMAREA RECEIVED'
                  │              │
                  │              ├─ PERFORM WRITE-ERROR-MESSAGE
                  │              │      │
                  │              │      ├─ ASKTIME/FORMATTIME ... 日時取得
                  │              │      │
                  │              │      └─ LINK LGSTSQ ... TDQ/TSQ出力
                  │              │              │
                  │              │              ├─ WRITEQ TD QUEUE('CSMT')
                  │              │              └─ WRITEQ TS QUEUE('GENAERRS')
                  │              │
                  │              └─ EXEC CICS ABEND ABCODE('LGCA') NODUMP
                  │                      │
                  │                      └─ トランザクション異常終了
                  │
                  └─ （EIBCALEN > 0の場合）通常処理継続
```

### データフロー図

```
[入力]                      [処理]                           [出力]

呼び出し元                  業務プログラム（LGIPDB01等）
  │                           │
  │ LINK（COMMAREAなし）──▶ │
  │                           │ ─▶ EIBCALEN判定
  │                           │      │
  │                           │      └─ = 0 の場合
  │                           │              │
  │                           │              ├─ エラーメッセージ設定
  │                           │              │    'NO COMMAREA RECEIVED'
  │                           │              │
  │                           │              ├─ WRITE-ERROR-MESSAGE      TDQ: CSMT
  │                           │              │ ─────────────────────▶ システムログ
  │                           │              │                          TSQ: GENAERRS
  │                           │              │ ─────────────────────▶ アプリログ
  │                           │              │
  │                           │              └─ ABEND 'LGCA' NODUMP
  │                           │                       │
  │ ◀───────────────────────  │ ◀──────────────────────
  │ （トランザクション異常終了）│

ABENDコード体系:
┌──────────┬────────────────────────────┐
│ コード   │ 意味                       │
├──────────┼────────────────────────────┤
│ LGCA     │ COMMAREA Absent (未受信)   │
└──────────┴────────────────────────────┘
```

### ABEND発生時の調査手順

1. **CSMTログの確認**: ABENDの直前に出力されるエラーメッセージを確認
   ```
   CEBR CSMT
   ```
   出力例: `04/15/2024 10:30:45 LGIPDB01 NO COMMAREA RECEIVED`

2. **GENAERRSログの確認**: アプリケーション固有ログを確認
   ```
   CEBR GENAERRS
   ```

3. **呼び出し元の確認**: COMMAREAを渡していない呼び出し元プログラムを特定
   - EIBTRNID（トランザクションID）から呼び出し元を特定
   - 該当プログラムのLINK文でCOMMAREAパラメータを確認

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgipdb01.cbl | `base/src/lgipdb01.cbl` | ソース | ポリシー照会プログラム（1031行） |
| lgapol01.cbl | `base/src/lgapol01.cbl` | ソース | ポリシー追加プログラム |
| lgupol01.cbl | `base/src/lgupol01.cbl` | ソース | ポリシー更新プログラム |
| lgdpol01.cbl | `base/src/lgdpol01.cbl` | ソース | ポリシー削除プログラム |
| lgstsq.cbl | `base/src/lgstsq.cbl` | ソース | TDQ/TSQエラーログ出力プログラム（127行） |
| lgcmarea.cpy | `base/src/lgcmarea.cpy` | コピーブック | COMMAREA定義 |

### 該当コード箇所一覧

| プログラム | EIBCALEN判定 | ABEND発行行 |
|-----------|-------------|------------|
| LGIPDB01 | 行251-255 | 行254 |
| LGAPOL01 | 同様のパターン | 同様 |
| LGUPOL01 | 同様のパターン | 同様 |
| LGDPOL01 | 同様のパターン | 同様 |
