# 通知設計書 5-リターンコード00

## 概要

本ドキュメントは、GENAPPアプリケーションにおけるリターンコード00（処理正常完了）の設計を定義する。業務プログラムの処理が正常に完了したことを示すリターンコードである。

### 本通知の処理概要

本通知は、GENAPPアプリケーションの業務プログラムが処理を正常に完了した場合に、COMMAREAのCA-RETURN-CODEフィールドに設定されるリターンコードである。呼び出し元プログラムはこのコードを確認して、後続処理の分岐を行う。

**業務上の目的・背景**：GENAPPは保険ポリシー管理システムであり、顧客情報やポリシー情報の照会・追加・更新・削除処理の結果を呼び出し元プログラムに通知する必要がある。リターンコード00は処理が正常に完了したことを示し、呼び出し元は成功時の処理（データ表示、成功メッセージ表示等）を実行できる。

**通知の送信タイミング**：業務処理（VSAM操作、DB2操作）が正常に完了した直後、プログラムがRETURNする前にCA-RETURN-CODEに'00'が設定される。多くの場合、処理開始時に初期値として'00'が設定され、エラー発生時のみ別の値に変更される。

**通知の受信者**：業務プログラムを呼び出したプログラム（LGTESTP1-P4、LGTESTC1、Webサービスプログラム等）が受信者となる。

**通知内容の概要**：CA-RETURN-CODE = '00'（2桁数字）のみ。追加のエラー情報は含まれない。

**期待されるアクション**：呼び出し元プログラムは、CA-RETURN-CODE = 00を確認したら、取得したデータの表示や成功メッセージの表示など、正常系の処理を実行する。

## 通知種別

エラーコード（COMMAREA リターンコード）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（COMMAREA経由） |
| 優先度 | 通常（処理結果通知） |
| リトライ | なし（単一のリターン値） |

### 送信先決定ロジック

送信先はCOMMAREAを渡した呼び出し元プログラムに固定。EXEC CICS LINK/XCTL で呼び出された場合、COMMAREAは呼び出し元と共有されるため、値の変更は即座に呼び出し元で参照可能となる。

## 通知テンプレート

### リターンコードの場合

| 項目 | 内容 |
|-----|------|
| フィールド名 | CA-RETURN-CODE |
| データ型 | PIC 9(2) |
| 値 | 00 |

### 本文テンプレート

```
CA-RETURN-CODE = 00
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | リターンコードのみ |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| CA-RETURN-CODE | 処理結果コード | DFHCOMMAREA | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 処理完了 | 業務処理正常終了 | エラーが発生しなかった場合 | 初期値'00'のまま変更されない |
| VSAMアクセス | VSAM READ/WRITE成功 | WS-RESP = DFHRESP(NORMAL) | VSAM操作成功 |
| DB2アクセス | SQL実行成功 | SQLCODE = 0 | DB2操作成功 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| エラー発生時 | VSAM/DB2エラー発生時は他のリターンコードに変更される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[プログラム開始] --> B[CA-RETURN-CODE = '00' 初期設定]
    B --> C[業務処理実行]
    C --> D{処理結果}
    D -->|正常完了| E[CA-RETURN-CODE = '00' 維持]
    D -->|エラー発生| F[CA-RETURN-CODE = エラーコード]
    E --> G[EXEC CICS RETURN]
    F --> G
    G --> H[呼び出し元に戻る]
    H --> I{呼び出し元でCA-RETURN-CODE判定}
    I -->|00| J[正常系処理]
    I -->|その他| K[エラー系処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | リターンコード設定処理自体ではDB2参照なし |

### テーブル別参照項目詳細

リターンコード設定自体ではデータベーステーブルの参照は行わない。リターンコードはCOMMAREAの固定フィールドに設定される。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | リターンコード設定処理ではDB2更新なし |

#### 送信ログテーブル

リターンコード00（正常完了）の場合、ログ出力は行わない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| なし | リターンコード00は正常完了 | エラー処理は不要 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（処理結果に応じて設定） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

24時間365日、システム稼働中は常に設定可能。

## セキュリティ考慮事項

- リターンコード自体には機密情報は含まれない
- COMMAREAのアクセスはプログラム間の呼び出し関係で制限される

## 備考

- リターンコード00は全業務プログラム共通で「正常完了」を意味する
- 多くのプログラムでは処理開始時にMOVE '00' TO CA-RETURN-CODEで初期化される
- LGIPDB01では「MOVE '00' TO CA-RETURN-CODE」（Line 258）で明示的に初期化
- 呼び出し元（LGTESTP1等）ではIF CA-RETURN-CODE > 0でエラー判定を行う

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: CA-RETURN-CODEの定義を理解する

まず、COMMAREAにおけるCA-RETURN-CODEの定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgcmarea.cpy | `base/src/lgcmarea.cpy` | CA-RETURN-CODEフィールドの定義（PIC 9(2)）を確認 |

#### Step 2: リターンコード00の設定箇所を理解する

業務プログラムでの初期化処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | lgipdb01.cbl | `base/src/lgipdb01.cbl` | 行258でCA-RETURN-CODEを'00'で初期化する処理を確認 |

**リターンコード初期化**（lgipdb01.cbl 行258）:
```cobol
MOVE '00' TO CA-RETURN-CODE   ... 処理開始時に正常完了コードで初期化
```

#### Step 3: 呼び出し元でのリターンコード判定を理解する

画面プログラムでのリターンコード判定処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lgtestp1.cbl | `base/src/lgtestp1.cbl` | 行76-78, 119-122等でCA-RETURN-CODE判定。> 0でエラー分岐 |

**リターンコード判定**（lgtestp1.cbl 行76-78）:
```cobol
IF CA-RETURN-CODE > 0         ... 0より大きければエラー
  GO TO NO-DATA               ... エラー処理へ分岐
END-IF
```

### プログラム呼び出し階層図

```
画面プログラム（LGTESTP1等）
    │
    ├─ EXEC CICS LINK PROGRAM('LGIPOL01/LGIPDB01')
    │      COMMAREA(COMM-AREA)
    │      │
    │      └─ 業務プログラム
    │             │
    │             ├─ MOVE '00' TO CA-RETURN-CODE  ... 初期化
    │             │
    │             ├─ 業務処理実行
    │             │      │
    │             │      └─ 正常完了の場合
    │             │             └─ CA-RETURN-CODE = '00' 維持
    │             │
    │             └─ EXEC CICS RETURN
    │
    └─ IF CA-RETURN-CODE > 0     ... リターンコード判定
           │
           ├─ Yes → エラー処理
           │
           └─ No (= 00) → 正常処理
                   ├─ データ表示
                   └─ 成功メッセージ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgcmarea.cpy | `base/src/lgcmarea.cpy` | コピーブック | COMMAREA定義（CA-RETURN-CODE含む） |
| lgipdb01.cbl | `base/src/lgipdb01.cbl` | ソース | ポリシー照会（設定例） |
| lgtestp1.cbl | `base/src/lgtestp1.cbl` | ソース | Motor Policyメニュー（判定例） |
