# 通知設計書 6-リターンコード01

## 概要

本ドキュメントは、GENAPPアプリケーションにおけるリターンコード01（データなし／レコード未検出）の設計を定義する。SQLCODEが100の場合に発生するリターンコードである。

### 本通知の処理概要

本通知は、GENAPPアプリケーションの業務プログラムが照会処理を実行した結果、該当するレコードが見つからなかった場合に、COMMAREAのCA-RETURN-CODEフィールドに設定されるリターンコードである。

**業務上の目的・背景**：GENAPPは保険ポリシー管理システムであり、顧客情報やポリシー情報の照会時に指定された顧客番号やポリシー番号が存在しない場合がある。リターンコード01は「該当データなし」を示し、呼び出し元は適切なエラーメッセージ（「No data was returned.」）を表示して、ユーザーに入力内容の確認を促すことができる。

**通知の送信タイミング**：DB2 SELECT文またはVSAM READ文を実行した結果、SQLCODEが100（行が見つからない）の場合、またはVSAM操作でレコードが見つからない場合に設定される。

**通知の受信者**：業務プログラムを呼び出したプログラム（LGTESTP1-P4、LGTESTC1、Webサービスプログラム等）が受信者となる。

**通知内容の概要**：CA-RETURN-CODE = '01'（2桁数字）のみ。データなしの原因（顧客番号不正、ポリシー番号不正等）の詳細は含まれない。

**期待されるアクション**：呼び出し元プログラムは、CA-RETURN-CODE = 01を確認したら、「No data was returned.」等のメッセージを表示し、ユーザーに入力内容の確認を促す。

## 通知種別

エラーコード（COMMAREA リターンコード）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（COMMAREA経由） |
| 優先度 | 通常（処理結果通知） |
| リトライ | なし（単一のリターン値） |

### 送信先決定ロジック

送信先はCOMMAREAを渡した呼び出し元プログラムに固定。

## 通知テンプレート

### リターンコードの場合

| 項目 | 内容 |
|-----|------|
| フィールド名 | CA-RETURN-CODE |
| データ型 | PIC 9(2) |
| 値 | 01 |

### 本文テンプレート

```
CA-RETURN-CODE = 01
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | リターンコードのみ |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| CA-RETURN-CODE | 処理結果コード | DFHCOMMAREA | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| DB2照会 | SELECT結果なし | SQLCODE = 100 | DB2 SELECT文で該当行なし |
| VSAM照会 | READ結果なし | RESP = DFHRESP(NOTFND) | VSAMファイルで該当レコードなし |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| データ検出時 | SQLCODE = 0またはVSAM READで正常取得の場合はリターンコード00 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[照会処理実行] --> B{DB2 or VSAM}
    B -->|DB2| C[EXEC SQL SELECT]
    B -->|VSAM| D[EXEC CICS READ FILE]
    C --> E{SQLCODE判定}
    D --> F{RESP判定}
    E -->|= 100| G[MOVE '01' TO CA-RETURN-CODE]
    E -->|= 0| H[CA-RETURN-CODE = '00' 維持]
    F -->|NOTFND| G
    F -->|NORMAL| H
    G --> I[EXEC CICS RETURN]
    H --> I
    I --> J[呼び出し元に戻る]
    J --> K{CA-RETURN-CODE判定}
    K -->|01| L[No data was returned メッセージ表示]
    K -->|00| M[データ表示処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| POLICY | ポリシー情報照会 | 顧客番号・ポリシー番号で検索 |
| ENDOWMENT | 養老保険ポリシー照会 | POLICYとJOIN |
| HOUSE | 住宅保険ポリシー照会 | POLICYとJOIN |
| MOTOR | 自動車保険ポリシー照会 | POLICYとJOIN |
| COMMERCIAL | 商業保険ポリシー照会 | POLICYとJOIN |

### テーブル別参照項目詳細

#### POLICY + ENDOWMENTテーブル（例）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| CUSTOMERNUMBER | 顧客番号 | WHERE句で指定 |
| POLICYNUMBER | ポリシー番号 | WHERE句で指定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 照会処理のため更新なし |

#### 送信ログテーブル

リターンコード01（データなし）の場合、エラーログ出力は行わない（正常なビジネスケースとして扱う）。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| データなし | SQLCODE = 100 | 「No data was returned.」メッセージ表示 |
| 入力エラー | 顧客番号またはポリシー番号が無効 | ユーザーに入力確認を促す |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

24時間365日、システム稼働中は常に設定可能。

## セキュリティ考慮事項

- リターンコード01自体には機密情報は含まれない
- 「データなし」の理由詳細は返さないため、存在確認攻撃のリスクを軽減

## 備考

- リターンコード01はSQLCODE = 100（End of data / No rows found）に対応
- LGIPDB01のGET-ENDOW-DB2-INFO（Line 421-423）: IF SQLCODE EQUAL 100, MOVE '01' TO CA-RETURN-CODE
- 呼び出し元（LGTESTP1 Line 77-78, 304-306）: IF CA-RETURN-CODE > 0, GO TO NO-DATA, Move 'No data was returned.' To ERP1FLDO
- エラーログ（TDQ/TSQ）への出力は行わない（正常なビジネスケース）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: リターンコード01の設定箇所を理解する

SQLCODEが100の場合にリターンコード01を設定する処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgipdb01.cbl | `base/src/lgipdb01.cbl` | 行421-423でSQLCODE = 100の場合に'01'を設定 |

**リターンコード01設定**（lgipdb01.cbl 行421-423）:
```cobol
IF SQLCODE EQUAL 100              ... データ未検出
  MOVE '01' TO CA-RETURN-CODE     ... リターンコード01設定
END-IF
```

#### Step 2: 呼び出し元での判定とメッセージ表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | lgtestp1.cbl | `base/src/lgtestp1.cbl` | 行304-306でNO-DATA処理、「No data was returned.」メッセージ表示 |

**メッセージ表示処理**（lgtestp1.cbl 行304-306）:
```cobol
NO-DATA.
    Move 'No data was returned.'    To  ERP1FLDO
    Go To ERROR-OUT.
```

### プログラム呼び出し階層図

```
画面プログラム（LGTESTP1等）
    │
    └─ LINK LGIPOL01/LGIPDB01
           │
           └─ SELECT実行
                  │
                  ├─ SQLCODE = 100（データなし）
                  │      └─ MOVE '01' TO CA-RETURN-CODE
                  │
                  └─ RETURN
                         │
                         └─ 呼び出し元でCA-RETURN-CODE > 0判定
                                └─ NO-DATA → 'No data was returned.'
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgipdb01.cbl | `base/src/lgipdb01.cbl` | ソース | リターンコード01設定（行421-423） |
| lgtestp1.cbl | `base/src/lgtestp1.cbl` | ソース | メッセージ表示（行304-306） |
