# 通知設計書 7-リターンコード02

## 概要

本ドキュメントは、GENAPPアプリケーションにおけるリターンコード02（重複データ検出）の設計を定義する。顧客情報更新時に検出されるリターンコードである。

### 本通知の処理概要

本通知は、GENAPPアプリケーションの業務プログラムがデータの追加または更新処理を実行した際に、重複データが検出された場合に、COMMAREAのCA-RETURN-CODEフィールドに設定されるリターンコードである。

**業務上の目的・背景**：GENAPPは保険ポリシー管理システムであり、データの一意性を保証する必要がある。重複データの検出は、同一キーのレコードが既に存在する場合や、更新対象のレコードが他のトランザクションによって変更されている場合に発生する。リターンコード02は「重複または競合」を示し、呼び出し元は適切なエラーハンドリングを行うことができる。

**通知の送信タイミング**：DB2 INSERT文で一意制約違反が発生した場合、またはVSAM WRITE文で重複キーエラーが発生した場合に設定される。

**通知の受信者**：業務プログラムを呼び出したプログラム（LGTESTP1-P4、LGTESTC1、Webサービスプログラム等）が受信者となる。

**通知内容の概要**：CA-RETURN-CODE = '02'（2桁数字）のみ。重複の詳細（どのキーが重複しているか等）は含まれない。

**期待されるアクション**：呼び出し元プログラムは、CA-RETURN-CODE = 02を確認したら、重複エラーメッセージを表示し、ユーザーに入力内容の確認または別の値の入力を促す。

## 通知種別

エラーコード（COMMAREA リターンコード）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（COMMAREA経由） |
| 優先度 | 通常（処理結果通知） |
| リトライ | なし（単一のリターン値） |

### 送信先決定ロジック

送信先はCOMMAREAを渡した呼び出し元プログラムに固定。

## 通知テンプレート

### リターンコードの場合

| 項目 | 内容 |
|-----|------|
| フィールド名 | CA-RETURN-CODE |
| データ型 | PIC 9(2) |
| 値 | 02 |

### 本文テンプレート

```
CA-RETURN-CODE = 02
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | リターンコードのみ |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| CA-RETURN-CODE | 処理結果コード | DFHCOMMAREA | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| DB2追加 | INSERT重複キーエラー | SQLCODE = -803 | 一意制約違反 |
| VSAM追加 | WRITE重複キーエラー | RESP = DFHRESP(DUPREC) | 重複レコードエラー |
| 更新競合 | 更新時の競合検出 | 実装依存 | 他トランザクションとの競合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 正常完了時 | 重複が検出されない場合はリターンコード00 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[追加/更新処理実行] --> B{DB2 or VSAM}
    B -->|DB2| C[EXEC SQL INSERT/UPDATE]
    B -->|VSAM| D[EXEC CICS WRITE FILE]
    C --> E{SQLCODE判定}
    D --> F{RESP判定}
    E -->|-803| G[MOVE '02' TO CA-RETURN-CODE]
    E -->|= 0| H[CA-RETURN-CODE = '00' 維持]
    F -->|DUPREC| G
    F -->|NORMAL| H
    G --> I[EXEC CICS RETURN]
    H --> I
    I --> J[呼び出し元に戻る]
    J --> K{CA-RETURN-CODE判定}
    K -->|02| L[重複エラーメッセージ表示]
    K -->|00| M[成功メッセージ表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | 重複チェックはDB2/VSAMの制約で自動実行 |

### テーブル別参照項目詳細

重複チェック自体はDB2の一意制約またはVSAMのキー定義により自動的に実行される。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| CUSTOMER | INSERT | 顧客情報追加時 |
| POLICY | INSERT | ポリシー情報追加時 |

#### 送信ログテーブル

リターンコード02（重複検出）の場合、ログ出力は行われない場合がある（ビジネスエラーとして扱う）。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 重複キーエラー | 同一キーのレコードが既存 | ユーザーに別の値の入力を促す |
| 更新競合 | 他トランザクションが先に更新 | 再度データを取得して更新 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

24時間365日、システム稼働中は常に設定可能。

## セキュリティ考慮事項

- リターンコード02自体には機密情報は含まれない
- 重複の詳細情報は返さないため、データ構造の推測を防止

## 備考

- リターンコード02は顧客情報更新時に使用される（通知一覧記載）
- 具体的な実装箇所はVSAM/DB2プログラムのエラーハンドリング部分
- DB2の場合、SQLCODE = -803（SQLSTATE '23505'）が一意制約違反
- VSAMの場合、DFHRESP(DUPREC)が重複レコードエラー
- 現在のソースコードでは明示的なリターンコード02の設定箇所は未確認（実装要確認）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 重複エラーの発生条件を理解する

DB2/VSAMでの重複エラー発生条件を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DB2操作プログラム | - | SQLCODE = -803（一意制約違反）の判定処理を確認 |
| 1-2 | VSAM操作プログラム | - | DFHRESP(DUPREC)の判定処理を確認 |

**想定される設定パターン**:
```cobol
IF SQLCODE = -803                 ... 一意制約違反
  MOVE '02' TO CA-RETURN-CODE     ... リターンコード02設定
END-IF
```

または:

```cobol
IF WS-RESP = DFHRESP(DUPREC)      ... 重複レコードエラー
  MOVE '02' TO CA-RETURN-CODE     ... リターンコード02設定
END-IF
```

### 実装状況

現在のGENAPPソースコードでは、リターンコード02の明示的な設定箇所は確認されていない。将来の実装または拡張時に使用される予定のエラーコードである可能性がある。

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgcmarea.cpy | `base/src/lgcmarea.cpy` | コピーブック | COMMAREA定義（CA-RETURN-CODE含む） |
| lgapdb01.cbl | `base/src/lgapdb01.cbl` | ソース | ポリシー追加（DB2）- 重複チェック候補 |
| lgacdb01.cbl | `base/src/lgacdb01.cbl` | ソース | 顧客追加（DB2）- 重複チェック候補 |
