# 通知設計書 8-リターンコード70

## 概要

本ドキュメントは、GENAPPアプリケーションにおけるリターンコード70（顧客が存在しない）の設計を定義する。ポリシー追加時に親顧客が見つからない場合に発生するリターンコードである。

### 本通知の処理概要

本通知は、GENAPPアプリケーションの業務プログラムがポリシーの追加処理を実行した際に、指定された顧客番号に対応する顧客レコードが存在しない場合に、COMMAREAのCA-RETURN-CODEフィールドに設定されるリターンコードである。

**業務上の目的・背景**：GENAPPは保険ポリシー管理システムであり、ポリシーは必ず顧客に紐付く設計となっている。ポリシーを追加する際に、指定された顧客番号が存在しない場合、参照整合性の観点からポリシーの追加は許可されない。リターンコード70は「親顧客が存在しない」ことを示し、呼び出し元は適切なエラーメッセージ（「Customer does not exist」）を表示して、ユーザーに正しい顧客番号の入力を促すことができる。

**通知の送信タイミング**：ポリシー追加処理において、顧客情報の存在確認（外部キーチェック）を行った結果、該当する顧客が見つからなかった場合に設定される。

**通知の受信者**：業務プログラムを呼び出したプログラム（LGTESTP1-P4等）が受信者となる。

**通知内容の概要**：CA-RETURN-CODE = '70'（2桁数字）のみ。顧客番号の詳細は含まれない。

**期待されるアクション**：呼び出し元プログラムは、CA-RETURN-CODE = 70を確認したら、「Customer does not exist」メッセージを表示し、ユーザーに正しい顧客番号の入力を促す。

## 通知種別

エラーコード（COMMAREA リターンコード）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（COMMAREA経由） |
| 優先度 | 通常（処理結果通知） |
| リトライ | なし（単一のリターン値） |

### 送信先決定ロジック

送信先はCOMMAREAを渡した呼び出し元プログラムに固定。

## 通知テンプレート

### リターンコードの場合

| 項目 | 内容 |
|-----|------|
| フィールド名 | CA-RETURN-CODE |
| データ型 | PIC 9(2) |
| 値 | 70 |

### 本文テンプレート

```
CA-RETURN-CODE = 70
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | リターンコードのみ |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| CA-RETURN-CODE | 処理結果コード | DFHCOMMAREA | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ポリシー追加 | 顧客存在確認失敗 | 顧客テーブルに該当レコードなし | 親顧客が存在しない |
| DB2照会 | 外部キーチェック失敗 | SQLCODE = 100（顧客テーブル） | 顧客照会でデータなし |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 顧客存在時 | 顧客が正常に見つかった場合はリターンコード70は設定されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ポリシー追加処理開始] --> B[顧客存在確認]
    B --> C{顧客存在?}
    C -->|No| D[MOVE '70' TO CA-RETURN-CODE]
    C -->|Yes| E[ポリシー追加処理続行]
    D --> F[EXEC CICS RETURN]
    E --> G{追加成功?}
    G -->|Yes| H[CA-RETURN-CODE = '00']
    G -->|No| I[エラーコード設定]
    H --> F
    I --> F
    F --> J[呼び出し元に戻る]
    J --> K{CA-RETURN-CODE判定}
    K -->|70| L[Customer does not exist メッセージ表示]
    K -->|00| M[成功メッセージ表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| CUSTOMER | 顧客存在確認 | 顧客番号で検索 |

### テーブル別参照項目詳細

#### CUSTOMERテーブル

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| CUSTOMERNUMBER | 顧客番号 | WHERE CUSTOMERNUMBER = :CA-CUSTOMER-NUM |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 顧客不存在時は更新処理に進まない |

#### 送信ログテーブル

リターンコード70（顧客不存在）の場合、ログ出力は行われない（ビジネスエラーとして扱う）。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 顧客不存在 | 指定された顧客番号が存在しない | 「Customer does not exist」メッセージ表示、正しい顧客番号の入力を促す |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

24時間365日、システム稼働中は常に設定可能。

## セキュリティ考慮事項

- リターンコード70自体には機密情報は含まれない
- 顧客番号の存在確認結果を返すことで、有効な顧客番号の推測に利用される可能性があるが、ビジネス上必要な情報として許容

## 備考

- リターンコード70は「親顧客が存在しない」ことを示すGENAPP固有のエラーコード
- LGTESTP1のNO-ADD処理（Line 287-294）で判定：When 70, Move 'Customer does not exist' To ERP1FLDO
- ポリシー追加プログラム（LGAPOL01→LGAPDB01）で顧客存在確認が行われる
- 呼び出し元でSyncpoint Rollbackを実行してトランザクションをロールバック

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 呼び出し元でのリターンコード70判定を理解する

画面プログラムでのリターンコード70判定とメッセージ表示処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgtestp1.cbl | `base/src/lgtestp1.cbl` | 行287-294でNO-ADD処理内でCA-RETURN-CODE = 70判定、「Customer does not exist」メッセージ設定 |

**リターンコード70判定**（lgtestp1.cbl 行287-294）:
```cobol
NO-ADD.
    Evaluate CA-RETURN-CODE
      When 70                                  ... 顧客不存在
        Move 'Customer does not exist' To ERP1FLDO
        Go To ERROR-OUT
      When Other                               ... その他のエラー
        Move 'Error Adding Motor Policy' To ERP1FLDO
        Go To ERROR-OUT
    End-Evaluate.
```

#### Step 2: ポリシー追加プログラムでの顧客存在確認を理解する

ポリシー追加時の顧客存在確認とリターンコード70設定処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | lgapdb01.cbl | `base/src/lgapdb01.cbl` | 顧客存在確認処理とリターンコード70設定箇所を確認 |

### プログラム呼び出し階層図

```
画面プログラム（LGTESTP1等）
    │
    ├─ オプション'2'（追加）選択
    │
    └─ LINK LGAPOL01
           │
           └─ LINK LGAPDB01（顧客存在確認）
                  │
                  ├─ 顧客存在確認SQL実行
                  │      │
                  │      └─ SQLCODE = 100（顧客なし）
                  │             └─ MOVE '70' TO CA-RETURN-CODE
                  │
                  └─ RETURN
                         │
                         └─ 呼び出し元でCA-RETURN-CODE判定
                                │
                                └─ When 70
                                       ├─ Syncpoint Rollback
                                       └─ 'Customer does not exist' 表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgtestp1.cbl | `base/src/lgtestp1.cbl` | ソース | リターンコード70判定・メッセージ表示（行287-294） |
| lgapol01.cbl | `base/src/lgapol01.cbl` | ソース | ポリシー追加制御 |
| lgapdb01.cbl | `base/src/lgapdb01.cbl` | ソース | ポリシー追加（DB2）- 顧客存在確認 |
