# 通知設計書 9-リターンコード80

## 概要

本ドキュメントは、GENAPPアプリケーションにおけるリターンコード80（VSAMファイル書き込みエラー）の設計を定義する。LGACVS01、LGAPVS01プログラムで使用されるリターンコードである。

### 本通知の処理概要

本通知は、GENAPPアプリケーションのVSAMアクセスプログラムがファイル書き込み（WRITE）処理を実行した際に、エラーが発生した場合に、COMMAREAのCA-RETURN-CODEフィールドに設定されるリターンコードである。

**業務上の目的・背景**：GENAPPは保険ポリシー管理システムであり、顧客情報やポリシー情報をVSAMファイルに格納している。VSAMファイルへの書き込み処理が失敗した場合、データの整合性を保つため即座にエラーを検知し、適切な対処を行う必要がある。リターンコード80は「VSAMファイル書き込みエラー」を示し、呼び出し元はトランザクションのロールバックと適切なエラーメッセージの表示を行うことができる。

**通知の送信タイミング**：EXEC CICS WRITE FILE文の実行後、WS-RESPがDFHRESP(NORMAL)以外の場合に設定される。エラーメッセージをTDQ/TSQに出力した後、RETURNまたはABENDで処理を終了する。

**通知の受信者**：業務プログラムを呼び出したプログラムが受信者となる。また、TDQ/TSQにエラー詳細が出力されるため、運用担当者も間接的に受信者となる。

**通知内容の概要**：CA-RETURN-CODE = '80'（2桁数字）に加え、TDQ/TSQにはエラー詳細（日時、プログラム名、顧客番号、ポリシー番号、RESPコード、RESP2コード）が出力される。

**期待されるアクション**：呼び出し元プログラムは、CA-RETURN-CODE = 80を確認したら、トランザクションをロールバックし、エラーメッセージを表示する。運用担当者はTDQ/TSQのログを確認して、エラーの原因を調査する。

## 通知種別

エラーコード（COMMAREA リターンコード）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（COMMAREA経由） |
| 優先度 | 高（書き込みエラーは重大） |
| リトライ | なし（単一のリターン値） |

### 送信先決定ロジック

送信先はCOMMAREAを渡した呼び出し元プログラムに固定。エラー詳細はTDQ（CSMT）とTSQ（GENAERRS）に出力される。

## 通知テンプレート

### リターンコードの場合

| 項目 | 内容 |
|-----|------|
| フィールド名 | CA-RETURN-CODE |
| データ型 | PIC 9(2) |
| 値 | 80 |

### 本文テンプレート（TDQ/TSQ出力）

```
{DATE} {TIME} {PROGRAM} CNUM={CUSTOMER-NUM} Write file KSDSCUST RESP={RESP} RESP2={RESP2}
```
または
```
{DATE} {TIME} {PROGRAM} PNUM={POLICY-NUM} CNUM={CUSTOMER-NUM} Write file KSDSPOLY RESP={RESP} RESP2={RESP2}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | リターンコードとTDQ/TSQログのみ |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| CA-RETURN-CODE | 処理結果コード | DFHCOMMAREA | Yes |
| DATE | エラー発生日付 | EXEC CICS FORMATTIME | Yes |
| TIME | エラー発生時刻 | EXEC CICS FORMATTIME | Yes |
| PROGRAM | プログラム名 | ERROR-MSG固定値 | Yes |
| CUSTOMER-NUM | 顧客番号 | CA-CUSTOMER-NUM | Yes |
| POLICY-NUM | ポリシー番号 | CA-POLICY-NUM | 条件付き |
| RESP | CICSレスポンスコード | WS-RESP | Yes |
| RESP2 | CICS拡張レスポンスコード | EIBRESP2 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| VSAM書き込み | WRITE FILE失敗 | WS-RESP Not = DFHRESP(NORMAL) | VSAMファイル書き込みエラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 正常完了時 | WS-RESP = DFHRESP(NORMAL)の場合はリターンコード80は設定されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[VSAM書き込み処理] --> B[EXEC CICS WRITE FILE]
    B --> C{WS-RESP判定}
    C -->|Not NORMAL| D[MOVE '80' TO CA-RETURN-CODE]
    C -->|NORMAL| E[正常終了処理]
    D --> F[PERFORM WRITE-ERROR-MESSAGE]
    F --> G[EXEC CICS LINK LGSTSQ]
    G --> H[EXEC CICS ABEND ABCODE LGV0 NODUMP]
    H --> I[異常終了]
    E --> J[EXEC CICS RETURN]
    J --> K[呼び出し元に戻る]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | VSAMファイル操作のためDB2参照なし |

### テーブル別参照項目詳細

VSAMファイル操作のため、DB2テーブルの参照は行わない。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | VSAMファイル操作のためDB2更新なし |

#### VSAMファイル

| ファイル名 | 操作 | 概要 |
|-----------|------|------|
| KSDSCUST | WRITE | 顧客情報追加（LGACVS01） |
| KSDSPOLY | WRITE | ポリシー情報追加（LGAPVS01） |

#### 送信ログ

TDQ（CSMT）およびTSQ（GENAERRS）にエラー詳細が出力される。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| VSAM書き込み失敗 | WS-RESP Not = DFHRESP(NORMAL) | TDQ/TSQにログ出力、ABEND発行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

24時間365日、システム稼働中は常に設定可能。

## セキュリティ考慮事項

- リターンコード80自体には機密情報は含まれない
- TDQ/TSQに出力されるログには顧客番号・ポリシー番号が含まれるため、アクセス制御が必要

## 備考

- リターンコード80はVSAMファイル書き込みエラー専用
- 使用プログラム：LGACVS01（顧客追加）、LGAPVS01（ポリシー追加）
- LGACVS01（Line 77-80）: MOVE '80' TO CA-RETURN-CODE, ABEND ABCODE('LGV0') NODUMP
- LGAPVS01（Line 144）: MOVE '80' TO CA-RETURN-CODE
- ABENDコードはLGV0（LGACVS01）で、ダンプは出力されない（NODUMP）
- エラー発生時はWRITE-ERROR-MESSAGEを実行してTDQ/TSQにログ出力

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: リターンコード80の設定箇所を理解する

VSAM WRITE失敗時のリターンコード80設定処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lgacvs01.cbl | `base/src/lgacvs01.cbl` | 行77-80でVSAM WRITE失敗時に'80'を設定、ABENDを発行 |
| 1-2 | lgapvs01.cbl | `base/src/lgapvs01.cbl` | 行144でVSAM WRITE失敗時に'80'を設定 |

**リターンコード80設定**（lgacvs01.cbl 行77-80）:
```cobol
IF WS-RESP Not = DFHRESP(NORMAL)  ... WRITE失敗判定
  MOVE '80' TO CA-RETURN-CODE      ... リターンコード80設定
  PERFORM WRITE-ERROR-MESSAGE      ... エラーログ出力
  EXEC CICS ABEND ABCODE('LGV0') NODUMP END-EXEC
END-IF
```

### プログラム呼び出し階層図

```
画面プログラム（LGTESTP1等）
    │
    └─ LINK LGAPOL01/LGACUS01
           │
           └─ LINK LGAPVS01/LGACVS01
                  │
                  ├─ EXEC CICS WRITE FILE
                  │      │
                  │      └─ WS-RESP Not = DFHRESP(NORMAL)
                  │             ├─ MOVE '80' TO CA-RETURN-CODE
                  │             ├─ WRITE-ERROR-MESSAGE → LGSTSQ
                  │             └─ ABEND 'LGV0' NODUMP
                  │
                  └─ （異常終了）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lgacvs01.cbl | `base/src/lgacvs01.cbl` | ソース | 顧客追加（VSAM）- リターンコード80設定（行77-80） |
| lgapvs01.cbl | `base/src/lgapvs01.cbl` | ソース | ポリシー追加（VSAM）- リターンコード80設定（行144） |
| lgstsq.cbl | `base/src/lgstsq.cbl` | ソース | エラーログ出力 |
