---
generated_at: 2026-01-06 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：1-TDQエラーメッセージ通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **配信時間帯設定**：運用要件の確認が必要
  2. **レート制限**：CICSシステム設定の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgstsq.cbl` - LGSTSQプログラムソースコード
- E-02: `base/src/lgacvs01.cbl` - LGACVS01プログラムソースコード
- E-03: `base/src/lgapvs01.cbl` - LGAPVS01プログラムソースコード
- E-04: `base/src/lgucvs01.cbl` - LGUCVS01プログラムソースコード
- E-05: `base/src/lgupvs01.cbl` - LGUPVS01プログラムソースコード
- E-06: `base/src/lgdpvs01.cbl` - LGDPVS01プログラムソースコード
- E-07: `base/src/lgipdb01.cbl` - LGIPDB01プログラムソースコード
- E-08: `base/src/lgapol01.cbl` - LGAPOL01プログラムソースコード
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSMTキューへエラーメッセージを出力する | E-01 (Line 94: WRITEQ TD QUEUE(STDQ-NAME), Line 40: STDQ-NAME VALUE 'CSMT') | ○ |
| C-02 | LGSTSQプログラム経由で出力される | E-02, E-03, E-04, E-05, E-06, E-07, E-08 (EXEC CICS LINK PROGRAM('LGSTSQ')) | ○ |
| C-03 | エラーメッセージに日時が含まれる | E-02 (Line 90-95: ASKTIME/FORMATTIME), E-07 (Line 1001-1006) | ○ |
| C-04 | エラーメッセージにプログラム名が含まれる | E-02 (Line 34: VALUE ' LGACVS01'), E-06 (Line 40: VALUE ' LGDPVS01') | ○ |
| C-05 | エラーメッセージに顧客番号が含まれる | E-02 (Line 37: EM-CUSNUM, Line 99: Move CA-Customer-Num To EM-Cusnum) | ○ |
| C-06 | エラーメッセージにポリシー番号が含まれる | E-06 (Line 43: EM-POLNUM, Line 110: Move CA-POLICY-NUM To EM-POLNUM) | ○ |
| C-07 | エラーメッセージにSQLコードが含まれる | E-07 (Line 59-60: EM-SQLRC, Line 999: MOVE SQLCODE TO EM-SQLRC) | ○ |
| C-08 | VSAMエラー時にRESPコードを出力 | E-02 (Line 41-43: EM-RESPRC, EM-RESP2RC), E-02 (Line 100-101) | ○ |
| C-09 | 送信方式は同期である | E-02 (Line 102-105: EXEC CICS LINK同期呼び出し) | ○ |
| C-10 | COMMAREAが受信されない場合ABEND(LGCA)を発行 | E-07 (Line 251-255: ABEND ABCODE('LGCA') NODUMP), E-08 (Line 98-102) | ○ |
| C-11 | SQLCODE=100は正常ケースとして扱う | E-07 (Line 421-423: IF SQLCODE EQUAL 100, MOVE '01' TO CA-RETURN-CODE) | ○ |
| C-12 | SYSIDはEXEC CICS ASSIGNで取得 | E-01 (Line 60-62: EXEC CICS ASSIGN SYSID(WRITE-MSG-SYSID)) | ○ |
| C-13 | エラー時リトライは行わない | E-02, E-03, E-04, E-05, E-06 (リトライロジックなし) | ○ |
| C-14 | キュー名Q=パラメータで変更可能 | E-01 (Line 83-88: IF WRITE-MSG-MSG(1:2) = 'Q=') | ○ |
| C-15 | COMMAREAの最大90バイトをログ出力 | E-02 (Line 106-120: IF EIBCALEN < 91), E-07 (Line 1015-1028) | ○ |
| C-16 | NODUMPオプション指定でABEND | E-07 (Line 254: ABEND ABCODE('LGCA') NODUMP) | ○ |
| C-17 | 24時間365日出力可能 | **根拠なし** | △ |
| C-18 | レート制限なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 配信時間帯の制限：ソースコードには時間帯制限のロジックが見当たらないため、24時間出力可能と推測したが、運用要件書での確認が必要
  - 候補：運用マニュアル / CICS設定ドキュメント / 運用要件定義書
- レート制限：CICSシステムレベルでの制限設定が別途存在する可能性あり
  - 候補：CICSシステム定義 / TDQ定義 / 運用設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なエラーログ出力ロジックはソースコードで確認済み
- 1: 中リスク - 運用時間帯・レート制限は運用要件との整合性確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] CSMTキューがCICSシステムで正しく定義されているか確認
- [ ] 運用監視システムがCSMTキューを正しく監視しているか確認
- [ ] エラーメッセージフォーマットが運用要件と一致しているか確認
