---
generated_at: 2026-01-06 10:39:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-リターンコード81

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgdpvs01.cbl` - LGDPVS01プログラムソースコード
- E-02: `base/src/lgupvs01.cbl` - LGUPVS01プログラムソースコード
- E-03: `base/src/lgucvs01.cbl` - LGUCVS01プログラムソースコード
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LGDPVS01でリターンコード81を設定 | E-01 (Line 88: MOVE '81' TO CA-RETURN-CODE) | ○ |
| C-02 | LGUPVS01でリターンコード81を設定 | E-02 (Line 149: MOVE '81' TO CA-RETURN-CODE) | ○ |
| C-03 | LGUCVS01でリターンコード81を設定 | E-03 (Line 79: MOVE '81' TO CA-RETURN-CODE) | ○ |
| C-04 | WS-RESP Not = DFHRESP(NORMAL)で判定 | E-01 (Line 86), E-02 (Line 147), E-03 (Line 77) | ○ |
| C-05 | LGDPVS01でDELETE FILE実行 | E-01 (Line 81-85: Delete File('KSDSPOLY')) | ○ |
| C-06 | LGUPVS01でREAD FILE実行 | E-02 (Line 139-146: Read File('KSDSPOLY') Update) | ○ |
| C-07 | LGUCVS01でREAD FILE実行 | E-03 (Line 69-76: Read File('KSDSCUST') Update) | ○ |
| C-08 | KSDSPOLYファイルを操作 | E-01 (Line 81), E-02 (Line 139) | ○ |
| C-09 | KSDSCUSTファイルを操作 | E-03 (Line 69) | ○ |
| C-10 | WRITE-ERROR-MESSAGEを実行 | E-01 (Line 89), E-02 (Line 150), E-03 (Line 80) | ○ |
| C-11 | LGSTSQを呼び出してログ出力 | E-01 (Line 113-116), E-02 (Line 187-190), E-03 (Line 117-120) | ○ |
| C-12 | LGUCVS01でABEND ABCODE('LGV1')を発行 | E-03 (Line 81: ABEND ABCODE('LGV1') NODUMP) | ○ |
| C-13 | LGUPVS01でABEND ABCODE('LGV3')を発行 | E-02 (Line 151: ABEND ABCODE('LGV3') NODUMP) | ○ |
| C-14 | エラーメッセージに操作内容を含む | E-01 (Line 46-47: 'Delete file KSDSPOLY'), E-02 (Line 71-72: 'Re-write KSDSPOLY') | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - リターンコード81の発生条件と処理はソースコードで完全に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] KSDSCUSTおよびKSDSPOLYファイルがCICSで正しく定義されているか確認
- [ ] ABENDコード'LGV1'、'LGV3'が運用監視システムで正しく検知されるか確認
