---
generated_at: 2026-01-06 18:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-リターンコード82

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ考慮事項のアクセス権限設定**：一般的なベストプラクティスに基づく記述、具体的な設定ファイルの根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgupvs01.cbl` - ポリシー更新VSAMプログラム
- E-02: `base/src/lgucvs01.cbl` - 顧客更新VSAMプログラム
- E-03: `base/src/lgstsq.cbl` - エラーメッセージ出力プログラム
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リターンコード82はVSAMファイル更新エラーを示す | E-01 L162, E-02 L92 | ○ |
| C-02 | LGUPVS01でKSDSPOLYファイルへのREWRITE失敗時に発生 | E-01 L155-166 | ○ |
| C-03 | LGUCVS01でKSDSCUSTファイルへのREWRITE失敗時に発生 | E-02 L85-96 | ○ |
| C-04 | エラーメッセージにはRESPとRESP2コードが含まれる | E-01 L74-76, E-02 L42-44 | ○ |
| C-05 | 日時情報はASKTIME/FORMATTIMEで取得 | E-01 L175-180, E-02 L105-110 | ○ |
| C-06 | LGSTSQプログラムを経由してキュー出力 | E-01 L187-190, E-02 L117-120 | ○ |
| C-07 | TDQのCSMTキューに出力 | E-03 L94-99 | ○ |
| C-08 | TSQのGENAERRSキューに出力 | E-03 L82, L105-111 | ○ |
| C-09 | Q=nnnnパラメータでキュー名変更可能 | E-03 L83-88 | ○ |
| C-10 | ABEND発行時にNODUMPオプションを使用 | E-01 L164, E-02 L94 | ○ |
| C-11 | ABENDコードはLGUCVS01でLGV2、LGUPVS01でLGV4 | E-01 L164, E-02 L94 | ○ |
| C-12 | COMMAAREの内容もエラーメッセージに含まれる | E-01 L191-205, E-02 L121-135 | ○ |
| C-13 | エラーメッセージにプログラム名が固定値で含まれる | E-01 L65, E-02 L35 | ○ |
| C-14 | 顧客番号がエラーメッセージに含まれる | E-01 L69-70, E-02 L38 | ○ |
| C-15 | ポリシー番号がLGUPVS01のエラーメッセージに含まれる | E-01 L68 | ○ |
| C-16 | リターンコード81の後にREWRITEを実行 | E-01 L139-153, E-02 L69-83 | ○ |
| C-17 | TSQ出力時にNOSUSPENDオプションを使用 | E-03 L108 | ○ |
| C-18 | セキュリティ考慮事項のアクセス権限設定推奨 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティ設定に関する具体的な設定ファイルや構成情報
  - 候補：CICS定義ファイル / セキュリティ設定ドキュメント / 運用マニュアル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードベースから直接確認できる技術仕様が中心

## 6) レビュアーチェックリスト（最小）
- [ ] VSAMファイル名（KSDSPOLY、KSDSCUST）が正しいか確認
- [ ] ABENDコード（LGV2、LGV4）の意味が運用ドキュメントと一致するか確認
- [ ] セキュリティ考慮事項が組織のポリシーと整合しているか確認
