---
generated_at: 2026-01-06 18:27:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-リターンコード88

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgipdb01.cbl` - ポリシー照会DB2プログラム
- E-02: `base/src/lgstsq.cbl` - エラーメッセージ出力プログラム
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リターンコード88はDBカーソルクローズエラーを示す | E-01 L855-858, L938-941, E-03 L12 | ○ |
| C-02 | LGIPDB01プログラムでのみ使用される | E-01, E-03 L12 | ○ |
| C-03 | GET-Commercial-DB2-INFO-3でCust_Cursorクローズ時に発生 | E-01 L852-859 | ○ |
| C-04 | GET-Commercial-DB2-INFO-5でZip_Cursorクローズ時に発生 | E-01 L935-943 | ○ |
| C-05 | SQLCODE NOT EQUAL 0の場合にエラー発生 | E-01 L855, L938 | ○ |
| C-06 | WRITE-ERROR-MESSAGE実行でエラーメッセージを出力 | E-01 L857, L940 | ○ |
| C-07 | END-PROGRAM実行で処理終了 | E-01 L858, L941 | ○ |
| C-08 | エラーメッセージにSQLCODEが含まれる | E-01 L59-60, L999 | ○ |
| C-09 | エラーメッセージに顧客番号が含まれる | E-01 L54-55, L266 | ○ |
| C-10 | エラーメッセージにポリシー番号が含まれる | E-01 L56-57, L267 | ○ |
| C-11 | SQL操作種別として' SELECT Commercial 'が設定される | E-01 L629, L732, L837, L921 | ○ |
| C-12 | POLICY表とCOMMERCIAL表を結合して参照 | E-01 L113-118, L671-677 | ○ |
| C-13 | LGSTSQプログラム経由でキュー出力 | E-01 L1010-1013 | ○ |
| C-14 | TDQ CSMTとTSQ GENAERRSに出力 | E-02 L94-99, L105-111 | ○ |
| C-15 | ABENDは発行されずCICS RETURNで終了 | E-01 L858, L941, L313 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張がソースコードで確認可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードベースから直接確認できる技術仕様が中心

## 6) レビュアーチェックリスト（最小）
- [ ] Cust_CursorとZip_Cursorの定義が正しく参照されているか確認
- [ ] カーソルクローズエラー時のリソース解放が適切か確認
- [ ] END-PROGRAM実行後の呼び出し元の動作を確認
