---
generated_at: 2026-01-06 18:29:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：13-リターンコード89

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **想定されるSQLCODE一覧**：一般的なDB2知識に基づく記述、コード内での具体的なハンドリング根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgipdb01.cbl` - ポリシー照会DB2プログラム
- E-02: `base/src/lgstsq.cbl` - エラーメッセージ出力プログラム
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リターンコード89はDBカーソルオープンエラーを示す | E-01 L843-847, L925-930, E-03 L13 | ○ |
| C-02 | LGIPDB01プログラムでのみ使用される | E-01, E-03 L13 | ○ |
| C-03 | GET-Commercial-DB2-INFO-3でCust_Cursorオープン時に発生 | E-01 L840-847 | ○ |
| C-04 | GET-Commercial-DB2-INFO-5でZip_Cursorオープン時に発生 | E-01 L923-930 | ○ |
| C-05 | SQLCODE NOT EQUAL 0の場合にエラー発生 | E-01 L843, L926 | ○ |
| C-06 | WRITE-ERROR-MESSAGE実行でエラーメッセージを出力 | E-01 L845, L928 | ○ |
| C-07 | END-PROGRAM実行で処理終了 | E-01 L846, L929 | ○ |
| C-08 | Cust_Cursorの定義（顧客番号による検索） | E-01 L89-118 | ○ |
| C-09 | Zip_Cursorの定義（郵便番号による検索） | E-01 L120-149 | ○ |
| C-10 | POLICY表とCOMMERCIAL表を結合 | E-01 L113-118, L144-149 | ○ |
| C-11 | エラーメッセージにSQLCODEが含まれる | E-01 L59-60, L999 | ○ |
| C-12 | SQL操作種別として' SELECT Commercial 'が設定される | E-01 L837, L921 | ○ |
| C-13 | LGSTSQプログラム経由でキュー出力 | E-01 L1010-1013 | ○ |
| C-14 | TDQ CSMTとTSQ GENAERRSに出力 | E-02 L94-99, L105-111 | ○ |
| C-15 | ABENDは発行されずCICS RETURNで終了 | E-01 L846, L929, L313 | ○ |
| C-16 | 想定されるSQLCODE（-501, -502, -504, -911） | **根拠なし**（DB2一般知識） | △ |

## 4) 不足情報（Unknown / Missing）
- 想定されるSQLCODEの具体的なハンドリングロジック
  - 候補：DB2エラーコード対応表 / 運用マニュアル / IBM DB2ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードベースから直接確認できる技術仕様が中心

## 6) レビュアーチェックリスト（最小）
- [ ] Cust_CursorとZip_Cursorの定義が正しく参照されているか確認
- [ ] カーソルオープンエラー時の想定SQLCODEが環境に適合しているか確認
- [ ] END-PROGRAM実行後の呼び出し元の動作を確認
