---
generated_at: 2026-01-06 18:31:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：14-リターンコード90

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **代表的なSQLCODE一覧**：一般的なDB2知識に基づく記述、コード内での具体的なハンドリング根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgipdb01.cbl` - ポリシー照会DB2プログラム（L426,517,615,717,822）
- E-02: `base/src/lgicdb01.cbl` - 顧客照会DB2プログラム（L200）
- E-03: `base/src/lgacdb01.cbl` - 顧客追加DB2プログラム（L246,275）
- E-04: `base/src/lgapdb01.cbl` - ポリシー追加DB2プログラム（L301,390,428,474,548）
- E-05: `base/src/lgucdb01.cbl` - 顧客更新DB2プログラム（L176）
- E-06: `base/src/lgupdb01.cbl` - ポリシー更新DB2プログラム（L263,267,339,354,377,413,449,490）
- E-07: `base/src/lgdpdb01.cbl` - ポリシー削除DB2プログラム（L199）
- E-08: `base/src/lgstsq.cbl` - エラーメッセージ出力プログラム
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義（L14）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リターンコード90は一般SQLエラーを示す | E-01〜E-07, E-09 L14 | ○ |
| C-02 | LGIPDB01でSELECT失敗時に発生 | E-01 L426,517,615,717,822 | ○ |
| C-03 | LGICDB01でSELECT失敗時に発生 | E-02 L200 | ○ |
| C-04 | LGACDB01でINSERT失敗時に発生 | E-03 L246,275 | ○ |
| C-05 | LGAPDB01でINSERT失敗時に発生 | E-04 L301,390,428,474,548 | ○ |
| C-06 | LGUCDB01でUPDATE失敗時に発生 | E-05 L176 | ○ |
| C-07 | LGUPDB01でUPDATE失敗時に発生 | E-06 L263,267,339,354,377,413,449,490 | ○ |
| C-08 | LGDPDB01でDELETE失敗時に発生 | E-07 L199 | ○ |
| C-09 | SQLCODEをエラーメッセージに含める | E-01 L59-60 | ○ |
| C-10 | SQLCODE=100はリターンコード01として処理 | E-01 L421-423 | ○ |
| C-11 | SQL操作種別がEM-SQLREQに設定される | E-01 L329,443,531,629 | ○ |
| C-12 | LGSTSQプログラム経由でキュー出力 | E-01 L1010-1013 | ○ |
| C-13 | TDQ CSMTに出力 | E-08 L94-99 | ○ |
| C-14 | TSQ GENAERRSに出力 | E-08 L82,105-111 | ○ |
| C-15 | ABENDは発行されない | E-01〜E-07（ABENDコードなし） | ○ |
| C-16 | POLICY表を参照 | E-01 L361-367 | ○ |
| C-17 | ENDOWMENT表を参照 | E-01 L361 | ○ |
| C-18 | HOUSE表を参照 | E-01 L469-475 | ○ |
| C-19 | MOTOR表を参照 | E-01 L563-569 | ○ |
| C-20 | 代表的なSQLCODE（-803,-811,-904,-911,-913） | **根拠なし**（DB2一般知識） | △ |

## 4) 不足情報（Unknown / Missing）
- 代表的なSQLCODEの具体的なハンドリングロジック
  - 候補：DB2エラーコード対応表 / 運用マニュアル / IBM DB2ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードベースから直接確認できる技術仕様が中心

## 6) レビュアーチェックリスト（最小）
- [ ] 各プログラムでのリターンコード90の発生条件が正しいか確認
- [ ] 想定されるSQLCODEが環境に適合しているか確認
- [ ] 呼び出し元でのエラーハンドリングが適切か確認
