---
generated_at: 2026-01-06 18:33:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：15-リターンコード98

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **COMMAREAサイズ要件の具体的な数値**：コード内に定数定義があるが、実際の値は実行時に決定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgipdb01.cbl` - ポリシー照会（L391,488,582,690,794）
- E-02: `base/src/lgicdb01.cbl` - 顧客照会DB2（L141）
- E-03: `base/src/lgacus01.cbl` - 顧客追加VSAM（L113）
- E-04: `base/src/lgacdb01.cbl` - 顧客追加DB2（L166）
- E-05: `base/src/lgdpdb01.cbl` - ポリシー削除DB2（L144）
- E-06: `base/src/lgapdb01.cbl` - ポリシー追加DB2（L211）
- E-07: `base/src/lgdpol01.cbl` - ポリシー削除（L108）
- E-08: `base/src/lgicus01.cbl` - 顧客照会VSAM（L105）
- E-09: `base/src/lgupol01.cbl` - ポリシー更新（L119,127,135）
- E-10: `base/src/lgapol01.cbl` - ポリシー追加（L114）
- E-11: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義（L15）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リターンコード98はCOMMAREAサイズ不足を示す | E-01〜E-10, E-11 L15 | ○ |
| C-02 | LGIPDB01でサイズチェック後に発生 | E-01 L390-392, L487-489 | ○ |
| C-03 | LGICDB01でサイズチェック後に発生 | E-02 L141 | ○ |
| C-04 | LGACUS01でサイズチェック後に発生 | E-03 L113 | ○ |
| C-05 | LGACDB01でサイズチェック後に発生 | E-04 L166 | ○ |
| C-06 | LGDPDB01でサイズチェック後に発生 | E-05 L144 | ○ |
| C-07 | LGAPDB01でサイズチェック後に発生 | E-06 L211 | ○ |
| C-08 | EIBCALEN < WS-REQUIRED-CA-LENで判定 | E-01 L390 | ○ |
| C-09 | WS-CA-HEADERTRAILER-LENが33バイト | E-01 L73 | ○ |
| C-10 | 養老保険で可変長PADDINGDATAを考慮 | E-01 L383-386 | ○ |
| C-11 | EXEC CICS RETURNで即時終了 | E-01 L392, E-02 L142 | ○ |
| C-12 | ログ出力（TDQ/TSQ）は行われない | E-01〜E-10（LGSTSQ呼び出しなし） | ○ |
| C-13 | ABENDは発行されない | E-01〜E-10（ABEND命令なし） | ○ |
| C-14 | 'FINAL'マーカーを設定 | E-01 L417 | ○ |
| C-15 | LGUPOL01で複数の保険種別チェック | E-09 L119,127,135 | ○ |
| C-16 | LGAPOL01でサイズチェック後に発生 | E-10 L114 | ○ |
| C-17 | LGDPOL01でサイズチェック後に発生 | E-07 L108 | ○ |
| C-18 | COMMAREAサイズ要件の具体的な数値 | **根拠なし**（実行時決定） | △ |

## 4) 不足情報（Unknown / Missing）
- 各保険種別の具体的なCOMMAREAサイズ要件
  - 候補：LGCMAREA.cpy / システム設計書 / データ定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードベースから直接確認できる技術仕様が中心

## 6) レビュアーチェックリスト（最小）
- [ ] EIBCALENとWS-REQUIRED-CA-LENの比較ロジックが正しいか確認
- [ ] 各プログラムでのCOMMAREAサイズ計算が正確か確認
- [ ] 呼び出し元でのエラーハンドリングが適切か確認
