---
generated_at: 2026-01-06 18:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-リターンコード99

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgipdb01.cbl` - ポリシー照会（L275-310）
- E-02: `base/src/lgapdb01.cbl` - ポリシー追加（L204,239）
- E-03: `base/src/lgdpdb01.cbl` - ポリシー削除（L165）
- E-04: `base/src/lgucus01.cbl` - 顧客更新（L111）
- E-05: `base/src/lgupol01.cbl` - ポリシー更新（L140）
- E-06: `base/src/lgdpol01.cbl` - ポリシー削除VSAM（L124）
- E-07: `base/src/lgastat1.cbl` - 統計（L127）
- E-08: `base/src/lgacdb02.cbl` - 顧客追加（L150）
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義（L16）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リターンコード99は無効なリクエストIDを示す | E-01〜E-08, E-09 L16 | ○ |
| C-02 | LGIPDB01でWHEN OTHER時に発生 | E-01 L307-308 | ○ |
| C-03 | LGAPDB01でWHEN OTHER時に発生 | E-02 L204,239 | ○ |
| C-04 | LGDPDB01でWHEN OTHER時に発生 | E-03 L165 | ○ |
| C-05 | LGUCUS01でWHEN OTHER時に発生 | E-04 L111 | ○ |
| C-06 | LGUPOL01でWHEN OTHER時に発生 | E-05 L140 | ○ |
| C-07 | LGDPOL01でWHEN OTHER時に発生 | E-06 L124 | ○ |
| C-08 | LGASTAT1でGENAType Not = '00'時に発生 | E-07 L127 | ○ |
| C-09 | CA-REQUEST-IDがUPPER-CASE変換される | E-01 L275 | ○ |
| C-10 | LGIPDB01で01IEND,01IHOU,01IMOT,01ICOM,02ICOM,03ICOM,05ICOMが有効 | E-01 L277-305 | ○ |
| C-11 | LGAPDB01で01AEND,01AHOU,01AMOT,01ACOMが有効 | E-02 L186-232 | ○ |
| C-12 | LGDPDB01で01DEND,01DHOU,01DMOT,01DCOMが有効 | E-03 L147-163 | ○ |
| C-13 | ABENDは発行されない | E-01〜E-08（ABEND命令なし） | ○ |
| C-14 | EXEC CICS RETURNで終了 | E-01 L313 | ○ |
| C-15 | EVALUATE文で処理分岐 | E-01 L277-310 | ○ |
| C-16 | ログ出力は通常行われない | E-01〜E-08（LGSTSQ呼び出しなし） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張がソースコードで確認可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードベースから直接確認できる技術仕様が中心

## 6) レビュアーチェックリスト（最小）
- [ ] 各プログラムの有効なリクエストID一覧が網羅されているか確認
- [ ] UPPER-CASE変換の動作が正しいか確認
- [ ] 呼び出し元でのエラーハンドリングが適切か確認
