---
generated_at: 2026-01-06 18:37:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：17-統計収集開始通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **起動メッセージの実際の出力処理**：WS-Startupに定義されているが出力処理の確認不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgwebst5.cbl` - 統計収集プログラム
- E-02: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義（L17）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LGWEBST5プログラムで統計収集を実行 | E-01 L11, E-02 L17 | ○ |
| C-02 | GENASTATキューに出力 | E-01 L56 | ○ |
| C-03 | 1分ごとに自動再起動（CICS START） | E-01 L761-765 | ○ |
| C-04 | TRANSID 'SSST'で起動 | E-01 L761 | ○ |
| C-05 | GENAプール内のカウンターを使用 | E-01 L198 | ○ |
| C-06 | GENACUSTNUM（総顧客数）カウンター | E-01 L197, L268-272 | ○ |
| C-07 | GENA01ICUS00〜GENA01DCOM99カウンター | E-01 L199-233 | ○ |
| C-08 | EXEC CICS QUERY COUNTERでカウンター取得 | E-01 L268-272 | ○ |
| C-09 | TSQに現在値/前回値/差分値を保持 | E-01 L769-800 | ○ |
| C-10 | CountSuccess/CountErrorsを集計 | E-01 L670-673 | ○ |
| C-11 | EXEC CICS ASSIGN APPLIDでアプリケーションID取得 | E-01 L703-705 | ○ |
| C-12 | EXEC CICS FORMATTIMEで日時取得 | E-01 L262-265 | ○ |
| C-13 | シンボルリスト形式で出力（SymbList構造） | E-01 L76-156 | ○ |
| C-14 | WS-Startupに起動メッセージが定義 | E-01 L38-39 | ○ |
| C-15 | Tran-Rate-Intervalで時間間隔計算 | E-01 L715-767 | ○ |
| C-16 | Tran-Rate-Countsでカウンター処理 | E-01 L769-802 | ○ |
| C-17 | EXEC CICS RETURNで終了 | E-01 L708-709 | ○ |
| C-18 | 起動メッセージの実際の出力処理 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- WS-Startup（'GENAPP Statistics collector started.'）の実際の出力先・出力タイミング
  - 候補：起動時ログ出力 / コンソール出力 / 未使用

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードベースから直接確認できる技術仕様が中心

## 6) レビュアーチェックリスト（最小）
- [ ] GENASTATキューの出力形式がBusiness Monitorの仕様と一致するか確認
- [ ] カウンター名一覧が実際の業務処理と対応しているか確認
- [ ] 1分間隔の統計収集がシステム負荷に与える影響を確認
- [ ] WS-Startupメッセージの使用有無を確認
