---
generated_at: 2026-01-06 10:31:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：2-TSQエラーメッセージ通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **TSQ永続化設定**：CICS設定での確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgstsq.cbl` - LGSTSQプログラムソースコード
- E-02: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GENAERRSキューへエラーメッセージを出力する | E-01 (Line 82: MOVE 'GENAERRS' TO STSQ-NAME) | ○ |
| C-02 | TDQ出力と同一内容を保持する | E-01 (Line 105-111: 同じWRITE-MSG変数を使用) | ○ |
| C-03 | Q=パラメータでキュー名変更可能 | E-01 (Line 83-88: IF WRITE-MSG-MSG(1:2) = 'Q=' THEN MOVE WRITE-MSG-MSG(3:4) TO STSQ-EXT) | ○ |
| C-04 | キュー名はGENAnnnn形式 | E-01 (Line 33-37: STSQ構造体定義、Line 82: 'GENAERRS'、Line 84: STSQ-EXT) | ○ |
| C-05 | NOSUSPENDオプションを指定 | E-01 (Line 108: NOSUSPEND) | ○ |
| C-06 | TDQ出力直後にTSQ出力を実行 | E-01 (Line 94-99: WRITEQ TD, Line 105-111: WRITEQ TS) | ○ |
| C-07 | ストレージ不足時は書き込みをスキップ | E-01 (Line 101-103: コメント「If no space is available then the task will not wait」) | ○ |
| C-08 | メッセージ長はWS-RECV-LENで管理 | E-01 (Line 97, 109: LENGTH(WS-RECV-LEN)) | ○ |
| C-09 | SYSIDをメッセージ先頭に含む | E-01 (Line 26: WRITE-MSG-SYSID, Line 60-62: ASSIGN SYSID) | ○ |
| C-10 | 呼び出し方法はLINKまたはSTART | E-01 (Line 68-80: WS-INVOKEPROGによる判定) | ○ |
| C-11 | LINKの場合COMMAREAからデータ取得 | E-01 (Line 70: MOVE COMMA-DATA TO WRITE-MSG-MSG) | ○ |
| C-12 | STARTの場合RECEIVEでデータ取得 | E-01 (Line 73-79: EXEC CICS RECEIVE INTO(WS-RECV)) | ○ |
| C-13 | TSQはCICSリージョン固有 | E-02 (備考欄)、CICSの仕様として既知 | ○ |
| C-14 | リトライは行わない | E-01 (リトライロジックなし、NOSUSPENDで即時スキップ) | ○ |
| C-15 | TSQは永続化されない | **根拠なし**（CICS設定による） | △ |

## 4) 不足情報（Unknown / Missing）
- TSQの永続化設定：ソースコードではMAINオプションやAUXILIARYオプションが指定されていないため、デフォルト動作（MAIN=揮発性）と推測したが、CICS設定での確認が必要
  - 候補：CICS TSQモデル定義 / CSD定義 / 運用設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - TSQへのエラーログ出力ロジックはソースコードで確認済み
- 0: 低リスク - キュー名変更パラメータの仕様もソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] GENAERRSキューがCICSシステムで正しく定義されているか確認
- [ ] TSQのストレージ上限が適切に設定されているか確認
- [ ] 複数リージョン環境での運用を考慮した設計になっているか確認
