---
generated_at: 2026-01-06 10:32:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：3-画面エラーメッセージ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **他のポリシーメニュー（P2-P4）**：実装の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgtestp1.cbl` - LGTESTP1プログラムソースコード
- E-02: `base/src/lgtestc1.cbl` - LGTESTC1プログラムソースコード
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ERP1FLDOフィールドにメッセージを表示する | E-01 (Line 128, 158, 228, 239, 289, 292, 297, 301, 305) | ○ |
| C-02 | ERRFLDOフィールドにメッセージを表示する | E-02 (Line 141, 202, 212, 260, 264, 268) | ○ |
| C-03 | 「New Motor Policy Inserted」メッセージを表示 | E-01 (Line 127-128: Move 'New Motor Policy Inserted' To ERP1FLDO) | ○ |
| C-04 | 「Motor Policy Deleted」メッセージを表示 | E-01 (Line 157-158: Move 'Motor Policy Deleted' To ERP1FLDO) | ○ |
| C-05 | 「Motor Policy Updated」メッセージを表示 | E-01 (Line 227-228: Move 'Motor Policy Updated' To ERP1FLDO) | ○ |
| C-06 | 「Error Adding Motor Policy」メッセージを表示 | E-01 (Line 292: Move 'Error Adding Motor Policy' To ERP1FLDO) | ○ |
| C-07 | 「Customer does not exist」メッセージを表示 | E-01 (Line 289: Move 'Customer does not exist' To ERP1FLDO) | ○ |
| C-08 | 「No data was returned.」メッセージを表示 | E-01 (Line 305), E-02 (Line 268) | ○ |
| C-09 | 「Please enter a valid option」メッセージを表示 | E-01 (Line 238-239), E-02 (Line 211-212) | ○ |
| C-10 | CA-RETURN-CODE > 0でエラー判定 | E-01 (Line 76, 119, 143, 177, 220), E-02 (Line 94, 132, 155, 195) | ○ |
| C-11 | CA-RETURN-CODE = 70で顧客不存在判定 | E-01 (Line 287-290: When 70, Move 'Customer does not exist') | ○ |
| C-12 | エラー時Syncpoint Rollbackを実行 | E-01 (Line 120, 144), E-02 (Line 133) | ○ |
| C-13 | EXEC CICS SEND MAPで画面送信 | E-01 (Line 47, 91, 129, 159, 192, 229, 242, 309), E-02 (Line 64, 107, 142, 168, 203, 215, 272) | ○ |
| C-14 | マップセットはSSMAP | E-01 (Line 48, 93, 131, 161, 194, 231, 244, 310), E-02 (Line 65, 109, 144, 170, 205, 217, 273) | ○ |
| C-15 | PF3でトランザクション終了 | E-01 (Line 56: PF3(ENDIT), Line 263-271: ENDIT処理) | ○ |
| C-16 | LGTESTP2-P4も同様の実装 | **根拠なし**（ソースコード未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- LGTESTP2、LGTESTP3、LGTESTP4のソースコード確認：通知一覧の備考に記載があるが、実装の詳細確認が必要
  - 候補：base/src/lgtestp2.cbl / base/src/lgtestp3.cbl / base/src/lgtestp4.cbl

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - LGTESTP1とLGTESTc1の主要なメッセージ表示ロジックはソースコードで確認済み
- 1: 中リスク - 他のテストプログラム（P2-P4）の実装が同様かは未確認

## 6) レビュアーチェックリスト（最小）
- [ ] SSMAPマップセットの定義が正しいか確認
- [ ] メッセージフィールド（ERP1FLDO、ERRFLDO）のサイズが十分か確認
- [ ] LGTESTP2-P4も同様のメッセージ表示パターンか確認
