---
generated_at: 2026-01-06 10:33:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-ABEND通知(LGCA)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgipdb01.cbl` - LGIPDB01プログラムソースコード
- E-02: `base/src/lgapol01.cbl` - LGAPOL01プログラムソースコード
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ABENDコード'LGCA'を発行する | E-01 (Line 254: ABEND ABCODE('LGCA')), E-02 (Line 101: ABEND ABCODE('LGCA')) | ○ |
| C-02 | NODUMPオプションを指定する | E-01 (Line 254: NODUMP), E-02 (Line 101: NODUMP) | ○ |
| C-03 | EIBCALEN = 0の場合にABEND発行 | E-01 (Line 251-255: IF EIBCALEN IS EQUAL TO ZERO ... ABEND), E-02 (Line 98-102) | ○ |
| C-04 | ABEND前にエラーメッセージを設定 | E-01 (Line 252: MOVE ' NO COMMAREA RECEIVED' TO EM-VARIABLE) | ○ |
| C-05 | ABEND前にWRITE-ERROR-MESSAGEを実行 | E-01 (Line 253: PERFORM WRITE-ERROR-MESSAGE), E-02 (Line 100) | ○ |
| C-06 | エラーメッセージにプログラム名を含む | E-01 (Line 52: VALUE ' LGIPDB01'), E-02 (Line 45: VALUE ' LGAPOL01') | ○ |
| C-07 | エラーメッセージに日時を含む | E-01 (Line 1001-1008: ASKTIME/FORMATTIME, DATE1, TIME1), E-02 (Line 140-147) | ○ |
| C-08 | LGSTSQを呼び出してログ出力 | E-01 (Line 1010-1013: LINK PROGRAM('LGSTSQ')), E-02 (Line 149-152) | ○ |
| C-09 | 全業務プログラムで使用される | E-03 (備考欄: 全業務プログラムで使用) | ○ |
| C-10 | COMMAREAの長さをEIBCALENでチェック | E-01 (Line 251: IF EIBCALEN IS EQUAL TO ZERO), E-02 (Line 98) | ○ |
| C-11 | エラーメッセージにEM-VARIABLE領域を使用 | E-01 (Line 53: EM-VARIABLE, Line 252: MOVE TO EM-VARIABLE) | ○ |
| C-12 | 日付形式はMMDDYYYY | E-01 (Line 1004: MMDDYYYY(DATE1)), E-02 (Line 143) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ABEND発行ロジックはソースコードで完全に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ABENDコード'LGCA'が運用監視システムで正しく検知されるか確認
- [ ] CICS ABEND処理の出口プログラム設定が適切か確認
