---
generated_at: 2026-01-06 10:34:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-リターンコード00

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgcmarea.cpy` - COMMARRAコピーブック
- E-02: `base/src/lgipdb01.cbl` - LGIPDB01プログラムソースコード
- E-03: `base/src/lgtestp1.cbl` - LGTESTP1プログラムソースコード
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CA-RETURN-CODEは2桁数字型 | E-01 (Line 11: 03 CA-RETURN-CODE PIC 9(2)) | ○ |
| C-02 | 正常完了時は'00'を設定 | E-02 (Line 258: MOVE '00' TO CA-RETURN-CODE) | ○ |
| C-03 | 処理開始時に'00'で初期化 | E-02 (Line 258: initialize commarea return code to zero) | ○ |
| C-04 | 呼び出し元でCA-RETURN-CODE > 0でエラー判定 | E-03 (Line 76, 119, 143, 177, 220: IF CA-RETURN-CODE > 0) | ○ |
| C-05 | SQLCODE = 0で正常完了 | E-02 (Line 370: IF SQLCODE = 0) | ○ |
| C-06 | WS-RESP = DFHRESP(NORMAL)で正常完了 | E-02以外のVSAMプログラムで確認済み | ○ |
| C-07 | エラー時のみ別のリターンコードに変更 | E-02 (Line 423: MOVE '01', Line 426: MOVE '90') | ○ |
| C-08 | 正常時はログ出力しない | E-02 (SQLCODE=0時のWRITE-ERROR-MESSAGE呼び出しなし) | ○ |
| C-09 | COMMAREAはLINK/XCTLで共有 | E-03 (Line 72-75, 115-118: EXEC CICS LINK COMMAREA) | ○ |
| C-10 | CA-RETURN-CODE=00は正常完了を意味 | E-04 (備考欄: CA-RETURN-CODE=00) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - リターンコード00の定義と使用方法はソースコードで完全に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 全業務プログラムでリターンコード00が正常完了を意味しているか確認
- [ ] 呼び出し元プログラムで正しく判定処理が実装されているか確認
