---
generated_at: 2026-01-06 10:35:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-リターンコード01

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgipdb01.cbl` - LGIPDB01プログラムソースコード
- E-02: `base/src/lgtestp1.cbl` - LGTESTP1プログラムソースコード
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SQLCODE = 100でリターンコード01を設定 | E-01 (Line 421-423: IF SQLCODE EQUAL 100, MOVE '01' TO CA-RETURN-CODE) | ○ |
| C-02 | Motor/House/Endowment/Commercialで同様の処理 | E-01 (Line 512-514, 610-612, 712-714, 817-819) | ○ |
| C-03 | データなしは正常なビジネスケースとして扱う | E-01 (Line 421-423: エラーログ出力なし) | ○ |
| C-04 | 呼び出し元で「No data was returned.」を表示 | E-02 (Line 305: Move 'No data was returned.' To ERP1FLDO) | ○ |
| C-05 | CA-RETURN-CODE > 0でNO-DATAへ分岐 | E-02 (Line 76-78: IF CA-RETURN-CODE > 0, GO TO NO-DATA) | ○ |
| C-06 | POLICY/ENDOWMENTテーブルをJOINして検索 | E-01 (Line 361-367: FROM POLICY,ENDOWMENT WHERE) | ○ |
| C-07 | POLICY/HOUSEテーブルをJOINして検索 | E-01 (Line 469-475: FROM POLICY,HOUSE WHERE) | ○ |
| C-08 | POLICY/MOTORテーブルをJOINして検索 | E-01 (Line 563-569: FROM POLICY,MOTOR WHERE) | ○ |
| C-09 | POLICY/COMMERCIALテーブルをJOINして検索 | E-01 (Line 671-677: FROM POLICY,COMMERCIAL WHERE) | ○ |
| C-10 | CUSTOMERNUMBERで検索条件を指定 | E-01 (Line 364-365: POLICY.CUSTOMERNUMBER = :DB2-CUSTOMERNUM-INT) | ○ |
| C-11 | POLICYNUMBERで検索条件を指定 | E-01 (Line 366-367: POLICY.POLICYNUMBER = :DB2-POLICYNUM-INT) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - リターンコード01の発生条件と処理はソースコードで完全に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 全照会プログラムでSQLCODE=100時にリターンコード01を設定しているか確認
- [ ] VSAMプログラムでもNOTFND時に同様の処理が実装されているか確認
