---
generated_at: 2026-01-06 10:36:00
metrics:
  claims_total: 8
  claims_with_evidence: 4
  claims_without_evidence: 4
confidence_derived: 0.50
---

# 根拠レポート：7-リターンコード02

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.50**
  - 根拠あり：4 / 8、根拠なし：4
- 優先レビュー（高）
  1. **リターンコード02の実装箇所**：ソースコードでの確認が必要
  2. **重複検出ロジック**：具体的な実装の確認が必要
  3. **SQLCODE = -803のハンドリング**：DB2プログラムでの確認が必要
  4. **DFHRESP(DUPREC)のハンドリング**：VSAMプログラムでの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧
- E-02: `base/src/lgcmarea.cpy` - COMMARRAコピーブック

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CA-RETURN-CODEは2桁数字型 | E-02 (Line 11: 03 CA-RETURN-CODE PIC 9(2)) | ○ |
| C-02 | リターンコード02は重複データ検出を意味 | E-01 (No.7: 重複データ検出) | ○ |
| C-03 | 顧客情報更新時に検出 | E-01 (備考欄: 顧客情報更新時に検出) | ○ |
| C-04 | リターンコード02の値は'02' | E-01 (No.7) | ○ |
| C-05 | SQLCODE = -803で設定 | **根拠なし**（ソースコード未確認） | △ |
| C-06 | DFHRESP(DUPREC)で設定 | **根拠なし**（ソースコード未確認） | △ |
| C-07 | 重複時にエラーメッセージ表示 | **根拠なし**（呼び出し元の実装未確認） | △ |
| C-08 | ログ出力は行わない | **根拠なし**（実装未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- リターンコード02の具体的な設定箇所：確認したソースコード内に明示的なMOVE '02' TO CA-RETURN-CODEの記述が見つからない
  - 候補：base/src/lgacdb01.cbl / base/src/lgacdb02.cbl / base/src/lgucdb01.cbl / その他の更新系プログラム
- 重複検出の実装詳細：DB2/VSAMの重複エラー処理の実装確認が必要
  - 候補：更新系プログラムのエラーハンドリング部分

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - 通知一覧に記載はあるが、ソースコードでの実装確認ができていない
- リターンコード02が実際に使用されているか、どのプログラムで設定されるかの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 顧客更新プログラム（LGUCDB01等）でリターンコード02が実装されているか確認
- [ ] 重複検出時のエラーハンドリングが適切に実装されているか確認
- [ ] 呼び出し元プログラムでリターンコード02の判定処理が実装されているか確認
