---
generated_at: 2026-01-06 10:37:00
metrics:
  claims_total: 9
  claims_with_evidence: 7
  claims_without_evidence: 2
confidence_derived: 0.78
---

# 根拠レポート：8-リターンコード70

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.78**
  - 根拠あり：7 / 9、根拠なし：2
- 優先レビュー（高）
  1. **リターンコード70の設定箇所**：LGAPDB01でのソースコード確認が必要
  2. **顧客存在確認ロジック**：具体的な実装の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgtestp1.cbl` - LGTESTP1プログラムソースコード
- E-02: `base/src/lgcmarea.cpy` - COMMARRAコピーブック
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CA-RETURN-CODEは2桁数字型 | E-02 (Line 11: 03 CA-RETURN-CODE PIC 9(2)) | ○ |
| C-02 | リターンコード70は顧客不存在を意味 | E-03 (No.8: 顧客が存在しない) | ○ |
| C-03 | ポリシー追加時に発生 | E-03 (備考欄: ポリシー追加時に親顧客が見つからない場合) | ○ |
| C-04 | 呼び出し元で「Customer does not exist」を表示 | E-01 (Line 289: Move 'Customer does not exist' To ERP1FLDO) | ○ |
| C-05 | When 70で判定 | E-01 (Line 287-288: Evaluate CA-RETURN-CODE, When 70) | ○ |
| C-06 | エラー時Syncpoint Rollbackを実行 | E-01 (Line 120: Exec CICS Syncpoint Rollback End-Exec) | ○ |
| C-07 | NO-ADDへ分岐 | E-01 (Line 121: GO TO NO-ADD) | ○ |
| C-08 | LGAPDB01で設定 | **根拠なし**（ソースコード未確認） | △ |
| C-09 | 顧客テーブルで存在確認 | **根拠なし**（実装未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- リターンコード70の設定箇所：LGAPDB01プログラムのソースコードで具体的な実装確認が必要
  - 候補：base/src/lgapdb01.cbl
- 顧客存在確認の実装詳細：ポリシー追加処理内での顧客存在確認ロジックの確認が必要
  - 候補：LGAPDB01またはLGAPOL01のソースコード

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 呼び出し元での判定処理は確認済みだが、設定元の実装確認が必要
- リターンコード70がどのプログラムで設定されるかの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] LGAPDB01でリターンコード70が実装されているか確認
- [ ] 顧客存在確認のロジックが適切に実装されているか確認
- [ ] 他のポリシー追加プログラムでも同様の処理が実装されているか確認
