---
generated_at: 2026-01-06 10:38:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-リターンコード80

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/src/lgacvs01.cbl` - LGACVS01プログラムソースコード
- E-02: `base/src/lgapvs01.cbl` - LGAPVS01プログラムソースコード
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MOVE '80' TO CA-RETURN-CODEで設定 | E-01 (Line 77), E-02 (Line 144) | ○ |
| C-02 | LGACVS01で使用 | E-01 (全体), E-03 (備考欄) | ○ |
| C-03 | LGAPVS01で使用 | E-02 (全体), E-03 (備考欄) | ○ |
| C-04 | WS-RESP Not = DFHRESP(NORMAL)で判定 | E-01 (Line 75), E-02 (Line 142) | ○ |
| C-05 | EXEC CICS WRITE FILEで書き込み | E-01 (Line 68-74), E-02 (Line 135-141) | ○ |
| C-06 | KSDSCUSTファイルに書き込み（LGACVS01） | E-01 (Line 68: Write File('KSDSCUST')) | ○ |
| C-07 | KSDSPOLYファイルに書き込み（LGAPVS01） | E-02 (Line 135: Write File('KSDSPOLY')) | ○ |
| C-08 | WRITE-ERROR-MESSAGEを実行 | E-01 (Line 78), E-02 (Line 145) | ○ |
| C-09 | LGSTSQを呼び出してログ出力 | E-01 (Line 102-105), E-02 (Line 169-172) | ○ |
| C-10 | ABEND ABCODE('LGV0') NODUMPを発行（LGACVS01） | E-01 (Line 79) | ○ |
| C-11 | エラーメッセージに「Write file KSDSCUST」を含む | E-01 (Line 38-39: Value ' Write file KSDSCUST') | ○ |
| C-12 | エラーメッセージに「Write file KSDSPOLY」を含む | E-02 (Line 68-69: Value ' Write file KSDSPOLY') | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - リターンコード80の発生条件と処理はソースコードで完全に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] KSDSCUSTおよびKSDSPOLYファイルがCICSで正しく定義されているか確認
- [ ] ABENDコード'LGV0'が運用監視システムで正しく検知されるか確認
