# 根拠レポート：運用マニュアル

## 文書情報

| 項目 | 内容 |
|------|------|
| 対象ドキュメント | 運用マニュアル.md |
| 作成日 | 2026-01-06 |
| 分析対象 | GenApp (General Insurance Application) |

---

## 1. 全体概要

### 1.1 ドキュメントの目的

本運用マニュアルは、GenApp（General Insurance Application）のエンドユーザー（保険業務オペレーター）向けに、日常業務における操作手順を提供することを目的として作成されました。

### 1.2 分析対象ソース

以下のソースを分析し、運用マニュアルを作成しました：

| ソース種別 | ファイル/パス | 信頼度 |
|-----------|-------------|--------|
| システムドキュメント | README.md | 高 |
| アーキテクチャ文書 | base/Architecture.md | 高 |
| テスト文書 | base/Testing.md | 高 |
| リファレンス文書 | base/Reference.md | 高 |
| BMS画面定義 | base/src/ssmap.bms | 高 |
| 画面設計書 | docs/code-to-docs/画面設計書/*.md | 高 |
| 機能一覧 | docs/code-to-docs/機能一覧/機能一覧.csv | 高 |
| 画面一覧 | docs/code-to-docs/画面一覧/画面一覧.csv | 高 |
| 画面遷移図 | docs/code-to-docs/画面一覧/画面遷移図.md | 高 |
| 業務要件一覧 | docs/code-to-docs/業務要件一覧/業務要件一覧.csv | 高 |

---

## 2. 章別根拠一覧

### 2.1 第1章 システム概要

| 記載内容 | 根拠ソース | 信頼度 |
|---------|-----------|--------|
| システム名称（GenApp） | README.md 1-6行目 | 高 |
| システム概要（CICS TSアプリケーション） | README.md 8-16行目, Architecture.md 1-5行目 | 高 |
| 主要業務（顧客管理、保険ポリシー管理） | 機能一覧.csv 全行 | 高 |
| 業務フロー概要 | Architecture.md 14-24行目、業務要件一覧.csv | 高 |
| 画面遷移図 | 画面遷移図.md 全行 | 高 |

### 2.2 第2章 ログイン・ログアウト手順

| 記載内容 | 根拠ソース | 信頼度 |
|---------|-----------|--------|
| トランザクションID一覧 | Reference.md 42-58行目 | 高 |
| 各トランザクションの機能 | Reference.md 42-58行目、画面一覧.csv | 高 |
| PF3キーでのトランザクション終了 | 画面設計書/1-顧客メニュー画面.md 124-128行目 | 高 |
| CLEARキーでの画面クリア | 画面設計書/1-顧客メニュー画面.md 114-121行目 | 高 |

### 2.3 第3章 トップページ（メニュー画面）

| 記載内容 | 根拠ソース | 信頼度 |
|---------|-----------|--------|
| SSC1画面レイアウト | ssmap.bms 13-106行目 | 高 |
| 画面構成要素 | 画面設計書/1-顧客メニュー画面.md 61-71行目 | 高 |
| オプション選択（1,2,4） | ssmap.bms 18-25行目、画面設計書 | 高 |

### 2.4 第4章 顧客情報管理

| 記載内容 | 根拠ソース | 信頼度 |
|---------|-----------|--------|
| 顧客照会手順 | 画面設計書/1-顧客メニュー画面.md 74-85行目 | 高 |
| 顧客登録手順 | 画面設計書/1-顧客メニュー画面.md 87-98行目 | 高 |
| 顧客更新手順 | 画面設計書/1-顧客メニュー画面.md 100-112行目 | 高 |
| 入力項目定義 | ssmap.bms 29-95行目、画面設計書/1-顧客メニュー画面.md 46-59行目 | 高 |
| メッセージ仕様 | 画面設計書/1-顧客メニュー画面.md 168-178行目 | 高 |
| 郵便番号の大文字変換 | 画面設計書/1-顧客メニュー画面.md 194行目 | 高 |
| 顧客番号の自動採番 | 業務要件一覧.csv BR-025、画面設計書 | 高 |

### 2.5 第5章 保険ポリシー登録

| 記載内容 | 根拠ソース | 信頼度 |
|---------|-----------|--------|
| 自動車保険登録手順 | 画面設計書/2-自動車保険ポリシーメニュー画面.md 90-103行目 | 高 |
| 入力項目定義 | ssmap.bms 112-230行目、画面設計書 | 高 |
| 養老保険登録項目 | ssmap.bms 237-340行目、業務要件一覧.csv BR-008,BR-009 | 高 |
| 住宅保険登録項目 | ssmap.bms 346-443行目、業務要件一覧.csv BR-012,BR-013 | 高 |
| 商業用不動産保険登録項目 | ssmap.bms 449-600行目、業務要件一覧.csv BR-016,BR-017 | 高 |
| 顧客不存在エラー（RC=70） | 画面設計書/2-自動車保険ポリシーメニュー画面.md 101行目 | 高 |

### 2.6 第6章 保険ポリシー照会

| 記載内容 | 根拠ソース | 信頼度 |
|---------|-----------|--------|
| 照会手順 | 画面設計書/2-自動車保険ポリシーメニュー画面.md 79-89行目 | 高 |
| 検索条件 | 業務要件一覧.csv BR-004,BR-008,BR-012,BR-016 | 高 |

### 2.7 第7章 保険ポリシー更新・削除

| 記載内容 | 根拠ソース | 信頼度 |
|---------|-----------|--------|
| 更新手順 | 画面設計書/2-自動車保険ポリシーメニュー画面.md 115-127行目 | 高 |
| 削除手順 | 画面設計書/2-自動車保険ポリシーメニュー画面.md 104-114行目 | 高 |
| SSP4の更新機能コメントアウト | ssmap.bms 460-461行目、画面一覧.csv | 高 |
| ロールバック処理 | 業務要件一覧.csv BR-024 | 高 |

### 2.8 第8-10章 サポート機能

| 記載内容 | 根拠ソース | 信頼度 |
|---------|-----------|--------|
| エラーメッセージ一覧 | 画面設計書/1-顧客メニュー画面.md 168-178行目、画面設計書/2-自動車保険ポリシーメニュー画面.md 176-190行目 | 高 |
| LGSE初期化トランザクション | Reference.md 48行目、業務要件一覧.csv BR-019 | 高 |

### 2.9 第11-13章 運用ガイド

| 記載内容 | 根拠ソース | 信頼度 |
|---------|-----------|--------|
| 業務フロー（STEP形式） | Architecture.md 14-48行目、業務要件一覧.csv | 高 |
| エラーコード対処 | 画面設計書 例外処理セクション | 高 |
| キー操作 | 画面遷移図.md 125-131行目 | 高 |

### 2.10 付録

| 記載内容 | 根拠ソース | 信頼度 |
|---------|-----------|--------|
| トランザクション一覧 | Reference.md 42-58行目 | 高 |
| サンプルデータ | Reference.md 108-123行目 | 高 |
| キー操作リファレンス | 画面遷移図.md 125-131行目 | 高 |

---

## 3. 信頼度評価

### 3.1 評価基準

| 評価 | 説明 |
|------|------|
| 高 | ソースコード、BMS定義、公式ドキュメントから直接確認可能 |
| 中 | 複数ソースからの推論、または一部仕様が不明確 |
| 低 | 一般的な慣習に基づく推定、または検証困難 |

### 3.2 全体信頼度

| 評価区分 | 割合 |
|---------|------|
| 高信頼度 | 95% |
| 中信頼度 | 5% |
| 低信頼度 | 0% |

### 3.3 中・低信頼度の項目

| 章 | 項目 | 理由 |
|----|------|------|
| 第5章 | SSP5（保険請求）トランザクション | BMS定義は存在するが、関連プログラムが確認できない |
| 第7章 | 商業用不動産保険の更新機能 | ソースコードでコメントアウトされており、機能の実装状態が不明確 |

---

## 4. 検証事項

### 4.1 確認済み事項

- [x] 全トランザクションIDの存在確認（Reference.md）
- [x] 画面レイアウトの整合性（BMS定義と画面設計書）
- [x] 入力項目の桁数と属性（BMS定義）
- [x] オプション番号と機能の対応（画面設計書）
- [x] エラーメッセージの内容（画面設計書）
- [x] サンプルデータの存在（Reference.md）

### 4.2 未確認・推定事項

| 項目 | 状況 | 影響度 |
|------|------|--------|
| SSP5トランザクションの実装状態 | BMS定義は存在するが動作未確認 | 低 |
| 実際の画面表示 | 実行環境がないため未確認 | 低 |
| エラー発生時の実際の動作 | コード解析に基づく推定 | 低 |

---

## 5. 参照ソースコード一覧

### 5.1 BMS画面定義

| ファイル | 行数 | 対応画面 |
|---------|------|---------|
| ssmap.bms | 13-106 | SSMAPC1（顧客メニュー） |
| ssmap.bms | 112-231 | SSMAPP1（自動車保険） |
| ssmap.bms | 237-340 | SSMAPP2（養老保険） |
| ssmap.bms | 346-443 | SSMAPP3（住宅保険） |
| ssmap.bms | 449-600 | SSMAPP4（商業用不動産保険） |
| ssmap.bms | 606-687 | SSMAPP5（保険請求） |

### 5.2 参照ドキュメント

| ドキュメント | パス |
|-------------|------|
| README.md | /Users/tomokababa/Work/route06/cics-genapp-main/README.md |
| Architecture.md | /Users/tomokababa/Work/route06/cics-genapp-main/base/Architecture.md |
| Testing.md | /Users/tomokababa/Work/route06/cics-genapp-main/base/Testing.md |
| Reference.md | /Users/tomokababa/Work/route06/cics-genapp-main/base/Reference.md |
| 機能一覧.csv | /Users/tomokababa/Work/route06/cics-genapp-main/docs/code-to-docs/機能一覧/機能一覧.csv |
| 画面一覧.csv | /Users/tomokababa/Work/route06/cics-genapp-main/docs/code-to-docs/画面一覧/画面一覧.csv |
| 画面遷移図.md | /Users/tomokababa/Work/route06/cics-genapp-main/docs/code-to-docs/画面一覧/画面遷移図.md |
| 業務要件一覧.csv | /Users/tomokababa/Work/route06/cics-genapp-main/docs/code-to-docs/業務要件一覧/業務要件一覧.csv |
| 1-顧客メニュー画面.md | /Users/tomokababa/Work/route06/cics-genapp-main/docs/code-to-docs/画面設計書/1-顧客メニュー画面.md |
| 2-自動車保険ポリシーメニュー画面.md | /Users/tomokababa/Work/route06/cics-genapp-main/docs/code-to-docs/画面設計書/2-自動車保険ポリシーメニュー画面.md |

---

## 6. 改善提案

### 6.1 ドキュメント品質向上

1. **スクリーンショット追加**: 実際の3270画面のスクリーンショットを追加することで、操作イメージが明確になります
2. **動画マニュアル**: 複雑な操作手順については動画形式のマニュアルを作成することが効果的です

### 6.2 システム機能改善提案

1. **顧客検索機能**: 顧客名や電話番号からの顧客番号検索機能があると業務効率が向上します
2. **顧客削除機能**: 現在未実装の顧客削除機能の追加を検討してください

---

## 改訂履歴

| バージョン | 日付 | 変更内容 |
|-----------|------|---------|
| 1.0 | 2026-01-06 | 初版作成 |
