# GenApp 業務運用マニュアル

## 文書情報

| 項目 | 内容 |
|------|------|
| 文書名 | GenApp 業務運用マニュアル |
| システム名 | General Insurance Application（GenApp） |
| バージョン | 1.0 |
| 作成日 | 2026-01-06 |
| 対象者 | 保険業務オペレーター、システム利用者 |

---

# 【基本操作】

## 第1章 システム概要

### 1.1 本システムについて

GenApp（General Insurance Application）は、一般保険業務を管理するためのIBM CICS Transaction Server上で稼働するアプリケーションです。3270端末インターフェースを通じて、顧客情報と各種保険ポリシー（自動車保険、養老保険、住宅保険、商業用不動産保険）の管理を行います。

### 1.2 主要業務

本システムでは、以下の業務を実行できます：

| 業務カテゴリ | 主な機能 |
|-------------|---------|
| 顧客管理 | 顧客情報の照会・登録・更新 |
| 自動車保険管理 | 自動車保険ポリシーの照会・登録・更新・削除 |
| 養老保険管理 | 養老保険ポリシーの照会・登録・更新・削除 |
| 住宅保険管理 | 住宅保険ポリシーの照会・登録・更新・削除 |
| 商業用不動産保険管理 | 商業用不動産保険ポリシーの照会・登録・削除 |

### 1.3 業務フロー概要図

```
[業務フロー全体像]

【STEP1】顧客登録
    |
    v
【STEP2】顧客情報確認・照会
    |
    v
【STEP3】保険ポリシー登録
    |  ├── 自動車保険（SSP1）
    |  ├── 養老保険（SSP2）
    |  ├── 住宅保険（SSP3）
    |  └── 商業用不動産保険（SSP4）
    v
【STEP4】保険ポリシー照会・確認
    |
    v
【STEP5】保険ポリシー更新/削除
```

### 1.4 画面遷移図

```
┌─────────────────────────────────────────────────┐
│           3270端末（トランザクション入力）           │
└─────────────────┬───────────────────────────────┘
                  │
    ┌─────────────┼─────────────┬─────────────┬─────────────┐
    │             │             │             │             │
    v             v             v             v             v
┌───────┐   ┌───────┐   ┌───────┐   ┌───────┐   ┌───────┐
│ SSC1  │   │ SSP1  │   │ SSP2  │   │ SSP3  │   │ SSP4  │
│顧客   │   │自動車 │   │養老   │   │住宅   │   │商業用 │
│メニュー│   │保険   │   │保険   │   │保険   │   │不動産 │
└───────┘   └───────┘   └───────┘   └───────┘   └───────┘
```

---

## 第2章 ログイン・ログアウト手順

### 2.1 システムへのアクセス

#### 【STEP1】3270端末の起動

1. 3270端末エミュレータを起動します
2. CICSリージョンに接続します
3. CICS入力待ち状態（空白画面）が表示されます

#### 【STEP2】トランザクションの開始

画面が空白状態（CICS入力待ち）になったら、以下のトランザクションIDを入力してEnterキーを押します：

| トランザクションID | 画面名 | 機能 |
|------------------|--------|------|
| SSC1 | 顧客メニュー画面 | 顧客情報の照会・登録・更新 |
| SSP1 | 自動車保険メニュー | 自動車保険ポリシー管理 |
| SSP2 | 養老保険メニュー | 養老保険ポリシー管理 |
| SSP3 | 住宅保険メニュー | 住宅保険ポリシー管理 |
| SSP4 | 商業用不動産保険メニュー | 商業用不動産保険ポリシー管理 |
| LGSE | システム初期化 | カウンタ・キューの初期化 |

### 2.2 トランザクション終了・ログアウト

#### 【STEP1】現在の画面を終了する

- **PF3キー**を押すと、「Transaction ended」メッセージが表示され、CICS入力待ち状態に戻ります
- **CLEARキー**を押すと、画面がクリアされ、同じトランザクションを継続します

#### 【STEP2】別のトランザクションに移動

CICS入力待ち状態で別のトランザクションIDを入力してEnterキーを押します。

---

## 第3章 トップページ（メニュー画面）

### 3.1 顧客メニュー画面（SSC1）

トランザクションID「SSC1」を入力すると、以下の画面が表示されます：

```
SSC1        General Insurance Customer Menu

        1. Cust Inquiry
        2. Cust Add

        4. Cust Update

                        Cust Number  __________
                        Cust Name :First __________
                                  :Last  ____________________
                        DOB          __________ (yyyy-mm-dd)
                        House Name   ____________________
                        House Number ____
                        Postcode     ________
                        Phone: Home  ____________________
                        Phone: Mob   ____________________
                        Email  Addr  ___________________________

        Select Option  _
```

**画面の構成：**
- 左側：オプション選択（1:照会、2:登録、4:更新）
- 右側：顧客情報入力フィールド
- 下部：オプション選択欄、エラーメッセージ表示欄

---

# 【業務フローに沿った機能】

## 第4章 【STEP1】顧客情報管理（案内・通知機能）

### 業務フローでの位置

```
【STEP1】顧客登録 ← 現在の位置
    |
    v
【STEP2】顧客情報確認・照会
```

顧客情報は全ての保険契約の基盤となります。保険ポリシーを登録する前に、まず顧客情報を登録する必要があります。

### 4.1 顧客情報の照会

#### 操作手順

**【STEP1】SSC1トランザクションを起動**

3270端末で「SSC1」と入力してEnterキーを押します。

**【STEP2】顧客番号を入力**

「Cust Number」欄に照会したい顧客番号（10桁の数値）を入力します。

例：`0000000001`

**【STEP3】オプションを選択**

「Select Option」欄に「1」を入力してEnterキーを押します。

**【STEP4】結果確認**

- 正常時：顧客の詳細情報（氏名、生年月日、住所、電話番号、メールアドレス）が画面に表示されます
- 該当データなし：「No data was returned.」メッセージが表示されます

#### 入力項目

| 項目名 | 必須 | 形式 | 説明 |
|--------|------|------|------|
| Cust Number | 必須 | 数値10桁 | 照会対象の顧客番号（右寄せゼロ埋め） |
| Select Option | 必須 | 数値1桁 | 「1」を入力 |

---

### 4.2 顧客情報の登録

#### 操作手順

**【STEP1】SSC1トランザクションを起動**

3270端末で「SSC1」と入力してEnterキーを押します。

**【STEP2】顧客情報を入力**

以下の項目を入力します：

| 項目名 | 必須 | 入力例 |
|--------|------|--------|
| First Name | 推奨 | JOHN |
| Last Name | 推奨 | SMITH |
| DOB | 推奨 | 1980-05-15 |
| House Name | 任意 | OAK VILLA |
| House Number | 任意 | 123 |
| Postcode | 任意 | SW1A 1AA |
| Phone: Home | 任意 | 020-1234-5678 |
| Phone: Mob | 任意 | 080-9876-5432 |
| Email Addr | 任意 | john.smith@example.com |

**【STEP3】オプションを選択**

「Select Option」欄に「2」を入力してEnterキーを押します。

**【STEP4】結果確認**

- 正常時：「New Customer Inserted」メッセージと自動採番された顧客番号が表示されます
- エラー時：「Error Adding Customer」メッセージが表示されます

#### 注意事項

- 顧客番号は自動採番されます。入力しないでください
- 郵便番号（Postcode）は自動的に大文字に変換されます
- 登録エラー時はシステムが自動でロールバックを実行します

---

### 4.3 顧客情報の更新

#### 操作手順

**【STEP1】SSC1トランザクションを起動**

3270端末で「SSC1」と入力してEnterキーを押します。

**【STEP2】顧客番号を入力**

「Cust Number」欄に更新したい顧客番号（10桁の数値）を入力します。

**【STEP3】オプション「4」で既存情報を照会**

「Select Option」欄に「4」を入力してEnterキーを押します。
現在の顧客情報が画面に表示されます。

**【STEP4】変更内容を入力**

変更したい項目を修正します。

**【STEP5】再度オプション「4」で更新を実行**

「Select Option」欄に「4」を入力してEnterキーを押します。

**【STEP6】結果確認**

- 正常時：「Customer details updated」メッセージが表示されます
- エラー時：「Error Updating Customer」メッセージが表示されます

---

## 第5章 【STEP2-3】保険ポリシー登録（依頼・届出機能）

### 業務フローでの位置

```
【STEP1】顧客登録
    |
    v
【STEP2】顧客情報確認・照会
    |
    v
【STEP3】保険ポリシー登録 ← 現在の位置
```

顧客登録完了後、保険ポリシーを登録できます。顧客が存在しない場合はポリシー登録が失敗します。

### 5.1 自動車保険ポリシーの登録（SSP1）

#### 操作手順

**【STEP1】SSP1トランザクションを起動**

3270端末で「SSP1」と入力してEnterキーを押します。

**【STEP2】保険情報を入力**

以下の項目を入力します：

| 項目名 | 必須 | 形式 | 入力例 |
|--------|------|------|--------|
| Cust Number | 必須 | 数値10桁 | 0000000001 |
| Issue date | 必須 | yyyy-mm-dd | 2026-01-01 |
| Expiry date | 必須 | yyyy-mm-dd | 2027-01-01 |
| Car Make | 推奨 | 英数字20桁 | TOYOTA |
| Car Model | 推奨 | 英数字20桁 | CAMRY |
| Car Value | 推奨 | 数値6桁 | 250000 |
| Registration | 推奨 | 英数字7桁 | ABC1234 |
| Car Colour | 任意 | 英数字8桁 | SILVER |
| CC | 任意 | 数値8桁 | 2000 |
| Manufacture Date | 任意 | yyyy-mm-dd | 2024-06-15 |
| No. of Accidents | 任意 | 数値6桁 | 0 |
| Policy Premium | 必須 | 数値6桁 | 5000 |

**【STEP3】オプションを選択**

「Select Option」欄に「2」を入力してEnterキーを押します。

**【STEP4】結果確認**

- 正常時：「New Motor Policy Inserted」メッセージと自動採番されたポリシー番号が表示されます
- 顧客不存在時：「Customer does not exist」メッセージが表示されます
- その他エラー時：「Error Adding Motor Policy」メッセージが表示されます

---

### 5.2 養老保険ポリシーの登録（SSP2）

#### 操作手順

**【STEP1】SSP2トランザクションを起動**

3270端末で「SSP2」と入力してEnterキーを押します。

**【STEP2】保険情報を入力**

以下の項目を入力します：

| 項目名 | 必須 | 形式 | 入力例 |
|--------|------|------|--------|
| Cust Number | 必須 | 数値10桁 | 0000000001 |
| Issue date | 必須 | yyyy-mm-dd | 2026-01-01 |
| Expiry date | 必須 | yyyy-mm-dd | 2036-01-01 |
| Fund Name | 推奨 | 英数字10桁 | GROWTH01 |
| Term | 推奨 | 数値2桁 | 10 |
| Sum Assured | 必須 | 数値6桁 | 100000 |
| Life Assured | 推奨 | 英数字25桁 | JOHN SMITH |
| With Profits | 任意 | 1桁（Y/N） | Y |
| Equities | 任意 | 1桁（Y/N） | Y |
| Managed Funds | 任意 | 1桁（Y/N） | N |

**【STEP3】オプションを選択**

「Select Option」欄に「2」を入力してEnterキーを押します。

**【STEP4】結果確認**

- 正常時：「New Endowment Policy Inserted」メッセージが表示されます
- 顧客不存在時：「Customer does not exist」メッセージが表示されます

---

### 5.3 住宅保険ポリシーの登録（SSP3）

#### 操作手順

**【STEP1】SSP3トランザクションを起動**

3270端末で「SSP3」と入力してEnterキーを押します。

**【STEP2】保険情報を入力**

以下の項目を入力します：

| 項目名 | 必須 | 形式 | 入力例 |
|--------|------|------|--------|
| Cust Number | 必須 | 数値10桁 | 0000000001 |
| Issue date | 必須 | yyyy-mm-dd | 2026-01-01 |
| Expiry date | 必須 | yyyy-mm-dd | 2027-01-01 |
| Property Type | 推奨 | 英数字15桁 | DETACHED |
| Bedrooms | 任意 | 数値3桁 | 3 |
| House Value | 必須 | 数値8桁 | 500000 |
| House Name | 任意 | 英数字20桁 | ROSE COTTAGE |
| House Number | 任意 | 英数字4桁 | 15 |
| Postcode | 推奨 | 英数字8桁 | SW1A 2AA |

**【STEP3】オプションを選択**

「Select Option」欄に「2」を入力してEnterキーを押します。

**【STEP4】結果確認**

- 正常時：「New House Policy Inserted」メッセージが表示されます
- 顧客不存在時：「Customer does not exist」メッセージが表示されます

---

### 5.4 商業用不動産保険ポリシーの登録（SSP4）

#### 操作手順

**【STEP1】SSP4トランザクションを起動**

3270端末で「SSP4」と入力してEnterキーを押します。

**【STEP2】保険情報を入力**

以下の項目を入力します：

| 項目名 | 必須 | 形式 | 入力例 |
|--------|------|------|--------|
| Cust Number | 必須 | 数値10桁 | 0000000001 |
| Start date | 必須 | yyyy-mm-dd | 2026-01-01 |
| Expiry date | 必須 | yyyy-mm-dd | 2027-01-01 |
| Address | 推奨 | 英数字25桁 | 123 BUSINESS PARK |
| Postcode | 推奨 | 英数字8桁 | EC1A 1BB |
| Latitude/Longitude | 任意 | 数値各11桁 | 51.5074 / -0.1278 |
| Customer Name | 推奨 | 英数字25桁 | ABC CORPORATION |
| Property Type | 推奨 | 英数字25桁 | OFFICE BUILDING |
| Fire Peril/Prem | 任意 | 数値4桁/8桁 | 2 / 1000 |
| Crime Peril/Prem | 任意 | 数値4桁/8桁 | 3 / 1500 |
| Flood Peril/Prem | 任意 | 数値4桁/8桁 | 1 / 500 |
| Weather Peril/Prem | 任意 | 数値4桁/8桁 | 2 / 800 |
| Status | 任意 | 数値4桁 | - |
| Reject Reason | 任意 | 英数字25桁 | - |

**【STEP3】オプションを選択**

「Select Option」欄に「2」を入力してEnterキーを押します。

**【STEP4】結果確認**

- 正常時：「New Commercial Policy Inserted」メッセージが表示されます
- 顧客不存在時：「Customer does not exist」メッセージが表示されます

---

## 第6章 【STEP3-4】保険ポリシー照会（ファイル共有機能）

### 業務フローでの位置

```
【STEP3】保険ポリシー登録
    |
    v
【STEP4】保険ポリシー照会・確認 ← 現在の位置
```

登録済みの保険ポリシー情報を照会できます。

### 6.1 自動車保険ポリシーの照会（SSP1）

#### 操作手順

**【STEP1】SSP1トランザクションを起動**

3270端末で「SSP1」と入力してEnterキーを押します。

**【STEP2】検索条件を入力**

| 項目名 | 必須 | 形式 | 説明 |
|--------|------|------|------|
| Policy Number | 必須 | 数値10桁 | 照会対象のポリシー番号 |
| Cust Number | 必須 | 数値10桁 | 顧客番号 |

**【STEP3】オプションを選択**

「Select Option」欄に「1」を入力してEnterキーを押します。

**【STEP4】結果確認**

- 正常時：ポリシーの詳細情報（発行日、有効期限、車両情報、保険料等）が表示されます
- 該当データなし：「No data was returned.」メッセージが表示されます

---

### 6.2 養老保険・住宅保険・商業用不動産保険の照会

各トランザクション（SSP2、SSP3、SSP4）で同様の手順で照会できます：

1. 該当トランザクションを起動
2. Policy NumberとCust Numberを入力
3. オプション「1」を選択してEnterキーを押す
4. 結果を確認

---

## 第7章 【STEP4-5】保険ポリシー更新・削除（管理・処理完了）

### 業務フローでの位置

```
【STEP4】保険ポリシー照会・確認
    |
    v
【STEP5】保険ポリシー更新/削除 ← 現在の位置
```

### 7.1 保険ポリシーの更新

#### 操作手順（自動車保険SSP1の例）

**【STEP1】SSP1トランザクションを起動**

3270端末で「SSP1」と入力してEnterキーを押します。

**【STEP2】既存ポリシーを照会**

- Policy NumberとCust Numberを入力
- オプション「4」を選択してEnterキーを押す
- 現在のポリシー情報が表示されます

**【STEP3】変更内容を入力**

変更したい項目を修正します。

**【STEP4】更新を実行**

再度オプション「4」を選択してEnterキーを押します。

**【STEP5】結果確認**

- 正常時：「Motor Policy Updated」メッセージが表示されます
- エラー時：「Error Updating Motor Policy」メッセージが表示されます

#### 対応トランザクション

| トランザクション | 保険種別 | 更新可否 |
|----------------|---------|---------|
| SSP1 | 自動車保険 | 可能 |
| SSP2 | 養老保険 | 可能 |
| SSP3 | 住宅保険 | 可能 |
| SSP4 | 商業用不動産保険 | 不可（機能コメントアウト） |

---

### 7.2 保険ポリシーの削除

#### 操作手順（自動車保険SSP1の例）

**【STEP1】SSP1トランザクションを起動**

3270端末で「SSP1」と入力してEnterキーを押します。

**【STEP2】削除対象を指定**

- Policy Number：削除するポリシー番号を入力
- Cust Number：顧客番号を入力

**【STEP3】削除を実行**

「Select Option」欄に「3」を入力してEnterキーを押します。

**【STEP4】結果確認**

- 正常時：「Motor Policy Deleted」メッセージが表示されます
- エラー時：「Error Deleting Motor Policy」メッセージが表示されます

#### 注意事項

- 削除されたポリシーは復元できません
- 削除失敗時はシステムが自動でロールバックを実行します

---

# 【サポート機能】

## 第8章 FAQ機能

### 8.1 よくある操作質問

**Q1: 顧客番号を忘れてしまいました。どうすればよいですか？**

A: 顧客番号の検索機能は本システムにはありません。顧客名や他の情報から顧客番号を特定するには、データベース管理者にお問い合わせください。

**Q2: ポリシー番号を忘れてしまいました。どうすればよいですか？**

A: ポリシー番号の検索機能は本システムにはありません。顧客番号がわかっている場合は、データベース管理者にお問い合わせください。

**Q3: 日付の入力形式を教えてください。**

A: 日付は「yyyy-mm-dd」形式で入力してください。例：2026-01-15

**Q4: 顧客を削除できますか？**

A: 本システムには顧客削除機能は実装されていません。顧客削除が必要な場合は、データベース管理者にお問い合わせください。

---

## 第9章 お問合せ機能

### 9.1 エラー発生時の対応

エラーが発生した場合は、以下の情報を記録してシステム管理者に連絡してください：

1. 発生日時
2. 使用したトランザクションID（SSC1、SSP1等）
3. 入力した内容
4. 画面に表示されたエラーメッセージ
5. 実行しようとした操作

### 9.2 システムエラーメッセージ一覧

| メッセージ | 意味 | 対処法 |
|-----------|------|--------|
| No data was returned. | 該当データが存在しない | 入力値を確認してください |
| Customer does not exist | 顧客が登録されていない | 先に顧客登録を行ってください |
| Error Adding Customer | 顧客登録に失敗 | 入力値を確認し、再度実行してください |
| Error Adding Motor Policy | ポリシー登録に失敗 | 入力値を確認し、再度実行してください |
| Error Updating Customer | 顧客更新に失敗 | 入力値を確認し、再度実行してください |
| Error Deleting Motor Policy | ポリシー削除に失敗 | システム管理者に連絡してください |
| Please enter a valid option | 無効なオプション | 1〜4の数値を入力してください |
| Transaction ended | トランザクション終了 | 正常終了です |

---

## 第10章 マイページ機能

### 10.1 システム初期化（管理者向け）

システム管理者は、LGSEトランザクションを使用してシステムを初期化できます。

#### 操作手順

**【STEP1】LGSEトランザクションを起動**

3270端末で「LGSE」と入力してEnterキーを押します。

**【STEP2】初期化実行**

カウンタと一時ストレージキューが初期化されます。

#### 注意事項

- この操作は管理者権限が必要です
- 顧客番号カウンタと統計カウンタがリセットされます
- 業務データ（顧客情報、ポリシー情報）は削除されません

---

# 【運用ガイド】

## 第11章 日常業務の流れ

### 11.1 新規顧客と保険契約の登録（STEP形式）

#### 業務シナリオ：新規顧客の自動車保険契約

```
【STEP1】顧客情報の登録
    └─> SSC1起動 → 顧客情報入力 → オプション「2」 → 登録完了
           ↓
        顧客番号を控える（例：0000000123）

【STEP2】顧客情報の確認
    └─> SSC1起動 → 顧客番号入力 → オプション「1」 → 情報確認

【STEP3】自動車保険ポリシーの登録
    └─> SSP1起動 → 顧客番号・車両情報入力 → オプション「2」 → 登録完了
           ↓
        ポリシー番号を控える（例：0000000456）

【STEP4】登録内容の確認
    └─> SSP1起動 → ポリシー番号・顧客番号入力 → オプション「1」 → 内容確認
```

### 11.2 保険契約内容の変更

```
【STEP1】現在のポリシー情報を照会
    └─> 該当トランザクション起動 → 番号入力 → オプション「4」 → 情報表示

【STEP2】変更内容を入力
    └─> 画面上で項目を修正

【STEP3】更新を実行
    └─> オプション「4」 → 更新完了メッセージ確認
```

### 11.3 保険契約の解約

```
【STEP1】解約対象のポリシーを確認
    └─> 該当トランザクション起動 → 番号入力 → オプション「1」 → 内容確認

【STEP2】ポリシーを削除
    └─> オプション「3」 → 削除完了メッセージ確認
```

---

## 第12章 よくある質問と対処法

### 12.1 入力関連

**Q: 数値フィールドに文字を入力できますか？**

A: いいえ。数値フィールドには数字のみ入力可能です。文字を入力するとエラーになります。

**Q: 日付フィールドで「/」を使用できますか？**

A: いいえ。日付は「yyyy-mm-dd」形式（ハイフン区切り）で入力してください。

**Q: 半角・全角の違いはありますか？**

A: 本システムは半角英数字のみ対応しています。全角文字は使用できません。

### 12.2 操作関連

**Q: 登録を途中でキャンセルできますか？**

A: はい。CLEARキーを押すと画面がクリアされます。Enterキーを押す前であれば、入力内容は保存されません。

**Q: 複数の保険ポリシーを同時に登録できますか？**

A: いいえ。1回のトランザクションで登録できるポリシーは1件です。複数のポリシーを登録する場合は、それぞれ個別に登録してください。

---

## 第13章 トラブルシューティング

### 13.1 画面が応答しない場合

1. しばらく待機してください（処理中の可能性があります）
2. Enterキーを再度押してください
3. それでも応答がない場合は、CLEARキーを押してトランザクションをリセットしてください
4. 問題が続く場合は、システム管理者に連絡してください

### 13.2 エラーコードの対処

| エラーコード | 意味 | 対処法 |
|-------------|------|--------|
| RC=70 | 顧客が存在しない | 顧客番号を確認、または先に顧客登録を実行 |
| RC=98 | 通信エリア長不足 | システム管理者に連絡 |
| RC=99 | 無効なリクエストID | システム管理者に連絡 |
| LGCA | COMMエリアエラー | システム管理者に連絡 |
| MAPFAIL | 画面表示エラー | トランザクションを再起動 |

### 13.3 データ不整合の疑いがある場合

1. 同じ操作を再度実行し、結果を確認してください
2. 別の端末から同じデータを照会し、内容を比較してください
3. 不整合が確認された場合は、以下の情報を記録してシステム管理者に連絡してください：
   - 顧客番号
   - ポリシー番号
   - 操作日時
   - 期待した結果と実際の結果

### 13.4 緊急時の連絡先

システム障害や緊急の問題が発生した場合は、システム管理者に連絡してください。

---

## 付録A：トランザクション一覧

| トランザクションID | 機能 | 説明 |
|------------------|------|------|
| SSC1 | 顧客メニュー | 顧客情報の照会・登録・更新 |
| SSP1 | 自動車保険メニュー | 自動車保険ポリシーの管理 |
| SSP2 | 養老保険メニュー | 養老保険ポリシーの管理 |
| SSP3 | 住宅保険メニュー | 住宅保険ポリシーの管理 |
| SSP4 | 商業用不動産保険メニュー | 商業用不動産保険ポリシーの管理 |
| LGSE | システム初期化 | カウンタ・キューの初期化 |
| LGCF | 顧客番号取得 | VSAMからランダム顧客番号取得（自動化用） |
| LGPF | ポリシー情報取得 | VSAMからポリシー情報取得（自動化用） |
| LGST | 統計更新 | トランザクション統計の更新 |
| SSST | 統計データ収集 | 統計データの一時ストレージへの収集 |

---

## 付録B：サンプルデータ

システムには以下のサンプルデータが登録されています：

### B.1 サンプルポリシー一覧

| 保険種別 | ポリシー番号 | 顧客番号 |
|---------|-------------|---------|
| 自動車保険 | 1 | 2 |
| 自動車保険 | 2 | 10 |
| 自動車保険 | 3 | 5 |
| 養老保険 | 4 | 8 |
| 養老保険 | 5 | 3 |
| 住宅保険 | 6 | 4 |
| 住宅保険 | 7 | 6 |
| 住宅保険 | 8 | 9 |
| 商業用不動産保険 | 9 | 5 |
| 商業用不動産保険 | 10 | 1 |

### B.2 テスト用操作例

顧客番号1〜10にはサンプル顧客データが登録されています。
システムの動作確認には、これらの顧客番号を使用してください。

例：
- SSC1を起動し、顧客番号「1」を入力、オプション「1」で照会
- SSP1を起動し、ポリシー番号「1」、顧客番号「2」を入力、オプション「1」で照会

---

## 付録C：キー操作リファレンス

| キー | 機能 |
|------|------|
| ENTER | オプション実行、入力確定 |
| CLEAR | 画面クリア、トランザクション継続 |
| PF3 | トランザクション終了 |
| TAB | 次のフィールドへ移動 |
| BACKTAB | 前のフィールドへ移動 |

---

## 改訂履歴

| バージョン | 日付 | 変更内容 |
|-----------|------|---------|
| 1.0 | 2026-01-06 | 初版作成 |
