---
generated_at: 2026-01-06 19:15:00
metrics:
  claims_total: 48
  claims_with_evidence: 42
  claims_without_evidence: 6
confidence_derived: 0.88
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された非機能要件テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：42 / 48、根拠なし：6
- 優先レビュー（高）
  1. **NFT-006 トランザクション処理能力テスト**：具体的な数値目標が未定義
  2. **NFT-046 長時間連続運転テスト**：具体的なテスト期間の根拠なし
  3. **NFT-048 大量データ処理テスト**：100万件という数値の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/Architecture.md` - アプリケーションアーキテクチャ説明
- E-02: `base/Reference.md` - トランザクション・プログラム・リソース定義一覧
- E-03: `base/Testing.md` - テスト手順ドキュメント
- E-04: `base/cntl/cdef121.jcl` - CICS単一リージョン定義（DB2CONN、FILE、Transaction定義）
- E-05: `base/cntl/db2cre.jcl` - Db2オブジェクト作成JCL（テーブル・インデックス定義）
- E-06: `base/src/lgcmarea.cpy` - COMMAPREAデータ構造定義
- E-07: `base/src/lgstsq.cbl` - TSQメッセージ出力プログラム
- E-08: `base/src/lgsetup.cbl` - 初期化プログラム
- E-09: `base/src/lgastat1.cbl` - トランザクションカウンター更新プログラム
- E-10: `base/event-bindings/Transaction_Counters.evbind` - イベントバインディング定義
- E-11: `docs/code-to-docs/非機能要件定義書/非機能要件定義書.md` - 非機能要件定義書
- E-12: `docs/code-to-docs/セキュリティ設計書/セキュリティ設計書.md` - セキュリティ設計書
- E-13: `docs/code-to-docs/インフラ設計書/インフラ設計書.md` - インフラ設計書
- E-14: `docs/code-to-docs/テスト方針書/テスト方針書.md` - テスト方針書
- E-15: `README.md` - プロジェクトREADME（システム要件）

## 3) Claims と根拠の対応（レビューの主戦場）

### 性能テスト（NFT-001〜NFT-009）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001: オンライン応答時間3秒以内 | E-11 | ○ |
| C-02 | NFT-002: Db2アクセス1秒以内 | E-11 | ○ |
| C-03 | NFT-003: VSAMアクセス0.5秒以内 | E-11 | ○ |
| C-04 | NFT-004: 同時250ユーザー | E-04 (ThreadLimit:250) | ○ |
| C-05 | NFT-005: TCB上限400 | E-04 (TCBlimit:400) | ○ |
| C-06 | NFT-006: TPS目標値 | **根拠なし** | △ |
| C-07 | NFT-007: CUSTOMERテーブル容量 | E-05 (PRIQTY 10000) | ○ |
| C-08 | NFT-008: POLICYテーブル容量 | E-05 (PRIQTY 10000) | ○ |
| C-09 | NFT-009: VSAMファイル容量 | E-04 (FILE定義) | ○ |

### 可用性テスト（NFT-010〜NFT-016）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | NFT-010: Two-Phase Commit | E-01, E-11 | ○ |
| C-11 | NFT-011: ロールバック | E-04 (Drollback:Yes) | ○ |
| C-12 | NFT-012: Db2接続断回復5分以内 | **根拠なし** | △ |
| C-13 | NFT-013: CICS再起動復旧 | E-04 (GRPLIST) | ○ |
| C-14 | NFT-014: エラーキュー動作 | E-07 (lgstsq.cbl) | ○ |
| C-15 | NFT-015: Named Counter | E-01, E-08 | ○ |
| C-16 | NFT-016: 共有TSQ | E-01, E-11 | ○ |

### セキュリティテスト（NFT-017〜NFT-025）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | NFT-017: Db2ユーザー認証 | E-04 (AuthType:Userid) | ○ |
| C-18 | NFT-018: パスワードハッシュ | E-05, E-12 | ○ |
| C-19 | NFT-019: パスワード状態管理 | E-06 (lgcmarea.cpy) | ○ |
| C-20 | NFT-020: TaskDataKey | E-04 | ○ |
| C-21 | NFT-021: Execkey | E-04 | ○ |
| C-22 | NFT-022: CASCADE DELETE | E-05 | ○ |
| C-23 | NFT-023: COMMAREA長検証 | E-12 (検証ロジック) | ○ |
| C-24 | NFT-024: リクエストID検証 | E-12 (検証ロジック) | ○ |
| C-25 | NFT-025: SQLインジェクション対策 | E-12 (ホスト変数) | ○ |

### 互換性テスト（NFT-026〜NFT-033）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | NFT-026: CICS TS V4.1 | E-15 | ○ |
| C-27 | NFT-027: Db2互換性 | E-15 | ○ |
| C-28 | NFT-028: EBCDIC CCSID | E-05 | ○ |
| C-29 | NFT-029: 3270端末 | E-02 (SSMAP) | ○ |
| C-30 | NFT-030: COMMAREA 32500バイト | E-06 | ○ |
| C-31 | NFT-031: SOAP 1.1 | E-04, E-11 | ○ |
| C-32 | NFT-032: 数値データ形式 | E-05, E-06 | ○ |
| C-33 | NFT-033: 日付データ形式 | E-05, E-06 | ○ |

### 保守性テスト（NFT-034〜NFT-040）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | NFT-034: エラーログTSQ | E-07 | ○ |
| C-35 | NFT-035: システムログTD | E-07 | ○ |
| C-36 | NFT-036: トランザクションカウンター | E-09 | ○ |
| C-37 | NFT-037: イベントバインディング | E-10 | ○ |
| C-38 | NFT-038: LGSE初期化 | E-02, E-08 | ○ |
| C-39 | NFT-039: アイキャッチャー | E-11 | ○ |
| C-40 | NFT-040: ABEND処理 | E-11, E-12 | ○ |

### 拡張性テスト（NFT-041〜NFT-045）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | NFT-041: CICSPlex SM | E-02, E-11 | ○ |
| C-42 | NFT-042: ワークロード管理 | E-02, E-14 | ○ |
| C-43 | NFT-043: Parallel Sysplex | E-01, E-11 | ○ |
| C-44 | NFT-044: 3層アーキテクチャ | E-01 | ○ |
| C-45 | NFT-045: Webサービス拡張 | E-02, E-04 | ○ |

### 負荷テスト（NFT-046〜NFT-048）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | NFT-046: 24時間連続運転 | **根拠なし** | △ |
| C-47 | NFT-047: ピーク負荷250ユーザー | E-04 | ○ |
| C-48 | NFT-048: 100万件データ処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **NFT-006 トランザクション処理能力**: 具体的なTPS目標値がコードベースに定義されていない
  - 候補：運用要件定義書 / SLA文書 / パフォーマンス基準書
- **NFT-012 Db2接続断回復時間**: 5分という数値の明確な根拠がない
  - 候補：運用手順書 / インシデント対応マニュアル / SLA文書
- **NFT-046 長時間連続運転**: 24時間という期間の根拠がない
  - 候補：運用要件定義書 / テスト計画書
- **NFT-048 大量データ処理**: 100万件という数値の根拠がない
  - 候補：キャパシティプランニング文書 / データ増加予測資料

## 5) リスクフラグ（レビュー観点）
- **0 - 低リスク**: NFT-039（アイキャッチャー確認）
- **1 - 中リスク**: NFT-006, NFT-012, NFT-046, NFT-048（具体的数値根拠なし）
- **1 - 中リスク**: NFT-015, NFT-016, NFT-041-043（オプション機能、環境依存）
- **2 - 高リスク**: なし

## 6) レビュアーチェックリスト（最小）
- [ ] NFT-006のTPS目標値について、運用要件と照合して妥当性を確認
- [ ] NFT-012のDb2接続断回復時間について、実際の運用基準と照合
- [ ] NFT-046の24時間連続運転について、テスト計画の妥当性を確認
- [ ] NFT-048の100万件データについて、実際のデータ増加予測と照合
- [ ] Coupling Facility関連テスト（NFT-015, NFT-016）の環境可用性を確認
- [ ] CICSPlex SM関連テスト（NFT-041-043）の環境可用性を確認
- [ ] セキュリティテスト（NFT-017-025）について、セキュリティポリシーとの整合性を確認
- [ ] 全テストケースの優先度が業務優先度と整合しているか確認
