# 確信度レポート: 非機能要件定義書

## レポート概要

| 項目 | 内容 |
|------|------|
| 対象文書 | 非機能要件定義書.md |
| 生成日 | 2026-01-06 |
| 分析手法 | コードベース静的解析 |
| 総合確信度 | 75% |

---

## 1. カテゴリ別確信度

### 1.1 性能要件

| 要件項目 | 確信度 | 根拠 | 備考 |
|----------|--------|------|------|
| 同時接続ユーザー数(250) | **95%** | cdef121.jcl DB2Entry ThreadLimit(250)から直接抽出 | 設定値として明確 |
| TCBリミット(400) | **95%** | cdef121.jcl DB2Conn TCBlimit(400)から直接抽出 | 設定値として明確 |
| 応答時間(3秒) | **30%** | 明示的な設定なし、CICSの一般的な目標値 | 推測値 |
| DB2テーブル容量 | **95%** | db2cre.jcl PRIQTY/SECQTYから直接抽出 | 設定値として明確 |
| 自動採番キャッシュ(20) | **95%** | db2cre.jcl IDENTITY定義から直接抽出 | 設定値として明確 |

### 1.2 可用性要件

| 要件項目 | 確信度 | 根拠 | 備考 |
|----------|--------|------|------|
| Two-Phase Commit対応 | **90%** | Architecture.md記載 + コード実装確認 | 明示的な記述あり |
| DB2ロールバック対応 | **95%** | cdef121.jcl Drollback(Yes)から直接抽出 | 設定値として明確 |
| Coupling Facility対応 | **85%** | Architecture.md記載 + JCL存在確認 | 構成オプションとして記載 |
| 稼働率(99.5%) | **20%** | 明示的な設定なし、業界標準からの推測 | 推測値 |

### 1.3 セキュリティ要件

| 要件項目 | 確信度 | 根拠 | 備考 |
|----------|--------|------|------|
| AuthType(Userid)認証 | **95%** | cdef121.jcl DB2Conn定義から直接抽出 | 設定値として明確 |
| パスワードハッシュ化 | **85%** | CUSTOMER_SECURE表構造 + lgacdb01.cbl実装 | 32文字ハッシュ値確認 |
| PUBLIC権限設定 | **95%** | db2cre.jcl GRANTステートメントから直接抽出 | 設定値として明確 |
| 参照整合性(CASCADE) | **95%** | db2cre.jcl FOREIGN KEY定義から直接抽出 | 設定値として明確 |
| 通信暗号化未実装 | **80%** | cdef124.jcl Protocol(HTTP)確認、HTTPS設定なし | 明示的設定なしから判断 |

### 1.4 保守性要件

| 要件項目 | 確信度 | 根拠 | 備考 |
|----------|--------|------|------|
| エラーログ(GENAERRS TSQ) | **95%** | lgstsq.cbl実装から直接抽出 | コード実装確認 |
| システムログ(CSMT TDQ) | **95%** | lgstsq.cbl WRITEQ TD QUEUE定義から直接抽出 | コード実装確認 |
| ERROR-MSG構造 | **95%** | 各COBOLプログラムの共通構造から抽出 | 複数ファイルで確認 |
| Named Counter使用 | **90%** | lgsetup.cbl + lgastat1.cbl実装確認 | コード実装確認 |
| イベント監視 | **90%** | Transaction_Counters.evbind存在確認 | 定義ファイル確認 |

### 1.5 拡張性要件

| 要件項目 | 確信度 | 根拠 | 備考 |
|----------|--------|------|------|
| CICSPlex SM対応 | **85%** | cdef122.jcl + cpsmde2.jcl存在確認 | JCL存在のみ、詳細未検証 |
| 3層アーキテクチャ | **90%** | Architecture.md記載 + プログラム構造分析 | 設計意図として明確 |
| Webサービス対応 | **85%** | cdef124.jcl Pipeline/TCPIPService定義確認 | 設定ファイル確認 |
| 共有TSQ設定値 | **95%** | samptsq.jcl MAXQUEUES/BUFFERS定義から直接抽出 | 設定値として明確 |

### 1.6 互換性要件

| 要件項目 | 確信度 | 根拠 | 備考 |
|----------|--------|------|------|
| CICS TS V4.1以降 | **95%** | README.md明示記載 | ドキュメント記載 |
| EBCDIC CCSID | **95%** | db2cre.jcl全テーブル定義から直接抽出 | 設定値として明確 |
| COMMAREA長(32500) | **95%** | lgcmarea.cpy + 各プログラムLENGTH指定から直接抽出 | コード実装確認 |
| TCPポート(4321) | **95%** | cdef124.jcl Portnumber定義から直接抽出 | 設定値として明確 |

---

## 2. 情報源の信頼性評価

### 2.1 一次情報源（高信頼性: 90%以上）

| 情報源 | 抽出情報 | 信頼性 |
|--------|----------|--------|
| db2cre.jcl | DB2テーブル定義、容量、CCSID、権限設定 | 95% |
| cdef121.jcl | CICS定義、DB2接続設定、ファイル定義 | 95% |
| cdef124.jcl | Webサービス、TCP/IP設定 | 95% |
| samptsq.jcl/sampncs.jcl | 共有TSQ/NCS設定 | 95% |
| lgcmarea.cpy | COMMAREA構造、データ形式 | 95% |
| lgstsq.cbl | ログ出力実装 | 95% |
| lgsetup.cbl | 初期化処理、カウンター定義 | 95% |

### 2.2 二次情報源（中信頼性: 70-89%）

| 情報源 | 抽出情報 | 信頼性 |
|--------|----------|--------|
| Architecture.md | アーキテクチャ概要、設計意図 | 85% |
| README.md | 前提条件、概要説明 | 85% |
| Installation.md | インストール要件、カスタマイズ項目 | 80% |
| Building.md | ビルド手順、運用要件 | 80% |
| Transaction_Counters.evbind | イベント監視定義 | 85% |

### 2.3 推測情報（低信頼性: 70%未満）

| 情報項目 | 推測根拠 | 信頼性 |
|----------|----------|--------|
| 応答時間目標 | CICSの一般的な性能目標から推測 | 30% |
| 稼働率目標 | 業務システムの一般要件から推測 | 20% |
| 本番環境設定推奨 | コードがテスト/開発向けであることからの推測 | 50% |

---

## 3. 分析の限界と注意事項

### 3.1 分析できなかった項目

| 項目 | 理由 |
|------|------|
| 実際の性能測定値 | 実行環境がないため測定不可 |
| 本番環境固有の設定 | サンプルコードのため本番設定は含まれない |
| 実際の稼働率実績 | 運用実績データなし |
| ネットワーク要件 | 明示的な定義なし |
| ハードウェア要件 | z/OS環境依存のため明示なし |

### 3.2 解釈上の注意点

| 注意点 | 詳細 |
|--------|------|
| 開発/テスト向け設定 | PUBLIC権限等は本番環境では適切に変更が必要 |
| オプション機能 | Coupling Facility、CICSPlex SMは構成オプション |
| バージョン依存 | CICS TS V4.1以降での動作確認のみ |
| カスタマイズ前提 | Installation.mdに従ったカスタマイズが必須 |

---

## 4. 推奨事項

### 4.1 本番環境適用時の検討事項

| 優先度 | 項目 | 推奨アクション |
|--------|------|---------------|
| 高 | 権限設定 | PUBLICからの適切な権限分離を実施 |
| 高 | 通信暗号化 | HTTPSプロトコルへの移行を検討 |
| 高 | パスワード管理 | より強力なハッシュアルゴリズムへの更新を検討 |
| 中 | 性能要件 | 実環境での性能テストにより具体的な数値を確定 |
| 中 | 監視設定 | 外部監視システムとの連携を構築 |
| 低 | ドキュメント | 本番環境固有の非機能要件を追記 |

### 4.2 追加調査が必要な項目

| 項目 | 調査方法 |
|------|----------|
| 応答時間要件 | 負荷テストによる実測 |
| 可用性要件 | 業務要件ヒアリング |
| バックアップ要件 | 運用ポリシー確認 |
| 災害対策要件 | 事業継続計画確認 |

---

## 5. 総合評価

### 5.1 確信度サマリー

| カテゴリ | 平均確信度 | 評価 |
|----------|-----------|------|
| 性能要件 | 82% | 高（設定値ベース） |
| 可用性要件 | 73% | 中（一部推測含む） |
| セキュリティ要件 | 90% | 高（実装確認済み） |
| 保守性要件 | 93% | 高（コード実装確認） |
| 拡張性要件 | 89% | 高（設定確認済み） |
| 互換性要件 | 95% | 高（明示記載あり） |

### 5.2 総合確信度: 75%

**評価理由:**
- 設定ファイル（JCL）から直接抽出した情報は高い信頼性（95%）
- ドキュメント（.md）から抽出した情報は中程度の信頼性（80-85%）
- 性能目標等の推測情報が含まれるため総合評価を75%とした
- 本サンプルアプリケーションはテスト/開発目的であり、本番環境適用時は追加検討が必要

---

## 付録: 分析対象ファイル一覧

| ファイルパス | 分析内容 | 抽出情報 |
|--------------|----------|----------|
| README.md | 概要 | システム前提条件 |
| base/Architecture.md | アーキテクチャ | 設計概念、データフロー |
| base/Reference.md | リファレンス | リソース一覧 |
| base/Installation.md | インストール | カスタマイズ項目 |
| base/Building.md | ビルド | 運用手順 |
| base/Testing.md | テスト | 検証手順 |
| base/cntl/db2cre.jcl | DB2定義 | テーブル構造、容量、権限 |
| base/cntl/cdef121.jcl | CICS定義 | DB2接続、ファイル、プログラム |
| base/cntl/cdef124.jcl | Webサービス | Pipeline、TCP/IP |
| base/cntl/samptsq.jcl | 共有TSQ | キュー設定 |
| base/cntl/sampncs.jcl | NCS | カウンター設定 |
| base/src/lgcmarea.cpy | COMMAREA | データ構造 |
| base/src/lgacdb01.cbl | DB処理 | エラー処理、認証 |
| base/src/lgstsq.cbl | ログ | 出力先、形式 |
| base/src/lgsetup.cbl | 初期化 | カウンター定義 |
| base/event-bindings/Transaction_Counters.evbind | イベント | 監視定義 |

---

*本レポートはコードベースの静的解析に基づいて作成されました。実環境での検証が推奨されます。*
