# 非機能要件定義書

## 文書情報

| 項目 | 内容 |
|------|------|
| システム名 | General Insurance Application (GenApp) |
| 文書名 | 非機能要件定義書 |
| バージョン | 1.0 |
| 作成日 | 2026-01-06 |
| 作成元 | コードベース自動解析 |

---

## 1. 概要

本文書は、IBM CICS Transaction Server上で動作する一般保険アプリケーション(GenApp)の非機能要件を定義するものである。本システムは、保険会社の顧客情報および保険契約（自動車、養老、住宅、商業不動産）を管理するCOBOLベースの3270端末アプリケーションである。

---

## 2. 性能要件

### 2.1 応答時間要件

| 項目 | 要件 | 根拠 |
|------|------|------|
| オンライントランザクション応答時間 | 3秒以内（目標値） | CICSトランザクション処理の標準的な要件 |
| DB2データベースアクセス | 1秒以内 | SQLクエリの単純な構造に基づく |
| VSAMファイルアクセス | 0.5秒以内 | KSDSファイルの直接アクセス |

### 2.2 スループット要件

| 項目 | 要件 | 根拠 |
|------|------|------|
| 同時接続ユーザー数 | 最大250ユーザー | DB2接続定義のThreadLimit(250)に基づく |
| TCBリミット | 最大400 | CICS DB2接続定義のTCBlimit(400) |
| トランザクション処理能力 | リージョン構成に依存 | CICSリージョンのキャパシティに依存 |

### 2.3 データ容量要件

| テーブル/ファイル | 初期容量 | 拡張容量 | 根拠 |
|------------------|----------|----------|------|
| CUSTOMER表 | PRIQTY 10000 | SECQTY 5000 | db2cre.jcl定義 |
| POLICY表 | PRIQTY 10000 | SECQTY 5000 | db2cre.jcl定義 |
| ENDOWMENT表 | PRIQTY 30000 | SECQTY 12000 | db2cre.jcl定義（VARCHAR使用） |
| HOUSE表 | PRIQTY 10000 | SECQTY 5000 | db2cre.jcl定義 |
| MOTOR表 | PRIQTY 10000 | SECQTY 5000 | db2cre.jcl定義 |
| COMMERCIAL表 | PRIQTY 10000 | SECQTY 5000 | db2cre.jcl定義 |
| CLAIM表 | PRIQTY 10000 | SECQTY 5000 | db2cre.jcl定義 |
| VSAMファイル(KSDSCUST) | レコードサイズ82バイト | - | cdef121.jcl定義 |
| VSAMファイル(KSDSPOLY) | レコードサイズ64バイト | - | cdef121.jcl定義 |

### 2.4 カウンターキャッシュ

| 項目 | 設定値 | 根拠 |
|------|--------|------|
| 顧客番号自動採番キャッシュ | 20 | db2cre.jcl IDENTITY定義 |
| ポリシー番号自動採番キャッシュ | 20 | db2cre.jcl IDENTITY定義 |
| クレーム番号自動採番キャッシュ | 20 | db2cre.jcl IDENTITY定義 |

---

## 3. 可用性要件

### 3.1 システム稼働率

| 項目 | 要件 | 根拠 |
|------|------|------|
| 計画稼働時間 | CICSリージョン稼働中 | オンラインシステムとして運用 |
| 目標稼働率 | 99.5%以上（推奨） | 業務システムとしての標準要件 |

### 3.2 冗長性構成

| コンポーネント | 冗長構成 | 根拠 |
|---------------|----------|------|
| Named Counter Server | Coupling Facility経由で共有可能 | Architecture.md記載 |
| Temporary Storage Queue | Coupling Facility経由で共有可能 | DFHXQLS_GENA構造体 |
| CICSリージョン | CICSPlex SM管理によるトポロジ拡張対応 | cdef122.jcl、cpsmde2.jcl |

### 3.3 障害回復

| 項目 | 対応 | 根拠 |
|------|------|------|
| トランザクション回復 | Two-Phase Commit | Architecture.md記載（DB2とVSAMの整合性保証） |
| DB2ロールバック | Drollback(Yes) | cdef121.jcl DB2Conn定義 |
| エラーキュー | GENAERRS TSQへのエラーログ出力 | lgstsq.cbl実装 |

---

## 4. セキュリティ要件

### 4.1 認証要件

| 項目 | 実装 | 根拠 |
|------|------|------|
| DB2認証 | AuthType(Userid) | cdef121.jcl DB2Conn定義 |
| RACF認証 | SQLIDによるオブジェクト作成権限 | Installation.md記載 |
| 顧客セキュリティ | ハッシュ化パスワード（MD5相当） | CUSTOMER_SECURE表、32文字固定長 |
| パスワード状態管理 | state_indicator（N=新規、他状態あり） | lgcmarea.cpy定義 |
| パスワード変更追跡 | pass_changes カウンター | CUSTOMER_SECURE表 |

### 4.2 認可要件

| 項目 | 設定 | 根拠 |
|------|------|------|
| データベース管理権限 | DBADM TO PUBLIC | db2cre.jcl（開発/テスト向け設定） |
| テーブル権限 | ALL PRIVILEGES TO PUBLIC | db2cre.jcl（開発/テスト向け設定） |
| CICSタスクデータ | TaskDataKey(User) | cdef121.jcl Transaction定義 |
| プログラム実行キー | Execkey(User) | cdef121.jcl Program定義 |

### 4.3 データ保護

| 項目 | 対応 | 根拠 |
|------|------|------|
| 顧客パスワード | ハッシュ形式で保存 | lgacdb01.cbl、lgacdb02.cbl |
| 参照整合性 | ON DELETE CASCADE | 全関連テーブルで設定 |
| 通信暗号化 | 未実装（要検討） | コードベースに明示的な暗号化実装なし |

---

## 5. 保守性要件

### 5.1 ログ・監視要件

| 項目 | 実装 | 根拠 |
|------|------|------|
| エラーログ出力先 | GENAERRS Temporary Storage Queue | lgstsq.cbl |
| システムログ出力先 | CSMT Transient Data Queue | lgstsq.cbl（WRITEQ TD QUEUE） |
| ログ形式 | 日付、時刻、プログラム名、顧客番号、SQLCODE | ERROR-MSG構造体（各プログラム共通） |
| トランザクションカウンター | Named Counter Server（GENA pool） | lgastat1.cbl、lgsetup.cbl |
| イベント監視 | Event Binding（Transaction_Counters.evbind） | イベント処理定義 |

### 5.2 ログ出力内容

| ログ種別 | 出力項目 | 根拠 |
|----------|----------|------|
| エラーログ | 日時、プログラム名、顧客番号、SQLリクエスト種別、SQLCODE | ERROR-MSG構造（lgacdb01.cbl等） |
| COMMAREA出力 | 先頭90バイト | CA-ERROR-MSG構造体 |
| 制御情報 | LOW CUSTOMER、HIGH CUSTOMER | GENACNTL TSQ |

### 5.3 運用管理トランザクション

| トランザクションID | 機能 | 根拠 |
|-------------------|------|------|
| LGSE | カウンター・TSQ初期化 | lgsetup.cbl |
| LGCF | VSAM顧客番号取得 | Reference.md |
| LGPF | VSAMポリシー・顧客番号取得 | Reference.md |
| LGST | イベントアダプタトリガー | Reference.md |

### 5.4 デバッグ支援

| 項目 | 実装 | 根拠 |
|------|------|------|
| アイキャッチャー | WS-EYECATCHER（プログラム識別子） | 各COBOLプログラムのWS-HEADER |
| トランザクション情報 | EIBTRNID、EIBTRMID、EIBTASKN保存 | 各プログラムの初期化処理 |
| ABEND処理 | ABEND ABCODE('LGCA') NODUMP | COMMAREA未受信時 |

---

## 6. 拡張性要件

### 6.1 スケーラビリティ

| 項目 | 対応 | 根拠 |
|------|------|------|
| CICSトポロジ拡張 | CICSPlex SM対応 | cdef122.jcl、cpsmde2.jcl |
| ワークロード管理 | Workload Simulator対応 | cdef123.jcl、cdef125.jcl |
| マルチリージョン対応 | Coupling Facility経由のデータ共有 | Architecture.md |
| Named Counter共有 | Parallel Sysplex対応 | DFHNCLS_GENA構造体 |
| TSQ共有 | Parallel Sysplex対応 | DFHXQLS_GENA構造体 |

### 6.2 共有TS Queue設定

| 項目 | 設定値 | 根拠 |
|------|--------|------|
| プール名 | GENA | samptsq.jcl |
| 最大キュー数 | 500 | MAXQUEUES=500 |
| バッファ数 | 750 | BUFFERS=750 |

### 6.3 アプリケーション層の拡張性

| 項目 | 対応 | 根拠 |
|------|------|------|
| 3層アーキテクチャ | プレゼンテーション/ビジネス/データ層分離 | Architecture.md、プログラム構造 |
| Webサービス対応 | SOAP 1.1 Providerモード | cdef124.jcl（Pipeline定義） |
| イベント処理 | CICS Event Binding対応 | Transaction_Counters.evbind |

---

## 7. 互換性要件

### 7.1 システム前提条件

| コンポーネント | 要件バージョン | 根拠 |
|---------------|---------------|------|
| CICS TS | V4.1以降 | README.md |
| IBM Db2 | サポートバージョン | README.md |
| COBOLコンパイラ | 環境依存 | Installation.md |
| Language Environment | 環境依存 | Installation.md |
| z/OS USS | Git対応（2.26.2以降推奨） | Installation.md |

### 7.2 文字コード

| 項目 | 設定 | 根拠 |
|------|------|------|
| DB2テーブル | CCSID EBCDIC | db2cre.jcl全テーブル定義 |
| CCSID設定 | 環境変数DB2CCSID（デフォルト285） | Installation.md |

### 7.3 インターフェース互換性

| インターフェース | 形式 | 根拠 |
|-----------------|------|------|
| 3270端末 | BMS Map | ssmap（ASMMAP.jcl） |
| COMMAREA | 固定長32500バイト | lgcmarea.cpy |
| Webサービス | SOAP 1.1 | cdef124.jcl Pipeline設定 |
| TCPポート | 4321 | GENATCP1定義 |

### 7.4 データ形式

| データ型 | COBOL形式 | DB2形式 | 根拠 |
|----------|-----------|---------|------|
| 顧客番号 | PIC 9(10) | INTEGER | lgcmarea.cpy、db2cre.jcl |
| ポリシー番号 | PIC 9(10) | INTEGER | lgcmarea.cpy、db2cre.jcl |
| 日付 | PIC X(10) | DATE | lgcmarea.cpy、db2cre.jcl |
| タイムスタンプ | PIC X(26) | TIMESTAMP | lgcmarea.cpy、db2cre.jcl |
| 金額 | PIC 9(6)〜9(8) | INTEGER | lgcmarea.cpy、db2cre.jcl |

---

## 8. その他の非機能要件

### 8.1 インストール・デプロイ要件

| 項目 | 要件 | 根拠 |
|------|------|------|
| インストール方式 | Git Clone + JCL実行 | Installation.md |
| カスタマイズ | REXX CUST1スクリプト | Installation.md |
| ビルド | COBOLコンパイル（COBOL.jcl） | Building.md |
| DB2バインド | DB2BIND.jcl | Building.md |

### 8.2 運用要件

| 項目 | 要件 | 根拠 |
|------|------|------|
| 初期化 | LGSEトランザクション実行 | Testing.md |
| DB再構築 | DB2DEL.jcl + DB2CRE.jcl | Building.md |
| グループリスト | GRPLIST=(DFHLIST,GENALIST) | Building.md |

### 8.3 ライセンス要件

| 項目 | 内容 | 根拠 |
|------|------|------|
| ライセンス形態 | Eclipse Public License 2.0 | LICENSE |
| 著作権 | IBM Corp. 2011-2021 | 各ソースファイルヘッダー |

---

## 9. 制約事項・前提条件

### 9.1 現在の制約

| 項目 | 内容 | 影響 |
|------|------|------|
| 権限設定 | PUBLIC権限でのDB2アクセス | 本番環境では適切な権限設定が必要 |
| 通信暗号化 | HTTPプロトコル使用 | セキュリティ強化にはHTTPS対応が必要 |
| パスワード管理 | MD5相当のハッシュ | より強力なハッシュアルゴリズムへの移行を推奨 |
| エラーハンドリング | TSQへのログ出力 | 本番環境では外部監視システムとの連携を検討 |

### 9.2 設計上の前提

| 項目 | 内容 | 根拠 |
|------|------|------|
| シングルリージョン動作 | 基本構成は単一CICSリージョン | Architecture.md |
| Two-Phase Commit | DB2とVSAM両方への書き込み時 | Architecture.md |
| VSAMファイル使用 | ベストプラクティスではないがテスト目的で使用 | Architecture.md |

---

## 10. 非機能要件一覧表

| カテゴリ | 要件ID | 要件名 | 優先度 | 状態 |
|----------|--------|--------|--------|------|
| 性能 | NFR-P001 | オンライン応答時間3秒以内 | 高 | 推奨値 |
| 性能 | NFR-P002 | 同時接続250ユーザー対応 | 高 | 設定済 |
| 性能 | NFR-P003 | DB2接続TCB上限400 | 中 | 設定済 |
| 可用性 | NFR-A001 | Two-Phase Commitによる整合性保証 | 高 | 実装済 |
| 可用性 | NFR-A002 | CICSPlex SM対応 | 中 | 対応可 |
| 可用性 | NFR-A003 | Coupling Facility対応 | 中 | オプション |
| セキュリティ | NFR-S001 | RACF/DB2ユーザー認証 | 高 | 設定済 |
| セキュリティ | NFR-S002 | パスワードハッシュ化 | 高 | 実装済 |
| セキュリティ | NFR-S003 | 参照整合性（CASCADE DELETE） | 高 | 設定済 |
| 保守性 | NFR-M001 | エラーログTSQ出力 | 高 | 実装済 |
| 保守性 | NFR-M002 | トランザクションカウンター | 中 | 実装済 |
| 保守性 | NFR-M003 | イベント監視対応 | 中 | 実装済 |
| 拡張性 | NFR-E001 | 3層アーキテクチャ | 高 | 設計済 |
| 拡張性 | NFR-E002 | Webサービス対応 | 中 | 対応可 |
| 拡張性 | NFR-E003 | マルチリージョン拡張 | 中 | 対応可 |
| 互換性 | NFR-C001 | CICS TS V4.1以降対応 | 高 | 必須 |
| 互換性 | NFR-C002 | EBCDIC CCSID対応 | 高 | 設定済 |
| 互換性 | NFR-C003 | SOAP 1.1 Webサービス | 中 | 対応可 |

---

## 付録A: 関連ファイル一覧

| ファイルパス | 内容 |
|--------------|------|
| base/Architecture.md | アーキテクチャ説明 |
| base/Reference.md | リソース定義リファレンス |
| base/Installation.md | インストール手順 |
| base/Building.md | ビルド手順 |
| base/Testing.md | テスト手順 |
| base/cntl/db2cre.jcl | DB2オブジェクト作成 |
| base/cntl/cdef121.jcl | CICS単一リージョン定義 |
| base/cntl/cdef122.jcl | CICSトポロジ環境定義 |
| base/cntl/cdef124.jcl | Webサービス定義 |
| base/cntl/sampncs.jcl | Named Counter Server |
| base/cntl/samptsq.jcl | 共有TS Queue Server |
| base/src/lgcmarea.cpy | COMMAREA定義 |
| base/src/lgsetup.cbl | 初期化プログラム |
| base/src/lgstsq.cbl | ログ出力プログラム |
| base/event-bindings/Transaction_Counters.evbind | イベントバインディング |

---

*本文書はコードベースの自動解析により生成されました。*
