---
generated_at: 2026-01-30 13:15:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **ベースURL/認証方式の記載**：HTTPエンドポイントが存在しないことの確認が必要
  2. **maxParallelDownloadsのデフォルト値**：コード内のコメントに記載はあるが、実装との整合性要確認
  3. **環境要件の詳細**：一部のNode.js要件はコードコメントからの推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/native/libs/Common/JavaScript/types/public-api.ts`
- E-02: `src/native/libs/Common/JavaScript/types/export-api.ts`
- E-03: `src/mono/browser/runtime/dotnet.d.ts`
- E-04: `src/mono/browser/runtime/export-api.ts`
- E-05: `src/native/libs/System.Runtime.InteropServices.JavaScript.Native/interop/http.ts`
- E-06: `src/native/libs/System.Runtime.InteropServices.JavaScript.Native/interop/web-socket.ts`
- E-07: `src/mono/browser/runtime/http.ts`
- E-08: `src/mono/browser/runtime/diagnostics/index.ts`
- E-09: `README.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DotnetHostBuilder.withConfig()はLoaderConfig型を受け取る | E-01 L15, E-03 L63 | ○ |
| C-02 | withApplicationArguments()は可変長引数を受け取る | E-01 L18-20 | ○ |
| C-03 | withEnvironmentVariable()は名前と値のペアを設定 | E-01 L22-24 | ○ |
| C-04 | withEnvironmentVariables()はオブジェクト形式で複数設定 | E-01 L26-30 | ○ |
| C-05 | withVirtualWorkingDirectory()は仮想FS上のパスを設定 | E-01 L32-34 | ○ |
| C-06 | withDiagnosticTracing()はブール値でトレース有効化 | E-01 L36-38 | ○ |
| C-07 | withDebugging()のレベル仕様（>0, =0, <0の動作） | E-01 L40-45 | ○ |
| C-08 | withMainAssembly()はアセンブリ名を指定 | E-01 L47-49 | ○ |
| C-09 | withApplicationArgumentsFromQuery()はURLクエリから取得 | E-01 L51-54 | ○ |
| C-10 | withApplicationEnvironment()は環境名を設定 | E-01 L56-58 | ○ |
| C-11 | withApplicationCulture()はBCP 47形式 | E-01 L60-62 | ○ |
| C-12 | withResourceLoader()はLoadBootResourceCallbackを受け取る | E-01 L64-67 | ○ |
| C-13 | download()はアセットDL後にランタイム作成しない | E-01 L69-71 | ○ |
| C-14 | create()はPromise<RuntimeAPI>を返す | E-01 L73-75 | ○ |
| C-15 | runMain()はランタイムを維持したまま実行 | E-01 L77-82 | ○ |
| C-16 | runMainAndExit()は実行後にランタイム終了 | E-01 L84-91 | ○ |
| C-17 | LoaderConfig.maxParallelDownloadsのデフォルトは16 | E-01 L99-101 | ○ |
| C-18 | LoaderConfig.enableDownloadRetryのデフォルトはtrue | E-01 L103-105 | ○ |
| C-19 | GlobalizationModeの4つのモード（Sharded, All, Invariant, Custom） | E-01 L409-426 | ○ |
| C-20 | RuntimeAPI.runMain()の引数とPromise<number>戻り値 | E-01 L438-446 | ○ |
| C-21 | RuntimeAPI.exit()の引数（code, reason） | E-01 L456-461 | ○ |
| C-22 | RuntimeAPI.getAssemblyExports()はJSExportメソッドを取得 | E-01 L469-472 | ○ |
| C-23 | RuntimeAPI.setModuleImports()はJSImport用関数を提供 | E-01 L474-478 | ○ |
| C-24 | MemoryAPI（setHeap/getHeap系）の全関数シグネチャ | E-01 L490-631 | ○ |
| C-25 | localHeapView系関数の短期ビュー注意事項 | E-01 L597-630 | ○ |
| C-26 | DiagnosticsAPI.collectCpuSamples()のデフォルト60秒 | E-01 L635-638 | ○ |
| C-27 | DiagnosticsAPI.collectMetrics()のデフォルト60秒 | E-01 L639-643 | ○ |
| C-28 | DiagnosticsAPI.collectGcDump()の出力形式 | E-01 L644-650 | ○ |
| C-29 | DiagnosticsAPI.connectDSRouter()のWebSocket接続 | E-01 L651-654, E-08 L82-93 | ○ |
| C-30 | HTTP APIにはFetch APIとAbortControllerが必要 | E-05 L15-22, E-07 L15-22 | ○ |
| C-31 | Node.jsではnode-fetchとnode-abort-controllerが必要 | E-05 L17-18, E-07 L17-18 | ○ |
| C-32 | httpSupportsStreamingRequest()の検出ロジック | E-05 L29-50, E-07 L29-50 | ○ |
| C-33 | httpCreateController()はAbortControllerを内部で使用 | E-05 L56-63, E-07 L56-63 | ○ |
| C-34 | httpAbort()はストリームとAbortControllerを中止 | E-05 L73-92, E-07 L73-92 | ○ |
| C-35 | httpFetch()のパラメータ（URL、ヘッダー、オプション、ボディ） | E-05 L144-189, E-07 L144-190 | ○ |
| C-36 | WebSocket APIにはws npmパッケージが必要（Node.js） | E-06 L497-501 | ○ |
| C-37 | wsCreate()はWebSocketインスタンスを拡張して返す | E-06 L44-144 | ○ |
| C-38 | wsOpen()はopenPromiseを返す | E-06 L146-154 | ○ |
| C-39 | wsSend()のメッセージタイプ（0: Text, 1: Binary） | E-06 L349-367 | ○ |
| C-40 | wsClose()のクローズコードと理由パラメータ | E-06 L224-252 | ○ |
| C-41 | wsAbort()は1000コードで接続を閉じる | E-06 L254-270 | ○ |
| C-42 | wsGetState()の戻り値（CONNECTING, OPEN, CLOSING, CLOSED） | E-06 L32-42 | ○ |
| C-43 | 本APIはHTTP REST APIではなくJavaScriptモジュール | **根拠なし** | △ |
| C-44 | PerfViewでの.nettraceファイル読み込み可否 | **コメントのみ** | △ |
| C-45 | Visual StudioでのGCダンプ変換要否 | **コメントのみ** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-43: HTTP REST APIではないという記載**
  - プロジェクト内に明示的なHTTPエンドポイント定義がないことからの推定
  - 候補：アーキテクチャドキュメント / 公式ドキュメント / 設計仕様書

- **C-44, C-45: 外部ツール互換性の記載**
  - ソースコード内のコメントには記載があるが、実際の動作検証は含まれていない
  - 候補：公式ドキュメント / PerfView/Visual Studioの仕様書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - DotnetHostBuilder API定義（型定義ファイルに明確に記載）
- 0: 低リスク - RuntimeAPI関数群（export-api.tsで実装確認済み）
- 0: 低リスク - MemoryAPI関数群（型定義とexportで確認済み）
- 0: 低リスク - HTTP/WebSocket Interop API（実装コードで詳細確認済み）
- 1: 中リスク - 診断API（collectCpuSamples等）のオプションパラメータデフォルト値
- 1: 中リスク - 環境要件（Node.js用パッケージ名）の最新性

## 6) レビュアーチェックリスト（最小）
- [ ] DotnetHostBuilder APIの各メソッドシグネチャが型定義ファイルと一致しているか確認
- [ ] RuntimeAPI関数の戻り値型が正確に記載されているか確認
- [ ] MemoryAPI関数のNativePointer型の使用が適切か確認
- [ ] HTTP Interop APIのパラメータ説明が実装と一致しているか確認
- [ ] WebSocket Interop APIのメッセージタイプ定数が正確か確認
- [ ] DiagnosticCommandOptionsのデフォルト値が実装と一致しているか確認
- [ ] 環境要件（必要なnpmパッケージ）が最新の状態を反映しているか確認
- [ ] GlobalizationModeの列挙値が完全に網羅されているか確認
