# .NET Runtime

## 概要

.NET Runtimeは、Microsoftが開発するオープンソースのクロスプラットフォーム対応ランタイムです。本リポジトリには、.NETランタイム、ライブラリ、および共有ホスト（dotnet）インストーラのソースコードが含まれており、ECMA 335仕様に準拠した自己完結型のランタイム環境を提供します。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| CoreCLRランタイム | .NET Frameworkから派生した包括的な実行エンジン。JITコンパイル、ガベージコレクション、型システムを提供 |
| Monoランタイム | 軽量な実行エンジン。モバイル、WebAssembly、組み込みプラットフォーム向けに最適化 |
| クラスライブラリ | System.Collections、System.IO、System.Net等の標準ライブラリ群を提供 |
| NativeAOT | ネイティブコードへの事前コンパイル（AOT）をサポート |
| ホスト・インストーラ | dotnetコマンドラインインターフェースと各プラットフォーム向けインストーラ |
| クロスプラットフォーム | Windows、Linux、macOS、FreeBSD、Android、iOS、WebAssembly等をサポート |

## 技術スタック

### コア

- フレームワーク: .NET 11.0（開発中）
- 言語: C#（ライブラリ・マネージドコード）、C/C++（ランタイム・ネイティブコード）
- ビルドシステム: MSBuild / Microsoft.DotNet.Arcade.Sdk
- SDK: .NET SDK 11.0.100-alpha.1

### 主要ライブラリ

- Microsoft.DotNet.Arcade.Sdk: ビルドインフラストラクチャ
- Microsoft.DotNet.Helix.Sdk: 分散テスト実行基盤
- Microsoft.Build.NoTargets / Microsoft.Build.Traversal: ビルドオーケストレーション
- xUnit: テストフレームワーク

## ディレクトリ構成

```
runtime-main/
├── src/
│   ├── coreclr/          # CoreCLRランタイム（JIT、GC、VM等）
│   ├── mono/             # Monoランタイム
│   ├── libraries/        # .NETクラスライブラリ（約240+プロジェクト）
│   ├── installer/        # インストーラ・パッケージング
│   ├── native/           # 共有ネイティブコード
│   ├── tasks/            # MSBuildタスク
│   ├── tools/            # 開発ツール
│   ├── workloads/        # .NETワークロード定義
│   ├── tests/            # リポジトリ全体のテスト
│   └── samples/          # サンプルコード
├── docs/                 # ドキュメント
│   ├── workflow/         # ビルド・テスト手順
│   ├── coding-guidelines/# コーディングガイドライン
│   ├── design/           # 設計ドキュメント
│   └── project/          # プロジェクト情報
├── eng/                  # エンジニアリング・CI/CD設定
├── .github/              # GitHubワークフロー・テンプレート
├── build.sh / build.cmd  # ビルドスクリプト
└── global.json           # SDK・ツールバージョン定義
```

## セットアップ

### 必要条件

- **Windows**: Visual Studio 2022以上、C++ワークロード、Windows SDK
- **Linux**: Clang、CMake、各ディストリビューション固有の依存パッケージ
- **macOS**: Xcode Command Line Tools、CMake

詳細な要件は以下を参照:
- [Windows要件](docs/workflow/requirements/windows-requirements.md)
- [Linux要件](docs/workflow/requirements/linux-requirements.md)
- [macOS要件](docs/workflow/requirements/macos-requirements.md)

### クローンとビルド

```bash
# リポジトリのクローン（約400-500MB、展開後1-1.5GB）
git clone https://github.com/dotnet/runtime.git
cd runtime

# 全体ビルド（Debug構成、10-20GBのディスク容量が必要）
./build.sh           # Linux/macOS
.\build.cmd          # Windows

# サブセットビルド（推奨）
./build.sh -subset clr          # CoreCLRのみ
./build.sh -subset libs         # ライブラリのみ
./build.sh -subset clr+libs -c Release  # CLRとライブラリをRelease構成で
```

## 開発

### ビルド構成

| 構成 | 説明 |
| --- | --- |
| Debug | 最適化なし、アサート有効。デバッグに最適 |
| Checked | 最適化あり、アサート有効（CoreCLR専用） |
| Release | 最適化あり、アサート無効。パフォーマンス計測に最適 |

### テスト実行

```bash
# CoreCLRテスト
./src/tests/build.sh
./src/tests/run.sh

# ライブラリテスト
./build.sh -subset libs.tests
dotnet test src/libraries/System.Collections/tests
```

### コード品質ツール

- **警告をエラーとして扱う**: デフォルトで有効。無効にする場合は環境変数 `TreatWarningsAsErrors=false` を設定
- **コードスタイル**: [C#コーディングスタイル](docs/coding-guidelines/coding-style.md)に従う
- **エディタ設定**: `.editorconfig` でコードスタイルを統一

### 貢献方法

1. 既存のIssueを確認、または新規Issueを作成
2. リポジトリをフォークしてブランチを作成
3. [コーディングガイドライン](docs/coding-guidelines/)に従って変更を実装
4. テストを追加・実行
5. Pull Requestを作成

詳細: [CONTRIBUTING.md](CONTRIBUTING.md)
