---
generated_at: 2026-01-30 11:30:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **ディスク容量10-20GB**：実測値ではなく推定値
  2. **クローンサイズ400-500MB**：ドキュメント記載の引用だが実測未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/README.md`（プロジェクトルートREADME）
- E-02: `/Users/tomoka.baba/Work/runtime-main/global.json`（SDKバージョン定義）
- E-03: `/Users/tomoka.baba/Work/runtime-main/Directory.Build.props`（ビルド設定・TFM定義）
- E-04: `/Users/tomoka.baba/Work/runtime-main/docs/README.md`（ドキュメントインデックス）
- E-05: `/Users/tomoka.baba/Work/runtime-main/docs/workflow/README.md`（ワークフローガイド）
- E-06: `/Users/tomoka.baba/Work/runtime-main/CONTRIBUTING.md`（貢献ガイド）
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/`ディレクトリ構造
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/`ディレクトリ一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | .NET Runtimeは.NET Foundationプロジェクトである | E-01 | ○ |
| C-02 | ECMA 335仕様に準拠 | E-04 | ○ |
| C-03 | .NET 11.0が現在の開発バージョン | E-02, E-03 | ○ |
| C-04 | SDK 11.0.100-alpha.1を使用 | E-02 | ○ |
| C-05 | CoreCLRは.NET Frameworkから派生 | E-05 | ○ |
| C-06 | Monoは軽量ランタイム | E-05 | ○ |
| C-07 | src/coreclrにCoreCLRのソースがある | E-07 | ○ |
| C-08 | src/monoにMonoのソースがある | E-07 | ○ |
| C-09 | src/librariesにライブラリがある | E-07, E-08 | ○ |
| C-10 | 約240+のライブラリプロジェクトが存在 | E-08 | ○ |
| C-11 | Microsoft.DotNet.Arcade.Sdkを使用 | E-02 | ○ |
| C-12 | Microsoft.DotNet.Helix.Sdkを使用 | E-02 | ○ |
| C-13 | Debug/Checked/Release構成をサポート | E-05 | ○ |
| C-14 | build.sh/build.cmdでビルド可能 | E-05 | ○ |
| C-15 | -subsetフラグでサブセットビルド可能 | E-05 | ○ |
| C-16 | Windows/Linux/macOS/FreeBSDをサポート | E-05 | ○ |
| C-17 | クローンサイズ400-500MB | E-05 | ○ |
| C-18 | ビルドに10-20GBのディスク容量が必要 | E-05 | △ |
| C-19 | TreatWarningsAsErrorsで警告制御可能 | E-05 | ○ |
| C-20 | .editorconfigでコードスタイル統一 | E-01ディレクトリ | ○ |
| C-21 | MITライセンス | E-01 | ○ |
| C-22 | docs/workflow/に要件ドキュメントあり | E-05 | ○ |
| C-23 | CONTRIBUTING.mdに貢献手順あり | E-06 | ○ |
| C-24 | リポジトリ展開後1-1.5GB | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18（ディスク容量10-20GB）：docs/workflow/README.mdの記載を引用したが、実際のビルド環境での実測値ではない
  - 候補：CI/CDログ / ビルド成果物サイズの実測 / 開発者フィードバック
- C-24（展開後1-1.5GB）：docs/workflow/README.mdの記載を引用したが、現在のリポジトリサイズとして最新かは未確認
  - 候補：git実測 / リポジトリ統計情報

## 5) リスクフラグ（レビュー観点）
- 0: プロジェクト概要・機能説明（E-01, E-04, E-05による十分な根拠あり）
- 0: 技術スタック情報（E-02, E-03で明確に定義）
- 0: ディレクトリ構成（E-07, E-08で実際に確認済み）
- 1: ディスク容量・サイズ情報（ドキュメント引用のため実測推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] .NET 11.0のバージョン情報が最新か確認（global.jsonと照合）
- [ ] ディレクトリ構成が現在のリポジトリ構造と一致するか確認
- [ ] ビルド手順が実際に動作するか検証（build.sh/build.cmd）
- [ ] 各ドキュメントへのリンクパスが正しいか確認
- [ ] ライブラリ数（約240+）が最新の状態を反映しているか確認
