---
generated_at: 2026-01-30 18:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：43 / 45、根拠なし：2
- 優先レビュー（高）
  1. **t_ プレフィックス規則**：コードサンプルでの直接確認なし
  2. **ホスト起動の場所**：具体的なファイルの内容未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要、主要コンポーネント説明
- E-02: `global.json` - SDK/ツールバージョン情報
- E-03: `Directory.Build.props` - ビルド設定、プロジェクト構造定義
- E-04: `docs/workflow/README.md` - ワークフローガイド、コンポーネント説明
- E-05: `docs/coding-guidelines/coding-style.md` - コーディングスタイルガイド
- E-06: `docs/project/glossary.md` - 用語集
- E-07: `CONTRIBUTING.md` - コントリビューションガイド
- E-08: `src/libraries/System.Collections/src/System/Collections/Generic/Stack.cs` - Stack実装
- E-09: `src/libraries/System.Private.CoreLib/src/System/Collections/Generic/List.cs` - List実装
- E-10: `src/coreclr/vm/class.cpp` - CoreCLR VM実装（C++）
- E-11: `src/` ディレクトリ構造
- E-12: `docs/` ディレクトリ構造
- E-13: `src/libraries/` ディレクトリ一覧
- E-14: `src/coreclr/jit/` ディレクトリ一覧
- E-15: `src/coreclr/vm/` ディレクトリ一覧
- E-16: `src/mono/` ディレクトリ一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 本プロジェクトはC#, C/C++, IL, CMake, MSBuildを使用 | E-01, E-03, E-08, E-10, E-14 | ○ |
| C-02 | ファイル先頭にはライセンスヘッダーが付与される | E-08, E-09, E-10 | ○ |
| C-03 | usingディレクティブは名前空間の外側に配置 | E-05, E-08, E-09 | ○ |
| C-04 | System.*名前空間を先頭にアルファベット順 | E-05, E-08 | ○ |
| C-05 | プライベートフィールドは`_`プレフィックス | E-05, E-08, E-09 | ○ |
| C-06 | 静的フィールドは`s_`プレフィックス | E-05, E-09 | ○ |
| C-07 | スレッドスタティックは`t_`プレフィックス | E-05 | △ |
| C-08 | 定数はPascalCase | E-05, E-08, E-09 | ○ |
| C-09 | Allmanスタイル（波括弧は新しい行） | E-05, E-08 | ○ |
| C-10 | 4スペースインデント | E-05 | ○ |
| C-11 | メソッド名はPascalCase | E-05, E-08, E-09 | ○ |
| C-12 | ローカル変数はcamelCase | E-05, E-08, E-09 | ○ |
| C-13 | CoreCLRとMonoの2つのランタイムが存在 | E-01, E-04, E-06 | ○ |
| C-14 | CoreCLRはクラウド/デスクトップ向け | E-04, E-06 | ○ |
| C-15 | Monoはモバイル/ブラウザ向け | E-04, E-06 | ○ |
| C-16 | Debug/Checked/Release構成が存在 | E-04 | ○ |
| C-17 | Checked構成はCoreCLR専用 | E-04 | ○ |
| C-18 | CONTRACTLマクロの説明 | E-10 | ○ |
| C-19 | src/coreclr/にCoreCLRソースコードがある | E-11, E-14, E-15 | ○ |
| C-20 | src/mono/にMonoソースコードがある | E-11, E-16 | ○ |
| C-21 | src/libraries/にマネージドライブラリがある | E-11, E-13 | ○ |
| C-22 | ref/サブディレクトリには参照アセンブリがある | E-13 | ○ |
| C-23 | src/サブディレクトリには実装コードがある | E-13 | ○ |
| C-24 | tests/サブディレクトリにはテストコードがある | E-13 | ○ |
| C-25 | System.Private.CoreLibは最低レベルマネージドライブラリ | E-04, E-06, E-03 | ○ |
| C-26 | Stack<T>の実装詳細（_array, _size, _version） | E-08 | ○ |
| C-27 | TryPeek/TryPopパターンの説明 | E-08 | ○ |
| C-28 | バウンドチェック最適化の説明 | E-08 | ○ |
| C-29 | Enumeratorの構造体実装 | E-08 | ○ |
| C-30 | _versionフィールドの目的 | E-08 | ○ |
| C-31 | Push/Pop/Peekメソッドの実装 | E-08 | ○ |
| C-32 | Growメソッドの容量拡張ロジック | E-08 | ○ |
| C-33 | ThrowHelperパターンの説明 | E-09 | ○ |
| C-34 | List<T>の静的配列キャッシュ | E-09 | ○ |
| C-35 | C++でのm_プレフィックス規則 | E-10 | ○ |
| C-36 | C++でのポインタpプレフィックス規則 | E-10 | ○ |
| C-37 | 用語AOT/BCL/CLR/GC/IL/JIT/PAL/TFMの説明 | E-06 | ○ |
| C-38 | build.sh/build.cmdがビルドスクリプト | E-01, E-04, E-11 | ○ |
| C-39 | global.jsonにSDKバージョン設定がある | E-02 | ○ |
| C-40 | Directory.Build.propsに共通ビルドプロパティがある | E-03 | ○ |
| C-41 | source.dot.netでソースコード閲覧可能 | E-01 | ○ |
| C-42 | docs/area-owners.mdに担当者一覧がある | E-01, E-07 | ○ |
| C-43 | ホスト起動はsrc/coreclr/hosts/に実装 | **根拠なし** | △ |
| C-44 | インターフェースはIプレフィックス | E-05, E-08 | ○ |
| C-45 | ジェネリック型パラメータはT/TKey/TValue | E-08, E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-07: スレッドスタティック`t_`プレフィックス**
  - コーディングスタイルガイドには記載があるが、実際のコード例での確認が不十分
  - 候補: `src/libraries/System.Threading/` / `src/coreclr/vm/` でのt_使用例を確認

- **C-43: ホスト起動の実装場所**
  - `src/coreclr/hosts/` の存在は推定だが、ディレクトリ内容の詳細確認なし
  - 候補: `src/coreclr/hosts/` / `src/installer/` / `src/native/` を確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 言語基礎、命名規則、ディレクトリ構造（コード/ドキュメントから直接確認済み）
- **0: 低リスク** - アーキテクチャ概要（公式ドキュメントと整合）
- **0: 低リスク** - コードパターン（実際のソースコードから抽出）
- **1: 中リスク** - 一部の命名規則詳細（t_プレフィックス等、使用例の確認が限定的）
- **1: 中リスク** - ホスト起動の実装場所（ディレクトリ構造からの推定）

## 6) レビュアーチェックリスト（最小）
- [ ] C#命名規則が実際のコードベースと一致しているか確認
- [ ] C++命名規則がCoreCLR/Monoで一貫しているか確認
- [ ] ディレクトリ構造の説明が最新の状態と一致しているか確認
- [ ] アーキテクチャ図が実際のコンポーネント関係を正確に表現しているか確認
- [ ] 参照ドキュメントのパスが正しいか確認
- [ ] コード例の行番号が実際のファイルと一致しているか確認
