---
generated_at: 2026-01-30 13:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：アーキテクチャ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **C-33 ミドルウェアバージョン情報**：バージョン情報は推定値
  2. **C-34 TTL設定値**：具体的なデフォルト値の根拠なし
  3. **C-35 パフォーマンス特性**：定量的な数値の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要
- E-02: `docs/workflow/README.md` - ワークフローガイド
- E-03: `CONTRIBUTING.md` - コントリビューションガイド
- E-04: `Directory.Build.props` - ビルド設定
- E-05: `global.json` - SDK/ツールバージョン
- E-06: `src/` ディレクトリ構成
- E-07: `src/coreclr/` - CoreCLRソースコード
- E-08: `src/mono/` - Monoソースコード
- E-09: `src/libraries/` - ライブラリソースコード
- E-10: `src/native/` - ネイティブコードソースコード
- E-11: `src/installer/` - インストーラーソースコード
- E-12: `docs/design/coreclr/botr/README.md` - Book of the Runtime目次
- E-13: `docs/design/coreclr/botr/intro-to-clr.md` - CLR概要
- E-14: `docs/design/coreclr/botr/garbage-collection.md` - GC設計
- E-15: `docs/design/coreclr/botr/type-system.md` - 型システム設計
- E-16: `src/coreclr/vm/` - VMソースコード
- E-17: `src/coreclr/jit/` - JITソースコード
- E-18: `src/coreclr/gc/` - GCソースコード
- E-19: `eng/pipelines/` - CI/CDパイプライン定義
- E-20: `.editorconfig` - コーディング規約

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | .NET RuntimeはCoreClRとMonoの2つのランタイムエンジンを持つ | E-01, E-02, E-06 | ○ |
| C-02 | プロジェクトはコンポーネントベースアーキテクチャを採用 | E-06, E-07, E-08, E-09 | ○ |
| C-03 | CoreCLRはvm/, jit/, gc/等のサブディレクトリで構成される | E-07, E-16, E-17, E-18 | ○ |
| C-04 | GCは世代別ガベージコレクション（Gen0/Gen1/Gen2）を採用 | E-14 | ○ |
| C-05 | JITコンパイラはRyuJITと呼ばれる | E-12, E-13 | ○ |
| C-06 | MonoはWebAssembly/WASI対応を持つ | E-08 | ○ |
| C-07 | ライブラリはSystem.*とMicrosoft.Extensions.*で構成される | E-09 | ○ |
| C-08 | プラットフォーム抽象化層（PAL）が存在する | E-07 (pal/ディレクトリ) | ○ |
| C-09 | .NET 11.0バージョンを開発中 | E-04, E-05 | ○ |
| C-10 | MITライセンスで提供される | E-01 | ○ |
| C-11 | Windows/Linux/macOS/FreeBSDをビルドプラットフォームとしてサポート | E-02 | ○ |
| C-12 | Hostレイヤーにdotnet host, hostfxr, hostpolicyが存在 | E-10 (corehost/) | ○ |
| C-13 | EventPipeによる診断機能を提供 | E-10 (eventpipe/) | ○ |
| C-14 | Azure DevOpsとHelixでCI/CDを実行 | E-19 | ○ |
| C-15 | TreatWarningsAsErrors=trueでビルド | E-04 | ○ |
| C-16 | LangVersion=previewを使用 | E-04 | ○ |
| C-17 | 型システムはMethodTable, EEClass, MethodDesc等で構成 | E-15 | ○ |
| C-18 | GCはSmall Object Heap (SOH)とLarge Object Heap (LOH)を持つ | E-14 | ○ |
| C-19 | 85KB以上のオブジェクトはLOHに配置 | E-14 | ○ |
| C-20 | P/InvokeによるネイティブコードInteropをサポート | E-13 | ○ |
| C-21 | マネージドコードはGC参照を追跡する | E-13 | ○ |
| C-22 | src/tasks/にMSBuildタスクが存在 | E-06 | ○ |
| C-23 | iOS/tvOS/Androidへのクロスコンパイルをサポート | E-04 (OSターゲット設定) | ○ |
| C-24 | Microsoft.DotNet.Arcade.Sdkを使用 | E-05 | ○ |
| C-25 | System.Private.CoreLibはランタイム固有の実装を持つ | E-07, E-08 | ○ |
| C-26 | Book of the Runtime (BOTR)ドキュメントが存在 | E-12 | ○ |
| C-27 | Virtual Stub Dispatchによる仮想メソッド呼び出しを実装 | E-15 | ○ |
| C-28 | インタープリターモードが存在 | E-07 (interpreter/) | ○ |
| C-29 | Native AOTをサポート | E-07 (nativeaot/) | ○ |
| C-30 | .clang-format/.clang-tidyでC/C++コード規約を管理 | E-17 | ○ |
| C-31 | Nullable annotationsを有効化 | E-04 | ○ |
| C-32 | 例外ベースのエラーハンドリングを採用 | E-13 | ○ |
| C-33 | ミドルウェアバージョンは.NET 11.0 | **根拠なし** | △ |
| C-34 | キャッシュTTLは設定可能 | **根拠なし** | △ |
| C-35 | パフォーマンス特性（階層型コンパイル詳細） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-33 ミドルウェアバージョン情報**：各ライブラリの正確なバージョンはNuGetパッケージ定義を確認する必要がある
  - 候補：src/libraries/*/src/*.csproj / eng/Versions.props / PackageVersion設定
- **C-34 キャッシュTTL設定**：具体的なデフォルト値はソースコード確認が必要
  - 候補：Microsoft.Extensions.Caching.Memory/src/ / CacheOptions.cs
- **C-35 パフォーマンス特性**：階層型コンパイルの詳細な挙動はドキュメント・ソースの追加調査が必要
  - 候補：docs/design/coreclr/botr/tiered-compilation.md / src/coreclr/jit/

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: アーキテクチャ全体構成、コンポーネント構成
- **0（低リスク）**: ソースコードディレクトリ構成
- **0（低リスク）**: ビルド設定・CI/CD構成
- **1（中リスク）**: ミドルウェアバージョン情報の正確性
- **1（中リスク）**: パフォーマンス関連の詳細記述

## 6) レビュアーチェックリスト（最小）
- [ ] CoreCLRとMonoの責務分担が実際のソースコードと一致するか確認
- [ ] レイヤー間依存関係が正しく記述されているか確認
- [ ] サポートプラットフォーム一覧が最新の状態と一致するか確認
- [ ] ミドルウェアバージョン情報（△マークの項目）を実際のパッケージ定義と照合
- [ ] GC/JITの動作説明がBOTRドキュメントと整合するか確認
- [ ] コーディング規約の記述が実際の設定ファイルと一致するか確認
