# アーキテクチャ構成図

## システム全体構成図

```mermaid
graph TB
    subgraph "Application Layer"
        APP[".NET Application"]
        ASM["Assemblies (DLLs)"]
    end

    subgraph "Host Layer"
        DOTNET["dotnet host"]
        HOSTFXR["hostfxr"]
        HOSTPOLICY["hostpolicy"]
    end

    subgraph "Runtime Layer"
        subgraph "CoreCLR"
            VM["Virtual Machine"]
            JIT["RyuJIT Compiler"]
            GC["Garbage Collector"]
            TS["Type System"]
            INTEROP["Interop"]
        end

        subgraph "Mono Runtime"
            MONO_VM["Mono VM"]
            MONO_JIT["Mono JIT/AOT"]
            MONO_GC["Mono GC (SGen)"]
        end
    end

    subgraph "Libraries Layer"
        CORELIB["System.Private.CoreLib"]
        SYSLIB["System.* Libraries"]
        EXTLIB["Microsoft.Extensions.*"]
    end

    subgraph "Native Layer"
        PAL["Platform Abstraction Layer"]
        NATIVE_LIBS["Native Libraries"]
        EVENTPIPE["EventPipe"]
    end

    subgraph "Platform Layer"
        WIN["Windows"]
        LINUX["Linux"]
        MACOS["macOS"]
        WASM["WebAssembly"]
    end

    APP --> DOTNET
    DOTNET --> HOSTFXR
    HOSTFXR --> HOSTPOLICY
    HOSTPOLICY --> VM
    HOSTPOLICY --> MONO_VM

    ASM --> VM
    ASM --> MONO_VM

    VM --> JIT
    VM --> GC
    VM --> TS
    VM --> INTEROP

    MONO_VM --> MONO_JIT
    MONO_VM --> MONO_GC

    JIT --> CORELIB
    MONO_JIT --> CORELIB
    CORELIB --> SYSLIB
    SYSLIB --> EXTLIB

    VM --> PAL
    MONO_VM --> PAL
    PAL --> NATIVE_LIBS
    VM --> EVENTPIPE
    MONO_VM --> EVENTPIPE

    PAL --> WIN
    PAL --> LINUX
    PAL --> MACOS
    MONO_VM --> WASM
```

## コンポーネント詳細図

### CoreCLR 内部構造

```mermaid
graph TB
    subgraph "CoreCLR Runtime"
        subgraph "Execution Engine (vm/)"
            EXEC["Execution Engine"]
            THREADS["Thread Management"]
            EXCEPT["Exception Handling"]
            SYNC["Synchronization"]
        end

        subgraph "JIT Compiler (jit/)"
            IMPORTER["IL Importer"]
            OPTIMIZER["Optimizer"]
            CODEGEN["Code Generator"]
            REGALLOC["Register Allocator"]
        end

        subgraph "Garbage Collector (gc/)"
            ALLOC["Allocator"]
            MARK["Mark Phase"]
            SWEEP["Sweep/Compact"]
            GEN["Generational GC"]
        end

        subgraph "Type System"
            LOADER["Type Loader"]
            MTABLE["MethodTable"]
            MDESC["MethodDesc"]
            VSD["Virtual Stub Dispatch"]
        end

        subgraph "Interop"
            PINVOKE["P/Invoke"]
            COM["COM Interop"]
            MARSHALING["Marshaling"]
        end
    end

    EXEC --> THREADS
    EXEC --> EXCEPT
    EXEC --> SYNC

    EXEC --> IMPORTER
    IMPORTER --> OPTIMIZER
    OPTIMIZER --> REGALLOC
    REGALLOC --> CODEGEN

    EXEC --> ALLOC
    ALLOC --> MARK
    MARK --> SWEEP
    GEN --> ALLOC

    EXEC --> LOADER
    LOADER --> MTABLE
    MTABLE --> MDESC
    MDESC --> VSD

    EXEC --> PINVOKE
    PINVOKE --> MARSHALING
    COM --> MARSHALING
```

### ライブラリ層構成

```mermaid
graph LR
    subgraph "Core Libraries"
        CORELIB["System.Private.CoreLib"]
        RUNTIME["System.Runtime"]
        COLLECTIONS["System.Collections.*"]
        IO["System.IO.*"]
        NET["System.Net.*"]
        THREADING["System.Threading.*"]
    end

    subgraph "Extensions"
        DI["Microsoft.Extensions.DependencyInjection"]
        CONFIG["Microsoft.Extensions.Configuration"]
        LOGGING["Microsoft.Extensions.Logging"]
        HOSTING["Microsoft.Extensions.Hosting"]
        CACHING["Microsoft.Extensions.Caching"]
    end

    subgraph "Specialized"
        TEXT["System.Text.*"]
        SECURITY["System.Security.*"]
        DIAGNOSTICS["System.Diagnostics.*"]
        REFLECTION["System.Reflection.*"]
        LINQ["System.Linq"]
    end

    CORELIB --> RUNTIME
    RUNTIME --> COLLECTIONS
    RUNTIME --> IO
    RUNTIME --> NET
    RUNTIME --> THREADING

    RUNTIME --> TEXT
    RUNTIME --> SECURITY
    RUNTIME --> DIAGNOSTICS
    RUNTIME --> REFLECTION
    RUNTIME --> LINQ

    DI --> CORELIB
    CONFIG --> CORELIB
    LOGGING --> CORELIB
    HOSTING --> DI
    HOSTING --> CONFIG
    HOSTING --> LOGGING
    CACHING --> DI
```

## データフロー図

### アプリケーション実行フロー

```mermaid
sequenceDiagram
    participant App as Application
    participant Host as dotnet host
    participant HFX as hostfxr
    participant HP as hostpolicy
    participant CLR as CoreCLR/Mono
    participant JIT as JIT Compiler
    participant GC as Garbage Collector

    App->>Host: 起動
    Host->>HFX: ランタイム解決
    HFX->>HP: ポリシー適用
    HP->>CLR: ランタイム初期化
    CLR->>CLR: アセンブリロード
    CLR->>CLR: 型ロード

    loop メソッド実行
        CLR->>JIT: IL コンパイル要求
        JIT->>CLR: ネイティブコード
        CLR->>CLR: コード実行
        CLR->>GC: メモリ割り当て
        GC-->>CLR: オブジェクト参照
    end

    CLR->>GC: GC トリガー
    GC->>GC: マーク & スイープ
    GC-->>CLR: メモリ回収完了

    CLR->>Host: 終了
```

### JIT コンパイルフロー

```mermaid
flowchart TD
    IL["IL (Intermediate Language)"] --> IMPORT["Importer"]
    IMPORT --> HIR["High-Level IR (HIR)"]
    HIR --> INLINING["Inlining"]
    INLINING --> OPTLOOP["Loop Optimization"]
    OPTLOOP --> SSA["SSA Construction"]
    SSA --> VALUENUM["Value Numbering"]
    VALUENUM --> CSE["Common Subexpression Elimination"]
    CSE --> CONST["Constant Propagation"]
    CONST --> DEADCODE["Dead Code Elimination"]
    DEADCODE --> LIR["Low-Level IR (LIR)"]
    LIR --> LOWERING["Lowering"]
    LOWERING --> REGALLOC["Register Allocation"]
    REGALLOC --> CODEGEN["Code Generation"]
    CODEGEN --> NATIVE["Native Code"]
```

### GC 世代構造

```mermaid
graph TB
    subgraph "Managed Heap"
        subgraph "Small Object Heap (SOH)"
            GEN0["Generation 0<br/>(Young Objects)"]
            GEN1["Generation 1<br/>(Survived Objects)"]
            GEN2["Generation 2<br/>(Long-Lived Objects)"]
        end

        subgraph "Large Object Heap (LOH)"
            LOH["Large Objects<br/>(>= 85KB)"]
        end

        subgraph "Pinned Object Heap (POH)"
            POH["Pinned Objects"]
        end
    end

    ALLOC["New Allocation"] --> GEN0
    GEN0 -->|Survived| GEN1
    GEN1 -->|Survived| GEN2

    LARGE["Large Allocation"] --> LOH
    PINNED["Pinned Allocation"] --> POH
```

## デプロイメント図

```mermaid
graph TB
    subgraph "Development"
        DEV["Developer Machine"]
        SDK["dotnet SDK"]
    end

    subgraph "Build System"
        AZURE["Azure DevOps"]
        HELIX["Helix Test Farm"]
    end

    subgraph "Distribution"
        NUGET["NuGet.org"]
        DOTNETDL["dotnet.microsoft.com"]
        GITHUB["GitHub Releases"]
    end

    subgraph "Target Platforms"
        subgraph "Desktop/Server"
            WIN_X64["Windows x64"]
            WIN_ARM64["Windows ARM64"]
            LINUX_X64["Linux x64"]
            LINUX_ARM64["Linux ARM64"]
            MACOS_X64["macOS x64"]
            MACOS_ARM64["macOS ARM64"]
        end

        subgraph "Mobile/Embedded"
            IOS["iOS"]
            ANDROID["Android"]
            TVOS["tvOS"]
        end

        subgraph "Web"
            WASM_BROWSER["WebAssembly (Browser)"]
            WASI_TARGET["WASI"]
        end
    end

    DEV --> SDK
    SDK --> AZURE
    AZURE --> HELIX
    HELIX --> AZURE
    AZURE --> NUGET
    AZURE --> DOTNETDL
    AZURE --> GITHUB

    DOTNETDL --> WIN_X64
    DOTNETDL --> WIN_ARM64
    DOTNETDL --> LINUX_X64
    DOTNETDL --> LINUX_ARM64
    DOTNETDL --> MACOS_X64
    DOTNETDL --> MACOS_ARM64

    NUGET --> IOS
    NUGET --> ANDROID
    NUGET --> TVOS

    NUGET --> WASM_BROWSER
    NUGET --> WASI_TARGET
```

## ソースコード構成図

```mermaid
graph TB
    subgraph "Repository Root"
        SRC["src/"]
        DOCS["docs/"]
        ENG["eng/"]
        TESTS["src/tests/"]
    end

    subgraph "src/"
        CORECLR["coreclr/"]
        MONO["mono/"]
        LIBS["libraries/"]
        NATIVE["native/"]
        INSTALLER["installer/"]
        TASKS["tasks/"]
    end

    subgraph "coreclr/"
        CLR_VM["vm/"]
        CLR_JIT["jit/"]
        CLR_GC["gc/"]
        CLR_INTERP["interpreter/"]
        CLR_NATIVEAOT["nativeaot/"]
        CLR_PAL["pal/"]
        CLR_CORELIB["System.Private.CoreLib/"]
    end

    subgraph "mono/"
        MONO_CORE["mono/"]
        MONO_BROWSER["browser/"]
        MONO_WASM["wasm/"]
        MONO_WASI["wasi/"]
        MONO_CORELIB["System.Private.CoreLib/"]
    end

    SRC --> CORECLR
    SRC --> MONO
    SRC --> LIBS
    SRC --> NATIVE
    SRC --> INSTALLER
    SRC --> TASKS

    CORECLR --> CLR_VM
    CORECLR --> CLR_JIT
    CORECLR --> CLR_GC
    CORECLR --> CLR_INTERP
    CORECLR --> CLR_NATIVEAOT
    CORECLR --> CLR_PAL
    CORECLR --> CLR_CORELIB

    MONO --> MONO_CORE
    MONO --> MONO_BROWSER
    MONO --> MONO_WASM
    MONO --> MONO_WASI
    MONO --> MONO_CORELIB
```
