---
generated_at: 2026-01-30 13:45:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **バックアップ保持期間の詳細**：具体的なポリシー文書が見つからない
  2. **Azure Blob Storage スペック**：詳細な設定ファイルが存在しない
  3. **監視ダッシュボード詳細**：Azure DevOps側の設定は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要とAzure DevOpsビルドバッジ
- E-02: `global.json` - .NET SDK バージョン定義
- E-03: `eng/pipelines/runtime.yml` - メインCI/CDパイプライン定義
- E-04: `eng/pipelines/helix-platforms.yml` - Helixプラットフォーム定義
- E-05: `eng/pipelines/libraries/helix.yml` - Helixテスト送信設定
- E-06: `.devcontainer/Dockerfile` - 標準開発コンテナ
- E-07: `.devcontainer/wasm/Dockerfile` - WebAssembly開発コンテナ
- E-08: `.devcontainer/wasm-multiThreaded/Dockerfile` - マルチスレッドWASMコンテナ
- E-09: `.devcontainer/android/Dockerfile` - Android開発コンテナ
- E-10: `src/libraries/System.Net.Http/tests/StressTests/HttpStress/docker-compose.yml` - HTTPストレステスト構成
- E-11: `src/libraries/System.Net.Http/tests/StressTests/HttpStress/Dockerfile` - HTTPストレステストDockerfile
- E-12: `src/libraries/System.Net.Security/tests/StressTests/SslStress/docker-compose.yml` - SSLストレステスト構成
- E-13: `src/libraries/System.Net.Security/tests/StressTests/SslStress/Dockerfile` - SSLストレステストDockerfile
- E-14: `src/libraries/Common/tests/System/Net/EnterpriseTests/setup/docker-compose.yml` - エンタープライズテスト構成
- E-15: `src/libraries/Common/tests/System/Net/EnterpriseTests/setup/kdc/Dockerfile` - KDCコンテナ
- E-16: `src/libraries/Common/tests/System/Net/EnterpriseTests/setup/apacheweb/Dockerfile` - Apacheコンテナ
- E-17: `src/libraries/Common/tests/System/Net/EnterpriseTests/setup/linuxclient/Dockerfile` - Linuxクライアントコンテナ
- E-18: `src/coreclr/nativeaot/docs/Dockerfile.cross-build-x64-arm64` - Native AOTクロスビルド
- E-19: `.github/workflows/README.md` - GitHub Actionsワークフロー説明
- E-20: `.github/workflows/*.yml` - 各種GitHub Actionsワークフロー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Azure DevOps Pipelinesをメインビルドシステムとして使用 | E-01, E-03 | ○ |
| C-02 | .NET SDK 11.0.100-alpha.1を使用 | E-02 | ○ |
| C-03 | GitHub Actionsで補助ワークフローを実行 | E-19, E-20 | ○ |
| C-04 | Helixで分散テストを実行 | E-04, E-05 | ○ |
| C-05 | バッチビルド設定（batch: true）を採用 | E-03 | ○ |
| C-06 | UTC 8:00/20:00でスケジュールビルドを実行 | E-03 | ○ |
| C-07 | Windows 10/11およびServer 2019-2025をサポート | E-04 | ○ |
| C-08 | macOS Ventura-Sequoia (13-26)をサポート | E-04 | ○ |
| C-09 | Ubuntu 22.04-26.04をサポート | E-04 | ○ |
| C-10 | Alpine 3.23-edgeをサポート | E-04 | ○ |
| C-11 | Android API Level 21-35をサポート | E-04, E-09 | ○ |
| C-12 | HTTPストレステストにdocker-composeを使用 | E-10, E-11 | ○ |
| C-13 | SSLストレステストにdocker-composeを使用 | E-12, E-13 | ○ |
| C-14 | Kerberosテスト用にKDCコンテナを構成 | E-14, E-15 | ○ |
| C-15 | Apache HTTP ServerでNTLM/Kerberos認証テスト | E-14, E-16 | ○ |
| C-16 | linux.contoso.comネットワークでテスト環境を分離 | E-14 | ○ |
| C-17 | 開発コンテナにdotnet:8.0-nobleベースイメージを使用 | E-06, E-07, E-08, E-09 | ○ |
| C-18 | WASMコンテナにV8 Engine 10.8.168を導入 | E-07 | ○ |
| C-19 | AndroidコンテナにNDK r27cを使用 | E-09 | ○ |
| C-20 | AndroidコンテナにSDK API Level 35を使用 | E-09 | ○ |
| C-21 | clang/cmake/ninja-buildを開発ツールとしてインストール | E-06 | ○ |
| C-22 | msquicをASAN有効でビルド | E-11 | ○ |
| C-23 | ストレステストでポート5001を使用 | E-10, E-11 | ○ |
| C-24 | KDCでポート88 (TCP/UDP)を公開 | E-15 | ○ |
| C-25 | Apacheでポート80/8080を公開 | E-16 | ○ |
| C-26 | mcr.microsoft.comをコンテナレジストリとして使用 | E-06, E-15, E-16, E-17 | ○ |
| C-27 | Native AOTクロスコンパイル用Dockerfileが存在 | E-18 | ○ |
| C-28 | フォークでのワークフロー実行を制限 | E-19 | ○ |
| C-29 | Helixアクセストークンで内部テストを認証 | E-05 | ○ |
| C-30 | CET対応Windows 11キューが存在 | E-04 | ○ |
| C-31 | iOS/tvOSデバイステスト用キューが存在 | E-04 | ○ |
| C-32 | WebAssemblyテスト用Ubuntuキューが存在 | E-04 | ○ |
| C-33 | Azure Blob Storageでアーティファクトを保存 | **根拠なし** | △ |
| C-34 | バックアップ保持期間はリリースサイクルに依存 | **根拠なし** | △ |
| C-35 | Azure DevOpsダッシュボードで監視 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **Azure Blob Storage設定**: パイプラインでアーティファクトアップロードの記述はあるが、ストレージの詳細設定ファイルは確認できず
  - 候補：Azure DevOps設定 / 別リポジトリの設定 / 組織レベルの設定
- **バックアップポリシー**: 明示的なバックアップポリシー文書が存在しない
  - 候補：運用ドキュメント / Azure DevOps設定 / 組織ポリシー
- **監視ダッシュボード設定**: Azure DevOps側の詳細設定は本リポジトリ外
  - 候補：Azure DevOps Project Settings / 別管理

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: CI/CDパイプライン構成（E-03で詳細に定義）
- **0 (低リスク)**: Dockerコンテナ構成（複数のDockerfileで確認）
- **0 (低リスク)**: Helixプラットフォーム定義（E-04で網羅的に定義）
- **1 (中リスク)**: バックアップ設計（推測を含む）
- **1 (中リスク)**: 監視設計（Azure DevOps外の設定に依存）
- **0 (低リスク)**: 外部サービス連携（各設定ファイルで確認）

## 6) レビュアーチェックリスト（最小）
- [ ] Azure Blob Storageの実際の設定がパイプライン定義と一致しているか確認
- [ ] バックアップポリシーについて運用チームに確認
- [ ] 監視ダッシュボードのURL/アクセス方法を補完
- [ ] Helixキュー名が最新の命名規則に従っているか確認
- [ ] 本番環境とテスト環境のネットワーク分離が適切か確認
- [ ] セキュリティトークン（Helix API等）の管理方法を確認
