# インフラ構成図

## 全体アーキテクチャ

```mermaid
flowchart TB
    subgraph GitHub["GitHub (dotnet/runtime)"]
        Repo[("ソースコード\nリポジトリ")]
        PR["Pull Request"]
        Issues["Issues"]
    end

    subgraph AzureDevOps["Azure DevOps"]
        subgraph Pipelines["パイプライン"]
            MainPipeline["runtime.yml\n(メインCI/CD)"]
            LibrariesPipeline["libraries/*.yml"]
            CoreCLRPipeline["coreclr/*.yml"]
        end
        AgentPool["Agent Pool\n(自動スケーリング)"]
    end

    subgraph GitHubActions["GitHub Actions"]
        Labeler["ラベラー"]
        Backport["バックポート"]
        Lint["マークダウンリント"]
        Workflows["その他ワークフロー"]
    end

    subgraph Helix["Microsoft Helix"]
        subgraph HelixQueues["テストキュー"]
            WindowsQueue["Windows\n(10/11/Server)"]
            LinuxQueue["Linux\n(Ubuntu/Debian/Fedora/Alpine)"]
            MacQueue["macOS\n(Ventura-Sequoia)"]
            MobileQueue["iOS/Android"]
            WasmQueue["WebAssembly"]
        end
    end

    subgraph Storage["ストレージ"]
        AzureBlob[("Azure Blob\nStorage")]
        NuGet[("NuGet.org")]
        MCR[("mcr.microsoft.com\nContainer Registry")]
    end

    Repo --> MainPipeline
    PR --> MainPipeline
    PR --> GitHubActions
    MainPipeline --> AgentPool
    AgentPool --> HelixQueues
    AgentPool --> AzureBlob
    HelixQueues --> AzureBlob
    MainPipeline --> NuGet
    MainPipeline --> MCR
```

## CI/CDパイプライン構成

```mermaid
flowchart LR
    subgraph Triggers["トリガー"]
        Push["Push\n(release/*.*)"]
        PRTrigger["PR\n(main, release/*.*)"]
        Schedule["スケジュール\n(UTC 8:00/20:00)"]
    end

    subgraph Stages["ステージ"]
        EvalPaths["EvaluatePaths\n(PR時のみ)"]
        Build["Build Stage"]
        Test["Test Stage"]
    end

    subgraph Jobs["ジョブ (Build Stage)"]
        CoreCLR["CoreCLR\nビルド"]
        Libraries["Libraries\nビルド"]
        Host["Host\nビルド"]
        Packs["Packs\nビルド"]
        WASM["Browser WASM\nビルド"]
    end

    subgraph Platforms["プラットフォーム"]
        Win["Windows\n(x64/x86/ARM64)"]
        Linux["Linux\n(x64/ARM/ARM64/musl)"]
        Mac["macOS\n(x64/ARM64)"]
        Browser["Browser\n(WASM)"]
    end

    Push --> Stages
    PRTrigger --> Stages
    Schedule --> Stages

    EvalPaths --> Build
    Build --> Test

    Build --> Jobs
    CoreCLR --> Platforms
    Libraries --> Platforms
    Host --> Platforms
    Packs --> Platforms
    WASM --> Browser
```

## Docker テスト環境構成

### HTTP Stress Test

```mermaid
flowchart TB
    subgraph StressTest["HTTP Stress Test (docker-compose)"]
        subgraph Client["client"]
            ClientApp["HttpStress\nクライアントモード"]
        end
        subgraph Server["server"]
            ServerApp["HttpStress\nサーバーモード"]
            Port5001["Port: 5001"]
        end
        DumpShare["/dumps\n(共有ボリューム)"]
    end

    Client -->|"HTTPS"| Server
    Client --> DumpShare
    Server --> DumpShare
```

### SSL Stress Test

```mermaid
flowchart TB
    subgraph SSLTest["SSL Stress Test (docker-compose)"]
        subgraph SSLClient["client"]
            SSLClientApp["SslStress\nクライアントモード"]
        end
        subgraph SSLServer["server"]
            SSLServerApp["SslStress\nサーバーモード"]
            SSLPort["Port: 5001"]
        end
        SSLDumpShare["/dumps\n(共有ボリューム)"]
    end

    SSLClient -->|"TLS"| SSLServer
    SSLClient --> SSLDumpShare
    SSLServer --> SSLDumpShare
```

### Enterprise Authentication Test

```mermaid
flowchart TB
    subgraph EnterpriseTest["Enterprise Tests (docker-compose)"]
        subgraph Network["linux.contoso.com ネットワーク"]
            subgraph KDC["kdc"]
                Kerberos["Kerberos KDC"]
                KDCPort88["Port: 88\n(TCP/UDP)"]
            end

            subgraph Apache["apacheweb"]
                ApacheServer["Apache HTTP"]
                NTLM["mod_auth_ntlm"]
                Kerb["mod_auth_kerb"]
                ApachePort80["Port: 80/8080"]
            end

            subgraph AltWeb["altweb"]
                AltApache["Apache HTTP\n(Alternate SPN)"]
            end

            subgraph LinuxClient["linuxclient"]
                TestRunner["テストランナー"]
                RepoMount["/repo\n(ソースマウント)"]
            end

            SharedVol["/SHARED\n(共有ボリューム)"]
        end
    end

    KDC --> SharedVol
    Apache --> SharedVol
    AltWeb --> SharedVol
    LinuxClient --> SharedVol

    LinuxClient -->|"Kerberos"| KDC
    LinuxClient -->|"HTTP/NTLM"| Apache
    LinuxClient -->|"HTTP/Kerberos"| AltWeb

    Apache -->|"認証"| KDC
    AltWeb -->|"認証"| KDC
```

## Helix 分散テストプラットフォーム構成

```mermaid
flowchart TB
    subgraph HelixPlatform["Helix Platform"]
        Controller["Helix Controller"]

        subgraph Windows["Windows Queues"]
            Win10x64["Windows.10.Amd64.Open"]
            Win11x64["Windows.11.Amd64.Client.Open"]
            Win11ARM64["Windows.11.Arm64.Open"]
            WinServer["Windows.Server2025.Amd64.Open"]
            WinCET["Windows.11.Amd64.Cet.Open"]
        end

        subgraph Linux["Linux Queues"]
            Ubuntu["Ubuntu.2204-2604"]
            Debian["Debian.12-13"]
            Fedora["Fedora.42-43"]
            Alpine["Alpine.3.23-edge"]
            AzureLinux["AzureLinux.3"]
        end

        subgraph macOS["macOS Queues"]
            MacARM["OSX.13-26.Arm64.Open"]
            MacX64["OSX.13-15.Amd64.Open"]
            MaciOS["OSX.*.Iphone.Open"]
            MacTV["OSX.*.AppleTV.Open"]
        end

        subgraph Mobile["Mobile Queues"]
            Android["Android.21-35"]
            AndroidWin["Windows.*.Android.Open"]
        end

        subgraph WASM["WASM Queues"]
            WasmUbuntu["Ubuntu.*-helix-webassembly"]
        end
    end

    Controller --> Windows
    Controller --> Linux
    Controller --> macOS
    Controller --> Mobile
    Controller --> WASM
```

## 開発コンテナ構成

```mermaid
flowchart TB
    subgraph DevContainers["Dev Containers"]
        subgraph BaseImage["ベースイメージ"]
            DotnetBase["mcr.microsoft.com/devcontainers/dotnet:8.0-noble"]
        end

        subgraph Default["Default Container"]
            DefaultTools["clang, cmake, lldb, llvm\nninja-build, libssl-dev\nlibkrb5-dev, libicu-dev"]
        end

        subgraph WasmContainer["WASM Container"]
            WasmTools["Node.js LTS\nV8 Engine 10.8.168\nChromium/Firefox deps"]
        end

        subgraph AndroidContainer["Android Container"]
            AndroidTools["OpenJDK 17\nAndroid NDK r27c\nAndroid SDK API 35\nEmulator x86_64"]
        end
    end

    DotnetBase --> Default
    DotnetBase --> WasmContainer
    DotnetBase --> AndroidContainer
```

## アーティファクト管理フロー

```mermaid
flowchart LR
    subgraph Build["ビルドプロセス"]
        Source["ソースコード"]
        Compile["コンパイル"]
        Test["テスト"]
        Package["パッケージング"]
    end

    subgraph Artifacts["アーティファクト"]
        Binaries["バイナリ"]
        TestResults["テスト結果"]
        NuGetPkg["NuGet\nパッケージ"]
        DockerImg["Docker\nイメージ"]
    end

    subgraph Storage["ストレージ"]
        AzureBlob2[("Azure Blob")]
        NuGet2[("NuGet.org")]
        MCR2[("MCR")]
    end

    Source --> Compile
    Compile --> Test
    Test --> Package

    Compile --> Binaries
    Test --> TestResults
    Package --> NuGetPkg
    Package --> DockerImg

    Binaries --> AzureBlob2
    TestResults --> AzureBlob2
    NuGetPkg --> NuGet2
    DockerImg --> MCR2
```

## ネットワークセキュリティ構成

```mermaid
flowchart TB
    subgraph External["外部アクセス"]
        Internet["インターネット"]
    end

    subgraph Security["セキュリティ層"]
        GitHub_Auth["GitHub 認証"]
        AzDO_Auth["Azure DevOps 認証"]
        Helix_Token["Helix アクセストークン"]
    end

    subgraph Internal["内部サービス"]
        Pipeline["パイプライン"]
        Agents["ビルドエージェント"]
        TestAgents["テストエージェント"]
    end

    Internet --> GitHub_Auth
    Internet --> AzDO_Auth
    GitHub_Auth --> Pipeline
    AzDO_Auth --> Pipeline
    Pipeline --> Agents
    Pipeline -->|"Internal Only"| Helix_Token
    Helix_Token --> TestAgents
```
