# インフラ設計書

## 概要

本ドキュメントは、.NET Runtime プロジェクトのインフラストラクチャ構成を記述します。本プロジェクトは、.NETランタイム、ライブラリ、および共有ホスト（dotnet）のビルド・テスト基盤として、Azure DevOps パイプライン、GitHub Actions、Helix分散テストプラットフォーム、およびDocker コンテナ環境を活用したCI/CDシステムを採用しています。

## システム構成

### 全体構成

本プロジェクトのインフラストラクチャは以下の主要コンポーネントで構成されます：

1. **CI/CD基盤**: Azure DevOps Pipelines（メインCI/CD）および GitHub Actions（補助ワークフロー）
2. **分散テストプラットフォーム**: Microsoft Helix
3. **コンテナ環境**: Docker/Docker Compose（開発・テスト用）
4. **ソースコード管理**: GitHub（dotnet/runtime リポジトリ）
5. **アーティファクト管理**: Azure Blob Storage、NuGet

### サーバー構成

本プロジェクトはクラウドネイティブなCI/CD基盤を採用しており、物理サーバーではなくマネージドサービスを使用しています。

| サーバー種別 | 役割 | スペック | 台数/規模 |
| --- | --- | --- | --- |
| Azure DevOps Agent Pool | CI/CDビルドエージェント | マネージドサービス | 自動スケーリング |
| Helix Agent | 分散テスト実行 | 各種OS/アーキテクチャ | 大規模プール |
| GitHub Actions Runner | 補助ワークフロー実行 | GitHub-hosted | オンデマンド |
| Container Registry | Dockerイメージ管理 | mcr.microsoft.com | マネージド |

### ネットワーク構成

#### CI/CDパイプラインネットワーク

```
[GitHub Repository]
       |
       v
[Azure DevOps Pipelines] <---> [Helix Distributed Test Platform]
       |                              |
       v                              v
[Build Agents]                 [Helix Test Agents]
       |                        (Windows/Linux/macOS)
       v
[Azure Blob Storage / NuGet]
```

#### テスト用Dockerネットワーク（Enterprise Tests）

```
Network: linux.contoso.com
+-------------------+
| kdc (Kerberos)    |
| - Port 88 TCP/UDP |
+-------------------+
       |
       v
+-------------------+    +-------------------+
| apacheweb         |    | altweb            |
| - Port 80/8080    |    | (Alt port/SPN)    |
+-------------------+    +-------------------+
       |                        |
       v                        v
+-------------------+
| linuxclient       |
| - Test executor   |
+-------------------+
```

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| .NET SDK | 11.0.100-alpha.1 | ビルド・開発環境 |
| Docker | 最新安定版 | コンテナ実行環境 |
| Docker Compose | v3.7 | マルチコンテナオーケストレーション |
| Clang/LLVM | ディストリビューション標準 | ネイティブコードビルド |
| CMake | ディストリビューション標準 | ネイティブビルドシステム |
| Ninja | ディストリビューション標準 | 高速ビルドシステム |
| Apache HTTP Server | 2.x | テスト用Webサーバー |
| Kerberos (krb5) | ディストリビューション標準 | 認証テスト用KDC |
| OpenSSL | ディストリビューション標準 | TLS/SSL処理 |
| Node.js (LTS) | LTS版 | WebAssembly テスト |
| V8 Engine | 10.8.168 | WebAssembly デバッガテスト |
| Android NDK | r27c | Android ビルド |
| Android SDK | API Level 35 | Android 開発・テスト |
| msquic | main branch | HTTP/3 テスト（ASAN有効） |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| Azure DevOps | CI/CDパイプライン | HTTPS API |
| Microsoft Helix | 分散テスト実行 | Azure DevOps 連携 |
| GitHub | ソースコード管理・PR/Issue | HTTPS (git) |
| GitHub Actions | 補助ワークフロー | GitHub イベント駆動 |
| Azure Blob Storage | ビルドアーティファクト保存 | HTTPS |
| NuGet.org | パッケージ配布 | HTTPS |
| mcr.microsoft.com | コンテナイメージレジストリ | HTTPS |
| Google Cloud (Android SDK) | Android SDKダウンロード | HTTPS |

## スケーリング設計

### ビルドパイプラインスケーリング

- **Azure DevOps Agent Pool**: 自動スケーリングにより、ビルド負荷に応じてエージェント数を動的に調整
- **バッチビルド制御**: `batch: true` 設定により、ビルド実行中の追加プッシュを待機し、変更を集約してビルド
- **並列ビルド**: プラットフォームマトリクスによる複数OS/アーキテクチャの並列ビルド

### Helix テストスケーリング

大規模な分散テストプラットフォームで以下のキューをサポート：

**macOS**:
- ARM64: OSX.13-26 (Ventura - Sequoia)
- x64: OSX.13-15 (Ventura - Sequoia)
- iOS/tvOS シミュレータ・デバイス

**Linux**:
- x64: Ubuntu 22.04-26.04, Debian 12-13, Fedora 42-43, openSUSE 15.5-16.0, CentOS Stream 9-10, Azure Linux 3.0
- ARM32/ARM64: Debian, Ubuntu
- musl (Alpine): x64, ARM32, ARM64 (Alpine 3.23-edge)

**Windows**:
- x64: Windows 10, Windows 11, Windows Server 2019-2025
- ARM64: Windows 10, Windows 11
- CET対応: Windows 11 (Control-flow Enforcement Technology)

**Android**:
- API Level 21-35
- ARM/ARM64/x86/x64

**WebAssembly**:
- Ubuntu 22.04-24.04 ベースのブラウザ環境

## 可用性設計

### CI/CD冗長構成

- **Azure DevOps**: マネージドサービスによる高可用性
- **GitHub**: GitHub Enterprise Cloud による冗長構成
- **ビルドキャッシュ**: 失敗時のリトライ機能

### スケジュールビルド

```yaml
schedules:
  - cron: "0 8,20 * * *"  # UTC 8:00 と 20:00 (PST 0:00 と 12:00)
    displayName: Runtime default schedule
    branches:
      include:
      - main
    always: false  # 前回成功以降に変更がある場合のみ実行
```

### テスト環境分離

- **Docker コンテナ分離**: 各テストコンポーネントは独立したコンテナで実行
- **ネットワーク分離**: 専用の Docker ネットワーク（linux.contoso.com）でテスト環境を隔離
- **ボリュームマウント**: 共有データは `/SHARED` ボリュームで制御

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| ソースコード | Git リポジトリ（GitHub） | リアルタイム | 永続 |
| ビルドアーティファクト | Azure Blob Storage | ビルド毎 | リリースサイクルに依存 |
| NuGet パッケージ | NuGet.org | リリース毎 | 永続 |
| コンテナイメージ | mcr.microsoft.com | ビルド毎 | バージョン管理 |
| パイプライン定義 | Git（eng/pipelines/） | コミット毎 | 永続 |

## 監視設計

### パイプライン監視

- **Azure DevOps ダッシュボード**: ビルドステータス、成功率、実行時間の可視化
- **ビルドバッジ**: README.md での公開ビルドステータス表示
  ```
  [![Build Status](https://dev.azure.com/dnceng-public/public/_apis/build/status/dotnet/runtime/runtime?branchName=main)]
  ```

### Helix テスト監視

- **Helix API**: テスト結果の収集と集計
- **Azure DevOps 連携**: テスト結果のパイプラインへの統合

### GitHub Actions 監視

- **ワークフロー実行履歴**: GitHub UI での実行状況確認
- **PR ステータスチェック**: マージ前の必須チェック

## 開発環境構成

### Dev Container 設定

4つの開発コンテナ環境を提供：

| コンテナ | ベースイメージ | 用途 |
| --- | --- | --- |
| Default | mcr.microsoft.com/devcontainers/dotnet:8.0-noble | 標準開発環境 |
| WASM | 同上 + Node.js + V8 + Chromium/Firefox deps | WebAssembly 開発 |
| WASM MultiThreaded | 同上 | マルチスレッドWebAssembly |
| Android | 同上 + Android NDK/SDK | Android 開発 |

### 共通インストールパッケージ

```
clang, cmake, cpio, build-essential, python3, curl, git,
lldb, llvm, liblldb-dev, libunwind8, libunwind8-dev,
gettext, libicu-dev, liblttng-ust-dev, libssl-dev,
libkrb5-dev, ninja-build
```

## 備考

### サポート対象プラットフォーム

本プロジェクトは以下のプラットフォームをターゲットとしてビルド・テストを実施：

- **Windows**: x64, x86, ARM64
- **Linux**: x64, ARM, ARM64, musl (Alpine)
- **macOS**: x64, ARM64
- **iOS/tvOS**: シミュレータ・デバイス
- **Android**: ARM, ARM64, x86, x64
- **WebAssembly**: ブラウザ環境

### 特殊なテスト構成

- **Stress Tests**: HttpStress, SslStress - 長時間負荷テスト用Docker Compose構成
- **Enterprise Tests**: Kerberos/NTLM認証テスト用のKDC/Apache環境
- **Native AOT**: クロスコンパイル用Docker環境（x64-arm64）

### セキュリティ考慮事項

- **ASAN (Address Sanitizer)**: msquic のデバッグビルドで有効化
- **Helix アクセストークン**: 内部プロジェクト用のセキュアトークン管理
- **フォークからのワークフロー制限**: セキュリティのため、フォークでのワークフロー実行を制限
