---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **HSTS対応状況**：明示的な実装が確認できず
  2. **監査ログの保持期間**：アプリケーション依存のため具体的な設定が不明
  3. **セッション有効期限の具体値**：OpenSSL設定依存で固定値なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/native/libs/System.Security.Cryptography.Native/pal_ssl.h`
- E-02: `src/native/libs/System.Security.Cryptography.Native/pal_ssl.c`
- E-03: `src/native/libs/System.Security.Cryptography.Native/pal_evp_cipher.c`
- E-04: `src/native/libs/System.Security.Cryptography.Native/pal_hmac.c`
- E-05: `src/native/libs/System.Security.Cryptography.Native/pal_evp.h`
- E-06: `src/native/libs/System.Security.Cryptography.Native/pal_x509.h`
- E-07: `src/native/libs/System.Security.Cryptography.Native/pal_evp_pkey.h`
- E-08: `src/native/libs/System.Security.Cryptography.Native/openssl.h`
- E-09: `src/native/libs/System.Net.Security.Native/pal_gssapi.h`
- E-10: `src/native/libs/System.Native/pal_random.c`
- E-11: `src/native/libs/System.Security.Cryptography.Native.Apple/pal_random.c`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GSS-APIを通じてSPNEGO/Kerberos/NTLMをサポート | E-09 | ○ |
| C-02 | TLS 1.0/1.1/1.2/1.3プロトコルをサポート | E-01 (SslProtocols enum) | ○ |
| C-03 | セッションキャッシング機能の提供 | E-01 (CryptoNative_SslCtxSetCaching) | ○ |
| C-04 | X.509証明書チェーン検証機能 | E-06 | ○ |
| C-05 | 証明書失効確認（EndCertificateOnly, EntireChain, ExcludeRoot） | E-06 (X509RevocationFlag enum) | ○ |
| C-06 | ホスト名検証機能 | E-08 (CryptoNative_CheckX509Hostname) | ○ |
| C-07 | IPアドレス検証機能 | E-08 (CryptoNative_CheckX509IpAddress) | ○ |
| C-08 | OCSP検証機能 | E-06 (CryptoNative_X509ChainVerifyOcsp) | ○ |
| C-09 | AES-128/192/256暗号化サポート | E-03 (EvpAes*関数群) | ○ |
| C-10 | 3DES暗号化サポート | E-03 (EvpDes3*関数群) | ○ |
| C-11 | ChaCha20-Poly1305サポート | E-03 (CryptoNative_EvpChaCha20Poly1305) | ○ |
| C-12 | GCM/CCMモードサポート | E-03 (EvpAes*Gcm, EvpAes*Ccm関数) | ○ |
| C-13 | RSA/DSA/ECCサポート | E-07 (PalPKeyFamilyId enum) | ○ |
| C-14 | ML-KEM/SLH-DSA/ML-DSAサポート（PQC） | E-07 (PalPKeyFamilyId enum) | ○ |
| C-15 | MD5ハッシュサポート | E-05 (CryptoNative_EvpMd5) | ○ |
| C-16 | SHA-1/256/384/512ハッシュサポート | E-05 (CryptoNative_EvpSha*関数群) | ○ |
| C-17 | SHA3-256/384/512サポート | E-05 (CryptoNative_EvpSha3_*関数群) | ○ |
| C-18 | SHAKE128/256サポート | E-05 (CryptoNative_EvpShake*関数群) | ○ |
| C-19 | PBKDF2鍵導出サポート | E-05 (CryptoNative_Pbkdf2) | ○ |
| C-20 | HMAC機能サポート | E-04 (HmacCreate, HmacUpdate, HmacFinal等) | ○ |
| C-21 | 暗号学的に安全な乱数生成 | E-10, E-11 | ○ |
| C-22 | 非暗号学的乱数生成 | E-10 (SystemNative_GetNonCryptographicallySecureRandomBytes) | ○ |
| C-23 | OpenSSLベースの実装 | E-01, E-02, E-03 (opensslshim.h使用) | ○ |
| C-24 | Apple CommonCryptoサポート | E-11 (CommonCrypto/CommonRandom.h使用) | ○ |
| C-25 | 入力パラメータのassertによる検証 | E-04 (assert文の使用) | ○ |
| C-26 | ERR_clear_error()によるエラーキュークリア | E-03, E-04 | ○ |
| C-27 | 暗号化ポリシー設定機能 | E-01 (EncryptionPolicy enum) | ○ |
| C-28 | ALPNサポート | E-01 (CryptoNative_SslSetAlpnProtos) | ○ |
| C-29 | OCSP Staplingサポート | E-01 (CryptoNative_SslStapleOcsp) | ○ |
| C-30 | TLSキーログコールバック | E-01 (CryptoNative_SslCtxSetKeylogCallback) | ○ |
| C-31 | 証明書エラーコード定義 | E-06 (X509VerifyStatusCode enum) | ○ |
| C-32 | RC2暗号サポート | E-03 (CryptoNative_EvpRC2*) | ○ |
| C-33 | HSTS対応 | **根拠なし** | △ |
| C-34 | 監査ログの保持期間 | **根拠なし（アプリ依存）** | △ |
| C-35 | セッション有効期限の具体値 | **根拠なし（OpenSSL依存）** | △ |

## 4) 不足情報（Unknown / Missing）
- **HSTS対応**: HTTPレイヤーの実装はこのランタイムライブラリの範囲外である可能性。上位のASP.NET Core等で実装されていると推測
  - 候補：`src/libraries/System.Net.Http/` / ASP.NET Coreリポジトリ / HTTPミドルウェア実装
- **監査ログ保持期間**: ランタイムライブラリとしてはログ出力の仕組みを提供するのみで、保持期間はアプリケーション実装に依存
  - 候補：アプリケーション設定ファイル / ログ管理システム設定
- **セッション有効期限**: OpenSSLのデフォルト設定に依存し、アプリケーションからSSL_CTX_set_timeout等で設定可能
  - 候補：OpenSSLドキュメント / アプリケーション設定

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 暗号アルゴリズム選択 - コードで明確に定義されている
- **0（低リスク）**: TLSプロトコルバージョン - 明示的にenumで定義
- **0（低リスク）**: 乱数生成 - プラットフォーム固有の安全な実装を使用
- **1（中リスク）**: 非推奨アルゴリズム（SSL2/3, MD5, DES）の存在 - レガシー互換性のため残存
- **1（中リスク）**: HSTS未確認 - 上位層での実装確認が必要
- **0（低リスク）**: 入力検証 - assert文とエラーチェックが一貫して実装

## 6) レビュアーチェックリスト（最小）
- [ ] 非推奨アルゴリズム（SSL2/3, MD5, SHA-1, DES, RC2）がデフォルトで無効化されているか確認
- [ ] TLS 1.2以上がデフォルトプロトコルとして設定されているか確認
- [ ] HSTS対応が上位層（ASP.NET Core等）で実装されているか確認
- [ ] 監査ログの具体的な実装がアプリケーション層で適切に行われているか確認
- [ ] PQCアルゴリズムの実装状況と互換性を確認
- [ ] OpenSSLバージョン依存の機能が適切にフォールバックされているか確認
