---
generated_at: 2026-01-30 14:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：テスト方針書.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **カバレッジ目標値**：明示的な全体目標値の根拠なし
  2. **テスト命名規則の推奨形式**：コーディング規約での明示的定義の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/testing/tests.props` - テストフレームワーク設定（XUnit指定）
- E-02: `eng/testing/tests.targets` - テスト実行ターゲット定義
- E-03: `eng/testing/xunit/xunit.props` - XUnitパッケージ参照（xunit.core 2.9.x）
- E-04: `eng/testing/xunit/xunit.targets` - XUnit実行設定
- E-05: `eng/testing/coverage.targets` - Coverletカバレッジ設定
- E-06: `src/libraries/Common/tests/TestUtilities/TestUtilities.csproj` - テストユーティリティ
- E-07: `eng/pipelines/libraries/helix.yml` - Helix分散テスト設定
- E-08: `eng/pipelines/coreclr/jitstress.yml` - JITストレステストパイプライン
- E-09: `eng/pipelines/coreclr/gcstress0x3-gcstress0xc.yml` - GCストレステストパイプライン
- E-10: `Directory.Build.props` - プロジェクト全体設定（TFM、テスト判定）
- E-11: `CONTRIBUTING.md` - コントリビューションガイド（テスト方針含む）
- E-12: `eng/Version.Details.xml` - 依存パッケージバージョン定義
- E-13: `.github/workflows/labeler-promote.yml` - GitHub Actionsワークフロー
- E-14: `src/native/managed/cdac/tests/Microsoft.Diagnostics.DataContractReader.Tests.csproj` - テストプロジェクト例（Moq使用）
- E-15: `.CodeQL.yml` - CodeQL解析設定
- E-16: `eng/pipelines/runtime-wasm.yml` - WebAssemblyテストパイプライン
- E-17: `eng/pipelines/runtime-official.yml` - 公式ビルドパイプライン
- E-18: `eng/testing/tests.mobile.targets` - モバイルテスト設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テストフレームワークはXUnitを使用 | E-01, E-03 | ○ |
| C-02 | XUnitバージョンは2.9.x | E-03, E-12 | ○ |
| C-03 | Microsoft.DotNet.XUnitExtensionsを使用 | E-03, E-06 | ○ |
| C-04 | Coverletでカバレッジ収集 | E-05, E-03 | ○ |
| C-05 | ReportGeneratorでレポート生成 | E-05 | ○ |
| C-06 | Moqをモックライブラリとして使用 | E-14 | ○ |
| C-07 | Azure DevOpsでCI/CD実行 | E-07, E-17 | ○ |
| C-08 | Helixで分散テスト実行 | E-07 | ○ |
| C-09 | GitHub Actionsで補助タスク実行 | E-13 | ○ |
| C-10 | innerloop/outerloopテストスコープ | E-02, E-07 | ○ |
| C-11 | JITストレステストの存在 | E-08 | ○ |
| C-12 | GCストレステストの存在 | E-09 | ○ |
| C-13 | TestUtilitiesプロジェクトの存在 | E-06 | ○ |
| C-14 | PlatformDetection機能 | E-06 | ○ |
| C-15 | FileCleanupTestBase提供 | E-06 | ○ |
| C-16 | CodeQL解析の実行 | E-15 | ○ |
| C-17 | WebAssemblyテストサポート | E-16, E-18 | ○ |
| C-18 | runtime-assetsリポジトリでテストデータ管理 | E-12 | ○ |
| C-19 | テストプロジェクト命名規則（.Tests/.UnitTests） | E-10 | ○ |
| C-20 | failing/OuterLoop/IgnoreForCIカテゴリ | E-02 | ○ |
| C-21 | Windows/Linux/macOSサポート | E-10, E-02 | ○ |
| C-22 | Android/iOS/WebAssemblyモバイルサポート | E-10, E-18 | ○ |
| C-23 | Microsoft.DotNet.Helix.Sdk使用 | E-12 | ○ |
| C-24 | dotnet testコマンドでの実行 | E-04 | ○ |
| C-25 | Coverage=trueでカバレッジ有効化 | E-05 | ○ |
| C-26 | ConditionalFact/ConditionalTheory属性 | E-03, E-06 | ○ |
| C-27 | カバレッジ目標値（明示的な数値目標） | **根拠なし** | △ |
| C-28 | テストメソッド命名規則の推奨形式 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **カバレッジ目標値**: プロジェクト全体での明示的なカバレッジ目標パーセンテージは設定ファイルやドキュメントで確認できなかった。各コンポーネント固有の目標が存在する可能性があるが、一元的な定義は見つからなかった。
  - 候補: `eng/` 配下の追加設定ファイル / チーム内部ドキュメント / ADO Wiki

- **テスト命名規則**: CONTRIBUTING.mdにテスト追加の言及はあるが、具体的なテストメソッド命名形式の規約は確認できなかった。
  - 候補: `docs/coding-guidelines/` / 各Areaの内部ガイドライン

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: テストフレームワーク・ツールの主張 - 設定ファイルで明確に確認可能
- **0（低リスク）**: CI/CD連携 - パイプラインYAMLで検証済み
- **1（中リスク）**: カバレッジ目標 - 数値目標の根拠がないため、実際の運用方針との乖離の可能性あり
- **0（低リスク）**: プラットフォームサポート - Directory.Build.propsで明示的に定義

## 6) レビュアーチェックリスト（最小）
- [ ] XUnitバージョン（2.9.x）が最新のVersion.Details.xmlと一致しているか確認
- [ ] Helixキュー構成が実際の運用と一致しているか確認
- [ ] カバレッジ目標について、チーム内での実際の運用方針を確認
- [ ] テスト命名規則について、既存テストコードのパターンと照合
- [ ] モバイルプラットフォーム（Android/iOS）のテストランナー設定が最新か確認
- [ ] セキュリティテスト（CodeQL）の設定が最新のGitHub推奨設定に準拠しているか確認
