# テスト方針書

## 概要

本ドキュメントは、.NET Runtime（dotnet/runtime）プロジェクトにおけるテスト方針を定義する。本プロジェクトはMicrosoftの公式.NETランタイムリポジトリであり、CoreCLR、Mono、ライブラリ、インストーラー等の主要コンポーネントから構成される大規模なオープンソースプロジェクトである。テストはXUnitフレームワークを中心に構築され、Azure DevOpsおよびHelixインフラストラクチャを使用した分散テスト実行環境で実施される。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 個々のメソッド・クラスの機能検証 | 開発者 |
| 結合テスト | コンポーネント間の連携検証 | 開発者・QA |
| システムテスト | ランタイム全体の動作検証（CoreCLR/Mono/Libraries統合） | CI/CDパイプライン |
| 受入テスト | APIの互換性・リグレッション検証 | コミュニティ・Microsoft QAチーム |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | 各ライブラリ・ランタイム機能の正常動作確認 | PRマージ前（Innerloop） |
| 性能テスト | ベンチマーク・プロファイリング（SuperPMI、PGO） | 定期実行・リリース前 |
| セキュリティテスト | セキュリティ脆弱性スキャン、CodeQL解析 | 毎ビルド（CodeQL Workflow） |
| ストレステスト | GCストレス、JITストレス、メモリ負荷テスト | Outerloopパイプライン |
| 互換性テスト | APIBreaking Change検証、Trimming Tests | PR・定期実行 |
| クロスプラットフォームテスト | 複数OS/アーキテクチャでの動作確認 | Helixによる分散実行 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| ローカル開発環境 | 開発者による単体テスト実行 | Windows/macOS/Linux、.NET SDK |
| Azure DevOps | CI/CDパイプライン実行 | Azure Pipelines |
| Helix | 分散テスト実行プラットフォーム | 複数OS/アーキテクチャのテストキュー |
| GitHub Actions | ラベリング、マークダウンリント等の補助タスク | GitHub Hosted Runners |

### サポートプラットフォーム

| OS | アーキテクチャ | 備考 |
| --- | --- | --- |
| Windows | x64, x86, arm64 | メイン開発プラットフォーム |
| Linux | x64, arm64, arm32 | Ubuntu、Alpine（musl）等 |
| macOS | x64, arm64 | Apple Silicon対応 |
| Android | arm64, arm32, x64 | モバイルランタイム |
| iOS/tvOS | arm64 | AppleAppBuilder経由 |
| WebAssembly | wasm | Browser/WASI対応 |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| XUnit | 単体・結合テストフレームワーク | 2.9.x |
| Microsoft.DotNet.XUnitExtensions | XUnit拡張（条件付きテスト等） | 11.0.0-beta |
| Microsoft.DotNet.XUnitAssert | AOT互換アサーションライブラリ | 2.9.3-beta |
| Microsoft.NET.Test.Sdk | VSTest統合 | 最新 |
| Coverlet | コードカバレッジ収集 | 最新 |
| ReportGenerator | カバレッジレポート生成 | 最新 |
| Moq | モックライブラリ | 最新 |
| XHarness | モバイル/WebAssemblyテスト実行 | 最新 |
| Microsoft.DotNet.Helix.Sdk | Helix分散テスト | 11.0.0-beta |
| CodeQL | セキュリティ静的解析 | GitHub Actions統合 |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | プロジェクト固有の目標（明示的な全体目標は設定されていない） |
| 分岐カバレッジ | プロジェクト固有の目標（明示的な全体目標は設定されていない） |

### カバレッジ収集方式

- Coverletを使用したOpenCover形式でのカバレッジ収集
- テスト対象アセンブリ単位でのフィルタリング
- `Coverage=true`ビルドプロパティで有効化
- ReportGeneratorによるHTML形式レポート生成

## テストデータ

### テストデータ準備方針

1. **runtime-assetsリポジトリ**: 大容量テストデータ（暗号証明書、圧縮ファイル、Unicode データ等）は専用リポジトリで管理
2. **インラインテストデータ**: 小規模データはテストコード内に直接記述
3. **テストファクトリ/ヘルパー**: `TestUtilities`プロジェクトで共通テストユーティリティを提供
   - `PlatformDetection`: プラットフォーム固有条件の検出
   - `AssertExtensions`: 拡張アサーション
   - `FileCleanupTestBase`: ファイルテスト用基底クラス
   - `RetryHelper`: リトライ機能付きテストヘルパー

### テストデータパッケージ

| パッケージ | 用途 |
| --- | --- |
| System.Net.TestData | ネットワークテスト用データ |
| System.Security.Cryptography.X509Certificates.TestData | 証明書テストデータ |
| System.IO.Compression.TestData | 圧縮テストデータ |
| System.Text.RegularExpressions.TestData | 正規表現テストデータ |

## 不具合管理

### 不具合管理フロー

1. **Issue起票**: GitHub Issuesでバグレポートを作成（テンプレート使用）
2. **ラベリング**: 自動ラベラー（issue-labeler）によるarea-*ラベル付与
3. **トリアージ**: Area Ownersによる優先度設定
4. **修正**: PRを作成し、再現テストを含める
5. **検証**: CI/CDパイプラインでの自動検証
6. **クローズ**: マージ後に自動クローズ

### 既知の不具合管理

- `failing`カテゴリによる既知失敗テストの除外
- `OuterLoop`カテゴリによる長時間テストの分離
- `IgnoreForCI`カテゴリによるCI除外テストの管理

## CI/CD連携

### パイプライン構成

| パイプライン | 目的 | トリガー |
| --- | --- | --- |
| runtime-official.yml | 公式リリースビルド | スケジュール・手動 |
| coreclr/ci.yml | CoreCLR CI | PR・main push |
| libraries/helix.yml | ライブラリHelix テスト | PRマージ後 |
| runtime-wasm.yml | WebAssemblyテスト | PR（wasm関連変更） |
| runtime-sanitized.yml | サニタイザー付きビルド | 定期実行 |

### テストスコープ

| スコープ | 説明 | 実行条件 |
| --- | --- | --- |
| innerloop | 高速フィードバック用必須テスト | すべてのPR |
| outerloop | 追加検証テスト（長時間） | マージ後・定期実行 |
| all | 全テスト | リリース前検証 |

### Helix分散テスト

- **テストキュー**: OS/アーキテクチャごとに専用キューを構成
- **並列実行**: 複数マシンでの並列テスト実行
- **結果集約**: Azure DevOpsへの結果レポート統合
- **リトライ**: 一時的失敗に対する自動リトライ

### ストレステストパイプライン

| パイプライン | 内容 |
| --- | --- |
| jitstress.yml | JITストレスモード |
| gcstress0x3-gcstress0xc.yml | GCストレステスト |
| gc-longrunning.yml | 長時間GCテスト |
| libraries-jitstress.yml | ライブラリJITストレス |

## テスト実行コマンド

### ローカル実行

```bash
# ビルドとテスト実行
./build.sh -subset libs -test

# 特定ライブラリのテスト
dotnet test src/libraries/System.Text.Json/tests/System.Text.Json.Tests.csproj

# カバレッジ付きテスト
dotnet test -p:Coverage=true
```

### カテゴリ指定

```bash
# OuterLoopテストを含める
dotnet test -p:TestScope=outerloop

# 特定カテゴリを除外
dotnet test -p:WithoutCategories=failing
```

## 備考

### テスト命名規則

- テストプロジェクト: `{AssemblyName}.Tests.csproj` または `{AssemblyName}.UnitTests.csproj`
- テストクラス: `{対象クラス名}Tests`
- テストメソッド: `{メソッド名}_{条件}_{期待結果}` 形式を推奨

### テスト実行時の注意事項

1. **プラットフォーム依存テスト**: `[ConditionalFact]`/`[ConditionalTheory]`属性を使用
2. **リソース解放**: `FileCleanupTestBase`を継承し、テスト後のクリーンアップを保証
3. **並列実行**: XUnitのデフォルト並列実行に対応したテスト設計
4. **タイムアウト**: 長時間テストは`[OuterLoop]`属性でマーク

### 参考ドキュメント

- [Workflow Instructions](../../workflow/README.md)
- [PR Guide](../../workflow/ci/pr-guide.md)
- [Testing Guidelines](../../coding-guidelines/)
- [Area Owners](../../area-owners.md)
