# ER図

## 概要

本ドキュメントは、.NET RuntimeプロジェクトのデータアクセスAPIテストで使用されるテーブル構造をER図として視覚化したものである。

これらのテーブルは独立したテスト用テーブルであり、テーブル間のリレーションシップは存在しない。各テーブルは個別のテストケースで動的に作成・削除される。

## テスト用テーブル構造

```mermaid
erDiagram
    SomeTable_OdbcSmoke {
        TINYINT SomeByte
        BIT SomeBoolean
        DATE SomeDate
        DATETIME SomeDateTime
        DECIMAL_10_5 SomeDecimal
        FLOAT SomeDouble
        REAL SomeFloat
        UNIQUEIDENTIFIER SomeGuid
        INT SomeInt32
        BIGINT SomeInt64
        NVARCHAR_100 SomeString
    }

    SomeTable_OdbcReader_String {
        NVARCHAR_100 SomeString
    }

    SomeTable_OdbcReader_IntString {
        INT SomeInt32
        NVARCHAR_100 SomeString
    }

    SomeTable_OdbcReader_BigInt {
        BIGINT SomeInt64
    }

    CustomerTable_OleDb {
        INT CustomerID
        NVARCHAR_40 CustomerName
        FLOAT SingleAmount
        REAL RealAmount
        DATETIME DateChecked
    }

    PersonTable_OleDb {
        NVARCHAR_5 Firstname
        NVARCHAR_40 Lastname
        NVARCHAR_30 Nickname
    }

    PlantTable_OleDb {
        NVARCHAR_5 Firstname
        INT NumPlants
    }
```

## テーブル関係図（論理構造）

```mermaid
graph TB
    subgraph "System.Data.Odbc テスト"
        A[SomeTable<br/>Smoke Test]
        B[SomeTable<br/>Reader Test<br/>String]
        C[SomeTable<br/>Reader Test<br/>IntString]
        D[SomeTable<br/>Reader Test<br/>BigInt]
    end

    subgraph "System.Data.OleDb テスト"
        E[CustomerTable<br/>DataReader Test]
        F[PersonTable<br/>DataAdapter Test]
        G[PlantTable<br/>Command Test]
    end

    subgraph "テスト目的"
        H((データ型<br/>マッピング検証))
        I((CRUD操作<br/>検証))
        J((DataAdapter<br/>機能検証))
    end

    A --> H
    B --> H
    C --> H
    D --> H
    E --> I
    F --> J
    G --> I
```

## データ型マッピング一覧

```mermaid
graph LR
    subgraph "SQL データ型"
        S1[TINYINT]
        S2[BIT]
        S3[DATE]
        S4[DATETIME]
        S5[DECIMAL]
        S6[FLOAT]
        S7[REAL]
        S8[UNIQUEIDENTIFIER]
        S9[INT]
        S10[BIGINT]
        S11[NVARCHAR]
    end

    subgraph ".NET データ型"
        N1[Byte]
        N2[Boolean]
        N3[DateTime]
        N4[DateTime]
        N5[Decimal]
        N6[Double]
        N7[Single/Float]
        N8[Guid]
        N9[Int32]
        N10[Int64]
        N11[String]
    end

    S1 --> N1
    S2 --> N2
    S3 --> N3
    S4 --> N4
    S5 --> N5
    S6 --> N6
    S7 --> N7
    S8 --> N8
    S9 --> N9
    S10 --> N10
    S11 --> N11
```

## 備考

- 上記のER図で示されるテーブルには**主キー（PK）や外部キー（FK）は定義されていない**
- 各テーブルは**リレーションシップを持たない独立したエンティティ**である
- これらはAPIの動作検証を目的とした**テスト用一時テーブル**であり、本番環境でのデータモデルとして設計されたものではない
- テーブル名は実際のテストコードでは動的に生成される（例: `GetTableName(memberName)`）
