# データベース設計書

## 概要

本ドキュメントは、.NET Runtimeプロジェクトにおけるデータベース関連コードの設計を記載したものである。

.NET Runtimeはフレームワーク自体のソースコードであり、アプリケーション固有の永続的なデータベーススキーマは存在しない。しかし、データアクセスAPI（System.Data.Odbc、System.Data.OleDb）の単体テストにおいて、テスト用の一時テーブル定義が使用されている。本ドキュメントでは、これらのテスト用テーブル定義を文書化する。

## テーブル一覧

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| SomeTable | テスト汎用エンティティ | System.Data.Odbc APIのテスト用テーブル。各種データ型のテストに使用 |
| CustomerTable | 顧客テストエンティティ | System.Data.OleDb APIのテスト用テーブル。CRUD操作のテストに使用 |
| PersonTable | 個人情報テストエンティティ | System.Data.OleDbのDataAdapterテスト用テーブル |

## 各テーブル定義

### 1. SomeTable（ODBC Smoke Test用）

ODBC APIの基本機能テストに使用されるテーブル。各種SQLデータ型のマッピングをテストする。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| SomeByte | TINYINT | YES | 1バイト整数値（0-255） |
| SomeBoolean | BIT | YES | 真偽値（0 or 1） |
| SomeDate | DATE | YES | 日付値 |
| SomeDateTime | DATETIME | YES | 日時値 |
| SomeDecimal | DECIMAL(10,5) | YES | 固定小数点数（精度10、スケール5） |
| SomeDouble | FLOAT | YES | 倍精度浮動小数点数 |
| SomeFloat | REAL | YES | 単精度浮動小数点数 |
| SomeGuid | UNIQUEIDENTIFIER | YES | GUID/UUID値 |
| SomeInt32 | INT | YES | 32ビット整数値 |
| SomeInt64 | BIGINT | YES | 64ビット整数値 |
| SomeString | NVARCHAR(100) | YES | Unicode文字列（最大100文字） |

**参照元**: `src/libraries/System.Data.Odbc/tests/SmokeTest.cs`

### 2. SomeTable（ODBC Reader Test用）

ODBC DataReaderの各種テストで使用されるテーブル。テストケースごとに異なるカラム構成で作成される。

#### バリエーション2a: 文字列テスト

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| SomeString | NVARCHAR(100) | YES | Unicode文字列（最大100文字） |

#### バリエーション2b: 整数と文字列テスト

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| SomeInt32 | INT | YES | 32ビット整数値 |
| SomeString | NVARCHAR(100) | YES | Unicode文字列（最大100文字） |

#### バリエーション2c: 64ビット整数テスト

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| SomeInt64 | BIGINT | YES | 64ビット整数値 |

**参照元**: `src/libraries/System.Data.Odbc/tests/ReaderTests.cs`

### 3. CustomerTable（OleDB DataReader Test用）

OleDB APIのDataReader機能テストに使用されるテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| CustomerID | INT | YES | 顧客ID |
| CustomerName | NVARCHAR(40) | YES | 顧客名（最大40文字） |
| SingleAmount | FLOAT | YES | 倍精度浮動小数点数の金額 |
| RealAmount | REAL | YES | 単精度浮動小数点数の金額 |
| DateChecked | DATETIME | YES | 確認日時 |

**参照元**: `src/libraries/System.Data.OleDb/tests/OleDbDataReaderTests.cs`

### 4. PersonTable（OleDB DataAdapter Test用）

OleDB APIのDataAdapter機能テストに使用されるテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| Firstname | NVARCHAR(5) | YES | 名（最大5文字） |
| Lastname | NVARCHAR(40) | YES | 姓（最大40文字） |
| Nickname | NVARCHAR(30) | YES | ニックネーム（最大30文字） |

**参照元**: `src/libraries/System.Data.OleDb/tests/OleDbDataAdapterTests.cs`

### 5. PlantTable（OleDB Command Test用）

OleDB APIのCommand機能テストに使用されるテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| Firstname | NVARCHAR(5) | YES | 名前（最大5文字） |
| NumPlants | INT | YES | 植物の数 |

**参照元**: `src/libraries/System.Data.OleDb/tests/OleDbCommandTests.cs`

## 備考

### プロジェクトの特性

1. **.NET Runtimeはフレームワーク自体のソースコード**であり、エンドユーザーアプリケーションとは異なる
2. **永続的なデータベーススキーマは存在しない** - 上記テーブルはすべてユニットテスト用の一時テーブル
3. テスト実行時に**動的に作成・削除**される
4. **主キー制約や外部キー制約は定義されていない** - テストの簡素化のため

### データアクセスAPIの位置づけ

- `System.Data.Odbc`: ODBC（Open Database Connectivity）経由でのデータベースアクセスを提供
- `System.Data.OleDb`: OLE DB経由でのデータベースアクセスを提供（Windowsのみ）

これらはデータベースに依存しない汎用的なデータアクセスAPIであり、SQL Server、Oracle、MySQL等様々なデータベースへの接続に使用できる。

### テスト環境

- ODBC テストはSQLiteドライバを使用
- OleDB テストはCSVファイルドライバを使用

### 注意事項

- 実際のアプリケーション開発において、本リポジトリのテーブル定義を参照する必要はない
- これらはAPIの動作検証を目的とした最小限のテーブル構造である
