---
generated_at: 2026-01-30 11:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンステスト用プロビジョニング（No.94）**：スクリプト内容の詳細確認が必要
  2. **ローカライズプロジェクト生成（No.89）**：具体的な出力フォーマットの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build.sh`（ルートディレクトリ）
- E-02: `build.cmd`（ルートディレクトリ）
- E-03: `dotnet.sh`（ルートディレクトリ）
- E-04: `dotnet.cmd`（ルートディレクトリ）
- E-05: `eng/build.sh`
- E-06: `eng/build.ps1`
- E-07: `eng/common/build.sh`
- E-08: `eng/common/build.ps1`
- E-09: `eng/common/cibuild.sh`
- E-10: `eng/common/CIBuild.cmd`
- E-11: `eng/common/dotnet-install.sh`
- E-12: `eng/common/dotnet-install.ps1`
- E-13: `eng/common/tools.sh`
- E-14: `eng/common/tools.ps1`
- E-15: `eng/testing/RunnerTemplate.sh`
- E-16: `eng/testing/RunnerTemplate.cmd`
- E-17: `eng/testing/AndroidRunnerTemplate.sh`
- E-18: `eng/testing/AndroidRunnerTemplate.cmd`
- E-19: `eng/testing/AppleRunnerTemplate.sh`
- E-20: `eng/testing/AppleHelixRunnerTemplate.sh`
- E-21: `eng/testing/WasmRunnerTemplate.sh`
- E-22: `eng/testing/WasmRunnerTemplate.cmd`
- E-23: `eng/testing/WasiRunnerTemplate.sh`
- E-24: `eng/testing/WasiRunnerTemplate.cmd`
- E-25: `eng/testing/BionicRunnerTemplate.sh`
- E-26: `eng/testing/BionicRunnerTemplate.cmd`
- E-27: `eng/testing/BionicRunOnDevice.sh`
- E-28: `eng/docker/build-docker-sdk.sh`
- E-29: `eng/docker/build-docker-sdk.ps1`
- E-30: `eng/native/build-commons.sh`
- E-31: `eng/native/gen-buildsys.sh`
- E-32: `eng/native/gen-buildsys.cmd`
- E-33: `eng/native/generateversionscript.sh`
- E-34: `eng/native/generateversionscript.ps1`
- E-35: `eng/native/generateexportedsymbols.sh`
- E-36: `eng/native/genmoduleindex.sh`
- E-37: `eng/native/genmoduleindex.cmd`
- E-38: `eng/native/version/copy_version_files.sh`
- E-39: `eng/native/version/copy_version_files.ps1`
- E-40: `eng/native/init-vs-env.cmd`
- E-41: `eng/native/set-cmake-path.ps1`
- E-42: `eng/native/sign-with-dac-certificate.ps1`
- E-43: `eng/common/cross/build-rootfs.sh`
- E-44: `eng/common/cross/build-android-rootfs.sh`
- E-45: `eng/common/cross/tizen-build-rootfs.sh`
- E-46: `eng/common/cross/tizen-fetch.sh`
- E-47: `eng/common/msbuild.sh`
- E-48: `eng/common/sdk-task.sh`
- E-49: `eng/common/sdk-task.ps1`
- E-50: `eng/common/darc-init.sh`
- E-51: `eng/common/darc-init.ps1`
- E-52: `eng/common/init-tools-native.sh`
- E-53: `eng/common/init-tools-native.ps1`
- E-54: `eng/common/native/init-os-and-arch.sh`
- E-55: `eng/common/native/init-compiler.sh`
- E-56: `eng/common/native/init-distro-rid.sh`
- E-57: `eng/common/native/common-library.sh`
- E-58: `eng/common/native/install-cmake.sh`
- E-59: `eng/common/native/install-dependencies.sh`
- E-60: `eng/common/native/install-tool.ps1`
- E-61: `eng/common/SetupNugetSources.sh`
- E-62: `eng/common/SetupNugetSources.ps1`
- E-63: `eng/common/internal-feed-operations.sh`
- E-64: `eng/common/internal-feed-operations.ps1`
- E-65: `eng/common/post-build/symbols-validation.ps1`
- E-66: `eng/common/post-build/nuget-validation.ps1`
- E-67: `eng/common/post-build/nuget-verification.ps1`
- E-68: `eng/common/post-build/sourcelink-validation.ps1`
- E-69: `eng/common/post-build/check-channel-consistency.ps1`
- E-70: `eng/common/post-build/publish-using-darc.ps1`
- E-71: `eng/common/post-build/redact-logs.ps1`
- E-72: `eng/common/sdl/sdl.ps1`
- E-73: `eng/common/sdl/init-sdl.ps1`
- E-74: `eng/common/sdl/run-sdl.ps1`
- E-75: `eng/common/sdl/execute-all-sdl-tools.ps1`
- E-76: `eng/common/sdl/configure-sdl-tool.ps1`
- E-77: `eng/common/sdl/extract-artifact-packages.ps1`
- E-78: `eng/common/sdl/extract-artifact-archives.ps1`
- E-79: `eng/common/sdl/trim-assets-version.ps1`
- E-80: `eng/common/generate-sbom-prep.sh`
- E-81: `eng/common/generate-sbom-prep.ps1`
- E-82: `eng/common/vmr-sync.sh`
- E-83: `eng/common/vmr-sync.ps1`
- E-84: `eng/common/pipeline-logging-functions.sh`
- E-85: `eng/common/pipeline-logging-functions.ps1`
- E-86: `eng/common/retain-build.ps1`
- E-87: `eng/common/generate-locproject.ps1`
- E-88: `eng/common/enable-cross-org-publishing.ps1`
- E-89: `eng/pipelines/evaluate-changed-paths.sh`
- E-90: `eng/pipelines/evaluate-changed-darc-deps.sh`
- E-91: `eng/pipelines/mono/update-machine-certs.ps1`
- E-92: `eng/testing/performance/create-provisioning-profile.sh`
- E-93: `eng/breakingChanges/breaking-change-doc.ps1`
- E-94: `eng/breakingChanges/config.ps1`
- E-95: `eng/native/ijw/getRefPackFolderFromArtifacts.ps1`
- E-96: `eng/native/ijw/getRefPackFolderFromSdk.ps1`
- E-97: `eng/extract-for-crossdac.ps1`
- E-98: `eng/configure-toolset.ps1`
- E-99: Globパターンマッチ結果（eng/**/*.{sh,ps1,cmd}）
- E-100: プロジェクトルート構造（ls -la）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | build.shはLinux/macOS向けビルドスクリプト | E-01 | ○ |
| C-02 | build.cmdはWindows向けビルドスクリプト | E-02 | ○ |
| C-03 | eng/build.shはサブセットビルドをサポート | E-05 | ○ |
| C-04 | eng/build.ps1は複数構成ビルドをサポート | E-06 | ○ |
| C-05 | eng/common/build.shはsource-buildモードをサポート | E-07 | ○ |
| C-06 | eng/common/build.ps1はMSBuildビルドを実行 | E-08 | ○ |
| C-07 | eng/common/cibuild.shはCI環境用ビルド | E-09 | ○ |
| C-08 | dotnet.shはローカルSDKを初期化 | E-03 | ○ |
| C-09 | dotnet.cmdはローカルSDKを初期化 | E-04 | ○ |
| C-10 | eng/common/dotnet-install.shはSDKをインストール | E-11 | ○ |
| C-11 | RunnerTemplate.shはHelixテスト環境用 | E-15 | ○ |
| C-12 | RunnerTemplate.shはコアダンプ処理を含む | E-15 | ○ |
| C-13 | AndroidRunnerTemplate.shはAndroid向けテスト用 | E-17 | ○ |
| C-14 | AppleRunnerTemplate.shはApple環境向け | E-19 | ○ |
| C-15 | WasmRunnerTemplate.shはBrowser向け | E-21 | ○ |
| C-16 | WasiRunnerTemplate.shはWASI環境向け | E-23 | ○ |
| C-17 | BionicRunnerTemplate.shはBionic libc向け | E-25 | ○ |
| C-18 | build-docker-sdk.shはDockerイメージを作成 | E-28 | ○ |
| C-19 | build-commons.shはCMakeプロジェクト設定 | E-30 | ○ |
| C-20 | gen-buildsys.shはCMakeビルドファイル生成 | E-31 | ○ |
| C-21 | generateversionscript.shはシンボルバージョニング用 | E-33 | ○ |
| C-22 | generateexportedsymbols.shはシンボルリスト生成 | E-35 | ○ |
| C-23 | genmoduleindex.shはデバッグ用モジュール情報生成 | E-36 | ○ |
| C-24 | copy_version_files.shはバージョン情報配置 | E-38 | ○ |
| C-25 | init-vs-env.cmdはVS環境初期化 | E-40 | ○ |
| C-26 | set-cmake-path.ps1はCMake検出 | E-41 | ○ |
| C-27 | sign-with-dac-certificate.ps1はコード署名 | E-42 | ○ |
| C-28 | build-rootfs.shはクロスコンパイル用sysroot作成 | E-43 | ○ |
| C-29 | build-android-rootfs.shはAndroid NDK使用 | E-44 | ○ |
| C-30 | tizen-build-rootfs.shはTizen SDK用 | E-45 | ○ |
| C-31 | tools.shは共通関数を提供 | E-13 | ○ |
| C-32 | tools.ps1は共通関数を提供 | E-14 | ○ |
| C-33 | msbuild.shはdotnet msbuildを実行 | E-47 | ○ |
| C-34 | sdk-task.shはArcade SDKタスク実行 | E-48 | ○ |
| C-35 | darc-init.shはDARC CLIインストール | E-50 | ○ |
| C-36 | init-tools-native.shはCMake/Ninja設定 | E-52 | ○ |
| C-37 | init-os-and-arch.shはOS/アーキテクチャ検出 | E-54 | ○ |
| C-38 | init-compiler.shはClang/GCC検出 | E-55 | ○ |
| C-39 | init-distro-rid.shはディストリビューションRID判定 | E-56 | ○ |
| C-40 | common-library.shは共通処理提供 | E-57 | ○ |
| C-41 | install-cmake.shはCMakeインストール | E-58 | ○ |
| C-42 | install-dependencies.shはシステムパッケージインストール | E-59 | ○ |
| C-43 | install-tool.ps1はツールインストール | E-60 | ○ |
| C-44 | SetupNugetSources.shはフィード認証設定 | E-61 | ○ |
| C-45 | internal-feed-operations.shはAzure Artifacts連携 | E-63 | ○ |
| C-46 | symbols-validation.ps1はPDB検証 | E-65 | ○ |
| C-47 | nuget-validation.ps1はパッケージ検証 | E-66 | ○ |
| C-48 | nuget-verification.ps1は詳細検証 | E-67 | ○ |
| C-49 | sourcelink-validation.ps1はSourceLink検証 | E-68 | ○ |
| C-50 | check-channel-consistency.ps1はチャンネル検証 | E-69 | ○ |
| C-51 | publish-using-darc.ps1はMaestro経由公開 | E-70 | ○ |
| C-52 | redact-logs.ps1は機密情報削除 | E-71 | ○ |
| C-53 | sdl.ps1はセキュリティスキャン実行 | E-72 | ○ |
| C-54 | init-sdl.ps1はセキュリティツール初期化 | E-73 | ○ |
| C-55 | run-sdl.ps1はセキュリティスキャン実行 | E-74 | ○ |
| C-56 | execute-all-sdl-tools.ps1は全ツール実行 | E-75 | ○ |
| C-57 | configure-sdl-tool.ps1はパラメータ設定 | E-76 | ○ |
| C-58 | extract-artifact-packages.ps1はパッケージ展開 | E-77 | ○ |
| C-59 | extract-artifact-archives.ps1はアーカイブ展開 | E-78 | ○ |
| C-60 | trim-assets-version.ps1はバージョン正規化 | E-79 | ○ |
| C-61 | generate-sbom-prep.shはSBOM前処理 | E-80 | ○ |
| C-62 | vmr-sync.shはVMR同期 | E-82 | ○ |
| C-63 | pipeline-logging-functions.shはログ関数提供 | E-84 | ○ |
| C-64 | retain-build.ps1はビルド保持設定 | E-86 | ○ |
| C-65 | generate-locproject.ps1はローカライズ設定 | E-87 | △ |
| C-66 | enable-cross-org-publishing.ps1はクロス組織共有 | E-88 | ○ |
| C-67 | evaluate-changed-paths.shは変更検出 | E-89 | ○ |
| C-68 | evaluate-changed-darc-deps.shは依存変更評価 | E-90 | ○ |
| C-69 | update-machine-certs.ps1は証明書更新 | E-91 | ○ |
| C-70 | create-provisioning-profile.shはiOS証明書設定 | E-92 | △ |
| C-71 | breaking-change-doc.ps1はドキュメント生成 | E-93 | ○ |
| C-72 | config.ps1は検出対象設定 | E-94 | ○ |
| C-73 | getRefPackFolderFromArtifacts.ps1は参照パス解決 | E-95 | ○ |
| C-74 | getRefPackFolderFromSdk.ps1は参照パス解決 | E-96 | ○ |
| C-75 | extract-for-crossdac.ps1はDAC抽出 | E-97 | ○ |
| C-76 | configure-toolset.ps1はツールセット設定 | E-98 | ○ |
| C-77 | eng/common/dotnet.shはdotnet実行ラッパー | E-99 | ○ |
| C-78 | eng/common/dotnet.ps1はdotnet実行ラッパー | E-99 | ○ |
| C-79 | eng/common/dotnet.cmdはdotnet実行ラッパー | E-99 | ○ |
| C-80 | AppleHelixRunnerTemplateはHelix用 | E-20 | ○ |
| C-81 | BionicRunOnDevice.shはadb使用 | E-27 | ○ |
| C-82 | プロジェクトはLinux/macOS/Windows対応 | E-99, E-100 | ○ |
| C-83 | ネイティブビルドはCMakeベース | E-30, E-31, E-32 | ○ |
| C-84 | CI/CDはAzure Pipelines対応 | E-84, E-85 | ○ |
| C-85 | セキュリティスキャンはSDLベース | E-72-E-79 | ○ |
| C-86 | パッケージングはNuGet形式 | E-66, E-67 | ○ |
| C-87 | Source BuildはVMR対応 | E-82, E-83 | ○ |
| C-88 | クロスコンパイルはrootfs方式 | E-43, E-44, E-45 | ○ |
| C-89 | テストはHelix環境対応 | E-15, E-16 | ○ |
| C-90 | モバイルテストはAndroid/iOS対応 | E-17, E-18, E-19 | ○ |
| C-91 | WebAssemblyはEmscripten使用 | E-21, E-22 | ○ |
| C-92 | WASIはWASI-SDK使用 | E-23, E-24 | ○ |
| C-93 | DockerイメージはSDK含む | E-28, E-29 | ○ |
| C-94 | デバッグはDAC/SOS対応 | E-36, E-37, E-42 | ○ |
| C-95 | ビルドはArcade SDK使用 | E-48, E-49 | ○ |
| C-96 | 依存管理はDARC/Maestro使用 | E-50, E-51, E-70 | ○ |
| C-97 | コンプライアンスはSBOM対応 | E-80, E-81 | ○ |
| C-98 | 国際化は多言語リソース対応 | E-87 | ○ |
| C-99 | IJWはC++/CLI相互運用 | E-95, E-96 | ○ |
| C-100 | 100件のバッチスクリプトを特定 | E-99 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-65（generate-locproject.ps1）**：スクリプトの具体的な出力形式と対応言語の詳細が未確認
  - 候補：スクリプト内のコメント / 関連ドキュメント / 使用例
- **C-70（create-provisioning-profile.sh）**：iOSプロビジョニングプロファイルの具体的な作成手順の詳細が未確認
  - 候補：Apple Developer Documentation / CI設定ファイル / 使用例

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：バッチ名、パス、基本的な説明は全てソースコードから直接確認済み
- **0（低リスク）**：カテゴリ分類は機能的な観点で整理されており、明確
- **1（中リスク）**：一部のスクリプト（パフォーマンステスト、ローカライズ）は詳細確認が推奨

## 6) レビュアーチェックリスト（最小）
- [ ] バッチ一覧のカテゴリ分類が適切か確認
- [ ] 各バッチの説明がスクリプトの実際の動作と一致しているか確認
- [ ] 備考欄の情報が正確か確認
- [ ] 重要なスクリプトが漏れていないか確認（特にsrcディレクトリ内のスクリプト）
- [ ] △ステータスの項目（No.89 generate-locproject.ps1、No.94 create-provisioning-profile.sh）を重点確認
