# バッチ設計書 1-build.sh

## 概要

本ドキュメントは、.NET Runtimeプロジェクトのルートディレクトリに配置されたLinux/macOS向けプロジェクトビルドスクリプト `build.sh` の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、.NET Runtimeプロジェクト全体のビルドを実行するためのエントリーポイントスクリプトである。開発者やCI/CDシステムがプロジェクトをビルドする際に最初に呼び出されるスクリプトであり、プラットフォームに応じて適切なビルドスクリプトに処理を委譲する。

**業務上の目的・背景**：.NET Runtimeは複数のプラットフォーム（Linux、macOS、Windows）をサポートする大規模プロジェクトであり、開発者が統一されたインターフェースでビルドを実行できる必要がある。このスクリプトは、実行環境を自動検出し、Cygwin/MinGW環境ではWindowsバッチファイル（build.cmd）を、それ以外のUnix系環境では `eng/build.sh` を呼び出すことで、プラットフォーム間の差異を吸収する。

**バッチの実行タイミング**：開発者による手動実行、またはCI/CDパイプラインからの自動実行。プルリクエスト作成時、マージ時、定期ビルド時など様々なタイミングで実行される。

**主要な処理内容**：
1. シンボリックリンクの解決（スクリプトの実際のパスを特定）
2. 実行環境の検出（Cygwin/MinGW環境かどうかの判定）
3. プラットフォームに応じたビルドスクリプトへの処理委譲
4. コマンドライン引数の透過的な受け渡し

**前後の処理との関連**：このスクリプトは `eng/build.sh`（Unix系）または `build.cmd`（Windows系）を呼び出す。`eng/build.sh` はさらに `eng/common/build.sh` を呼び出してMSBuildによるビルドを実行する。

**影響範囲**：プロジェクト全体のビルドプロセス、成果物の生成、テスト実行に影響する。ビルド成果物は `artifacts/` ディレクトリ配下に出力される。

## バッチ種別

ビルド実行 / プラットフォーム振り分け

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bashシェル | Bash互換シェルが利用可能であること |
| 実行権限 | スクリプトに実行権限が付与されていること |
| プロジェクト構成 | eng/build.sh および build.cmd が存在すること |

### 実行可否判定

スクリプトは常に実行可能。実行環境に応じて適切なビルドスクリプトに処理を委譲する。Cygwin/MinGW環境の場合はWindows向けスクリプト、それ以外はUnix向けスクリプトを呼び出す。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $@ | string[] | No | なし | 任意のコマンドライン引数（eng/build.sh または build.cmd にそのまま渡される） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| BASH_SOURCE[0] | 環境変数 | スクリプト自身のパス |
| uname -s | コマンド出力 | OS名の取得 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力/標準エラー | テキスト | 委譲先スクリプトの出力がそのまま出力される |

### 出力ファイル仕様

このスクリプト自体はファイル出力を行わない。委譲先のビルドスクリプトがビルド成果物を出力する。

| 項目 | 内容 |
|-----|------|
| ファイル名 | 委譲先スクリプトに依存 |
| 出力先 | artifacts/ ディレクトリ配下 |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. スクリプトパスの初期化
   └─ BASH_SOURCE[0] から source 変数を設定
2. シンボリックリンクの解決
   └─ シンボリックリンクの場合、実際のパスを解決
3. スクリプトルートディレクトリの特定
   └─ cd -P と dirname を使用して絶対パスを取得
4. プラットフォーム判定
   └─ is_cygwin_or_mingw 関数でOS名を確認
5. ビルドスクリプトの呼び出し
   └─ Cygwin/MinGW: build.cmd を実行
   └─ その他: eng/build.sh を実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[BASH_SOURCE からパス取得]
    B --> C{シンボリックリンク?}
    C -->|Yes| D[リンク先を解決]
    D --> C
    C -->|No| E[scriptroot を設定]
    E --> F{Cygwin/MinGW?}
    F -->|Yes| G[build.cmd を実行]
    F -->|No| H[eng/build.sh を実行]
    G --> I[バッチ終了]
    H --> I
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベース操作は行わない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | 委譲先エラー | eng/build.sh または build.cmd がエラー終了 | 委譲先スクリプトのエラーメッセージを確認 |
| 1 | ファイル不在 | 委譲先スクリプトが存在しない | プロジェクト構成を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージを確認し、委譲先スクリプトの問題を特定
2. 必要に応じて環境変数や前提条件を確認
3. プロジェクトの依存関係やSDKのインストール状態を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行 |
| 目標処理時間 | スクリプト自体は1秒未満（ビルド全体は構成による） |
| メモリ使用量上限 | 最小限（数MB） |

## 排他制御

同時実行の制御はこのスクリプトでは行わない。複数の同時ビルドは委譲先のビルドシステムやCI/CDシステムで管理される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | 処理中 | 委譲先スクリプトの出力 |
| 標準エラー | エラー発生時 | 委譲先スクリプトのエラー出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | CI/CDシステム |
| 実行時間 | 構成による | CI/CDシステム |

## 備考

- このスクリプトはプロジェクトルートディレクトリに配置されており、開発者にとって最も発見しやすいエントリーポイントとなっている
- Cygwin/MinGW環境の検出は `uname -s` の出力に基づいて行われる
- すべてのコマンドライン引数は変更なしで委譲先スクリプトに渡される
