# バッチ設計書 10-dotnet.cmd

## 概要

本ドキュメントは、.NET Runtimeプロジェクトの `dotnet.cmd` - dotnet CLIラッパースクリプト（Windows）の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、Windows環境でプロジェクト固有の.NET SDKバージョンを使用してdotnet CLIコマンドを実行するためのラッパースクリプトである。プロジェクトルートに配置され、開発者がグローバルにインストールされたSDKではなく、プロジェクトで指定されたSDKバージョンを確実に使用できるようにする。

**業務上の目的・背景**：.NET Runtimeプロジェクトは特定のSDKバージョンを使用してビルドする必要がある。Windows環境での開発において、グローバルSDKとの競合を避け、プロジェクト固有のSDKバージョンでの一貫したビルドを実現するために、このスクリプトがローカルSDKを自動的に初期化して使用する。

**バッチの実行タイミング**：開発者による手動実行。`.\dotnet.cmd build`、`.\dotnet.cmd test` などの形式で使用される。

**主要な処理内容**：
1. PowerShellでtools.ps1を読み込み、InitializeDotNetCliを実行
2. artifacts/toolset/sdk.txtからSDKパスを取得
3. Platform環境変数のクリア
4. DOTNET_SKIP_FIRST_TIME_EXPERIENCEの設定
5. ローカルSDKのdotnetコマンドの実行

**前後の処理との関連**：`eng/common/tools.ps1` を読み込んでSDK初期化関数を使用する。`dotnet.sh` のWindows版である。

**影響範囲**：dotnetコマンドの実行環境に影響する。プロジェクト固有のSDKバージョンが使用されることを保証する。

## バッチ種別

SDK管理 / CLIラッパー

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows OS | Windows環境での実行 |
| PowerShell | PowerShellが利用可能であること |
| ネットワーク接続 | SDKダウンロードに必要（初回のみ） |
| eng/common/tools.ps1 | 共通ツール関数が存在すること |

### 実行可否判定

スクリプトは常に実行可能。SDKが未インストールの場合は自動的にダウンロードされる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| %* | string | No | なし | dotnetコマンドに渡す引数（build, test, run等） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| %~dp0 | バッチ変数 | スクリプトのディレクトリパス |
| eng/common/tools.ps1 | PowerShellスクリプト | SDK初期化関数の提供 |
| artifacts/toolset/sdk.txt | テキストファイル | SDKパス情報 |
| global.json | JSON | プロジェクトで使用するSDKバージョンの定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | dotnetコマンドの出力 |
| 標準エラー | テキスト | dotnetコマンドのエラー出力 |
| artifacts/toolset/sdk.txt | テキスト | 初期化されたSDKパス |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | sdk.txt |
| 出力先 | artifacts/toolset/ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. エコー出力の抑制
   └─ @echo off
2. SDK の初期化
   └─ PowerShell で tools.ps1 を読み込み
   └─ InitializeDotNetCli $true $true を実行
3. エラーチェック
   └─ ERRORLEVEL が 0 でない場合はエラー終了
4. SDK パスの取得
   └─ artifacts/toolset/sdk.txt からパスを読み込み
5. Platform 環境変数のクリア
   └─ HP PC等での問題を回避
6. 初回実行体験の無効化
   └─ DOTNET_SKIP_FIRST_TIME_EXPERIENCE=1 を設定
7. dotnet コマンドの実行
   └─ ローカルSDKのdotnet.exeに引数を渡して実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[echo off]
    B --> C[PowerShell で SDK 初期化]
    C --> D{ERRORLEVEL = 0?}
    D -->|No| E[エラー出力]
    E --> F[exit /b ERRORLEVEL]
    D -->|Yes| G[sdk.txt からパス取得]
    G --> H[Platform 環境変数クリア]
    H --> I[DOTNET_SKIP_FIRST_TIME_EXPERIENCE=1]
    I --> J[dotnet.exe 実行]
    J --> K[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベース操作は行わない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | dotnetエラー | dotnetコマンドがエラー終了 | エラーメッセージを確認 |
| 非0 | SDK初期化エラー | SDKのダウンロードまたは初期化に失敗 | ネットワーク接続を確認 |
| 非0 | PowerShellエラー | tools.ps1の実行に失敗 | PowerShellのインストール状態を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージを確認（"Failed to install or invoke dotnet..."）
2. SDKのダウンロードに問題がある場合はネットワーク接続を確認
3. artifacts/toolset ディレクトリを削除してSDKを再ダウンロード
4. PowerShellの実行ポリシーを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のコマンド実行 |
| 目標処理時間 | SDK初期化後は即座に実行（初回はダウンロード時間が必要） |
| メモリ使用量上限 | dotnetコマンドに依存 |

## 排他制御

同時実行の制御はこのスクリプトでは行わない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | 処理中 | dotnetコマンドの出力 |
| 標準エラー | エラー発生時 | "Failed to install or invoke dotnet..." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | 呼び出し元 |

## 備考

- Platform環境変数は一部のHP PC等で'MCD'に設定されていることがあり、ビルドの問題を引き起こすためクリアされる（issue #69参照）
- DOTNET_SKIP_FIRST_TIME_EXPERIENCE=1 により、dotnetの初回実行時のwelcomeメッセージやNuGetキャッシュの準備をスキップする
- InitializeDotNetCli の第1引数 `$true` はSDKのインストールを行うことを示す
- InitializeDotNetCli の第2引数 `$true` はSDKパスをファイルに出力することを示す
- SDKパスは artifacts/toolset/sdk.txt に保存され、`set /p` で読み込まれる
- グローバルにインストールされたdotnetではなく、プロジェクト固有のSDKを使用することで、ビルドの再現性を確保
- このスクリプトは `dotnet.sh` と対になるWindows版スクリプトである
